/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.time;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;

public class FirstGroupByPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    static final Logger log = Logger.getLogger(FirstGroupByPerTimeOutputRateLimiter.class);
    private String id;
    private final Long value;
    private List<String> groupByKeys = new ArrayList<String>();
    private ComplexEventChunk<ComplexEvent> allComplexEventChunk;
    private ScheduledExecutorService scheduledExecutorService;
    private Scheduler scheduler;
    private long scheduledTime;
    private String queryName;

    public FirstGroupByPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, String queryName) {
        this.queryName = queryName;
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
        this.allComplexEventChunk = new ComplexEventChunk(false);
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstGroupByPerTimeOutputRateLimiter instance = new FirstGroupByPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.queryName);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList outputEventChunks = new ArrayList();
        complexEventChunk.reset();
        FirstGroupByPerTimeOutputRateLimiter firstGroupByPerTimeOutputRateLimiter = this;
        synchronized (firstGroupByPerTimeOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                GroupedComplexEvent groupedComplexEvent;
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    if (object.getTimestamp() < this.scheduledTime) continue;
                    if (this.allComplexEventChunk.getFirst() != null) {
                        ComplexEventChunk<ComplexEvent> eventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                        eventChunk.add(this.allComplexEventChunk.getFirst());
                        this.allComplexEventChunk.clear();
                        this.groupByKeys.clear();
                        outputEventChunks.add(eventChunk);
                    } else {
                        this.groupByKeys.clear();
                    }
                    this.scheduledTime += this.value.longValue();
                    this.scheduler.notifyAt(this.scheduledTime);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED || this.groupByKeys.contains((groupedComplexEvent = (GroupedComplexEvent)object).getGroupKey())) continue;
                complexEventChunk.remove();
                this.groupByKeys.add(groupedComplexEvent.getGroupKey());
                this.allComplexEventChunk.add(groupedComplexEvent.getComplexEvent());
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this.scheduledExecutorService, this, this.executionPlanContext);
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.queryName);
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, ComplexEventChunk<ComplexEvent>>("AllComplexEventChunk", this.allComplexEventChunk), new AbstractMap.SimpleEntry<String, List<String>>("GroupByKeys", this.groupByKeys)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.allComplexEventChunk = (ComplexEventChunk)stateEntry.getValue();
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.groupByKeys = (List)stateEntry2.getValue();
    }
}

