/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.event;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;

public class LastGroupByPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private volatile int counter = 0;
    private Map<String, ComplexEvent> allGroupByKeyEvents = new LinkedHashMap<String, ComplexEvent>();

    public LastGroupByPerEventOutputRateLimiter(String id, Integer value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        LastGroupByPerEventOutputRateLimiter instance = new LastGroupByPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList outputEventChunks = new ArrayList();
        LastGroupByPerEventOutputRateLimiter lastGroupByPerEventOutputRateLimiter = this;
        synchronized (lastGroupByPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED) continue;
                complexEventChunk.remove();
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)object;
                this.allGroupByKeyEvents.put(groupedComplexEvent.getGroupKey(), groupedComplexEvent.getComplexEvent());
                if (++this.counter != this.value) continue;
                this.counter = 0;
                if (this.allGroupByKeyEvents.size() == 0) continue;
                ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                for (ComplexEvent complexEvent : this.allGroupByKeyEvents.values()) {
                    outputEventChunk.add(complexEvent);
                }
                this.allGroupByKeyEvents.clear();
                outputEventChunks.add(outputEventChunk);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, Map<String, ComplexEvent>>("AllGroupByKeyEvents", this.allGroupByKeyEvents), new AbstractMap.SimpleEntry<String, Integer>("Counter", this.counter)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.allGroupByKeyEvents = (Map)stateEntry.getValue();
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.counter = (Integer)stateEntry2.getValue();
    }
}

