/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class MinimumFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        Attribute.Type attributeTypeOne = attributeExpressionExecutors[0].getReturnType();
        if (attributeTypeOne != Attribute.Type.DOUBLE && attributeTypeOne != Attribute.Type.INT && attributeTypeOne != Attribute.Type.FLOAT && attributeTypeOne != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument1 of minimum() function, required " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.DOUBLE + ", but found " + attributeTypeOne.toString());
        }
        for (int i = 1; i < attributeExpressionExecutors.length; ++i) {
            Attribute.Type attributeType = attributeExpressionExecutors[i].getReturnType();
            if (attributeType != Attribute.Type.DOUBLE && attributeType != Attribute.Type.INT && attributeType != Attribute.Type.FLOAT && attributeType != Attribute.Type.LONG) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the argument" + i + " of minimum() function, " + "required " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.DOUBLE + ", but found " + attributeType.toString());
            }
            if (attributeTypeOne == attributeType) continue;
            throw new ExecutionPlanValidationException("Invalid parameter type found for arguments  of minimum() function, all parameters should be of same type, but found " + attributeTypeOne + " and " + attributeExpressionExecutors[i].getReturnType());
        }
        this.returnType = attributeTypeOne;
    }

    @Override
    protected Object execute(Object[] data) {
        double min = Double.MAX_VALUE;
        for (Object aObj : data) {
            Double value = Double.MAX_VALUE;
            if (aObj instanceof Integer) {
                int inputInt = (Integer)aObj;
                value = inputInt;
            } else if (aObj instanceof Long) {
                long inputLong = (Long)aObj;
                value = inputLong;
            } else if (aObj instanceof Float) {
                float inputLong = ((Float)aObj).floatValue();
                value = inputLong;
            } else if (aObj instanceof Double) {
                value = (Double)aObj;
            }
            if (!(value < min)) continue;
            min = value;
        }
        switch (this.returnType) {
            case INT: {
                return (int)min;
            }
            case LONG: {
                return (long)min;
            }
            case FLOAT: {
                return Float.valueOf((float)min);
            }
            case DOUBLE: {
                return min;
            }
        }
        return min;
    }

    @Override
    protected Object execute(Object data) {
        return data;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object[] currentState() {
        return new Object[0];
    }

    @Override
    public void restoreState(Object[] state) {
    }
}

