/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueClearCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToMaxSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.QueueOfferCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePeekCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePollCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePutCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemainingCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueTakeCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.queue.QueueIterator;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.Preconditions;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public final class ClientQueueProxy<E>
extends PartitionSpecificClientProxy
implements IQueue<E> {
    public ClientQueueProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        Preconditions.isNotNull(listener, "listener");
        ItemEventHandler eventHandler = new ItemEventHandler(includeValue, listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return QueueAddListenerCodec.encodeRequest(ClientQueueProxy.this.name, includeValue, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return QueueAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return QueueRemoveListenerCodec.encodeRequest(ClientQueueProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return QueueRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removeItemListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full!");
    }

    @Override
    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = QueuePutCodec.encodeRequest(this.name, data);
        this.invokeOnPartitionInterruptibly(request);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(e, "item can't be null");
        Data data = this.toData(e);
        ClientMessage request = QueueOfferCodec.encodeRequest(this.name, data, unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        QueueOfferCodec.ResponseParameters resultParameters = QueueOfferCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public E take() throws InterruptedException {
        ClientMessage request = QueueTakeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        QueueTakeCodec.ResponseParameters resultParameters = QueueTakeCodec.decodeResponse(response);
        return (E)this.toObject(resultParameters.response);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = QueuePollCodec.encodeRequest(this.name, unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        QueuePollCodec.ResponseParameters resultParameters = QueuePollCodec.decodeResponse(response);
        return (E)this.toObject(resultParameters.response);
    }

    @Override
    public int remainingCapacity() {
        ClientMessage request = QueueRemainingCapacityCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueRemainingCapacityCodec.ResponseParameters resultParameters = QueueRemainingCapacityCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean remove(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueRemoveCodec.encodeRequest(this.name, data);
        ClientMessage response = this.invokeOnPartition(request);
        QueueRemoveCodec.ResponseParameters resultParameters = QueueRemoveCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean contains(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueContainsCodec.encodeRequest(this.name, data);
        ClientMessage response = this.invokeOnPartition(request);
        QueueContainsCodec.ResponseParameters resultParameters = QueueContainsCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public int drainTo(Collection<? super E> objects) {
        ClientMessage request = QueueDrainToCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueDrainToCodec.ResponseParameters resultParameters = QueueDrainToCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.response;
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            objects.add(e);
        }
        return resultCollection.size();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        ClientMessage request = QueueDrainToMaxSizeCodec.encodeRequest(this.name, maxElements);
        ClientMessage response = this.invokeOnPartition(request);
        QueueDrainToMaxSizeCodec.ResponseParameters resultParameters = QueueDrainToMaxSizeCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.response;
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            c.add(e);
        }
        return resultCollection.size();
    }

    @Override
    public E remove() {
        E res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public E poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public E element() {
        E res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public E peek() {
        ClientMessage request = QueuePeekCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueuePeekCodec.ResponseParameters resultParameters = QueuePeekCodec.decodeResponse(response);
        return (E)this.toObject(resultParameters.response);
    }

    @Override
    public int size() {
        ClientMessage request = QueueSizeCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueSizeCodec.ResponseParameters resultParameters = QueueSizeCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = QueueIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIsEmptyCodec.ResponseParameters resultParameters = QueueIsEmptyCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public Iterator<E> iterator() {
        ClientMessage request = QueueIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.response;
        return new QueueIterator(resultCollection.iterator(), this.getSerializationService(), false);
    }

    @Override
    public Object[] toArray() {
        ClientMessage request = QueueIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.response;
        int i = 0;
        Object[] array = new Object[resultCollection.size()];
        for (Data data : resultCollection) {
            array[i++] = this.toObject(data);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        ClientMessage request = QueueIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.response;
        int size = resultCollection.size();
        if (ts.length < size) {
            ts = (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Data data : resultCollection) {
            ts[i++] = this.toObject(data);
        }
        return ts;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Preconditions.checkNotNull(c);
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueContainsAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        QueueContainsAllCodec.ResponseParameters resultParameters = QueueContainsAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Preconditions.checkNotNull(c);
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueAddAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        QueueAddAllCodec.ResponseParameters resultParameters = QueueAddAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Preconditions.checkNotNull(c);
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueCompareAndRemoveAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        QueueCompareAndRemoveAllCodec.ResponseParameters resultParameters = QueueCompareAndRemoveAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Preconditions.checkNotNull(c);
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueCompareAndRetainAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        QueueCompareAndRetainAllCodec.ResponseParameters resultParameters = QueueCompareAndRetainAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void clear() {
        ClientMessage request = QueueClearCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    public String toString() {
        return "IQueue{name='" + this.name + '\'' + '}';
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final boolean includeValue;
        private final ItemListener<E> listener;

        public ItemEventHandler(boolean includeValue, ItemListener<E> listener) {
            this.includeValue = includeValue;
            this.listener = listener;
        }

        @Override
        public void handleItemEventV10(Data dataItem, String uuid, int eventType) {
            Member member = ClientQueueProxy.this.getContext().getClusterService().getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientQueueProxy.this.name, ItemEventType.getByType(eventType), dataItem, member, ClientQueueProxy.this.getSerializationService());
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded(itemEvent);
            } else {
                this.listener.itemRemoved(itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

