/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.lambda.model.Concurrency;
import com.amazonaws.services.lambda.model.FunctionCodeLocation;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import java.io.Serializable;
import java.util.Map;

public class GetFunctionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private FunctionConfiguration configuration;
    private FunctionCodeLocation code;
    private SdkInternalMap<String, String> tags;
    private Concurrency concurrency;

    public void setConfiguration(FunctionConfiguration configuration) {
        this.configuration = configuration;
    }

    public FunctionConfiguration getConfiguration() {
        return this.configuration;
    }

    public GetFunctionResult withConfiguration(FunctionConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setCode(FunctionCodeLocation code) {
        this.code = code;
    }

    public FunctionCodeLocation getCode() {
        return this.code;
    }

    public GetFunctionResult withCode(FunctionCodeLocation code) {
        this.setCode(code);
        return this;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalMap();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new SdkInternalMap<String, String>(tags);
    }

    public GetFunctionResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public GetFunctionResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new SdkInternalMap();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public GetFunctionResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setConcurrency(Concurrency concurrency) {
        this.concurrency = concurrency;
    }

    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    public GetFunctionResult withConcurrency(Concurrency concurrency) {
        this.setConcurrency(concurrency);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getCode() != null) {
            sb.append("Code: ").append(this.getCode()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getConcurrency() != null) {
            sb.append("Concurrency: ").append(this.getConcurrency());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResult)) {
            return false;
        }
        GetFunctionResult other = (GetFunctionResult)obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getCode() == null ^ this.getCode() == null) {
            return false;
        }
        if (other.getCode() != null && !other.getCode().equals(this.getCode())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getConcurrency() == null ^ this.getConcurrency() == null) {
            return false;
        }
        return other.getConcurrency() == null || other.getConcurrency().equals(this.getConcurrency());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCode() == null ? 0 : this.getCode().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getConcurrency() == null ? 0 : this.getConcurrency().hashCode());
        return hashCode;
    }

    public GetFunctionResult clone() {
        try {
            return (GetFunctionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

