/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.slf4j.MDC;

@SuppressForbidden(reason="class is specific to log4j")
public class SolrLogLayout
extends Layout {
    @SuppressForbidden(reason="Need currentTimeMillis to compare against log event timestamp. This is inaccurate but unavoidable due to interface limitations, in any case this is just for logging.")
    final long startTime;
    long lastTime;
    Map<Method, String> methodAlias;
    Map<Integer, CoreInfo> coreInfoMap;
    public Map<String, String> classAliases;
    public boolean shorterFormat;
    private Method classAndMethod;

    public SolrLogLayout() {
        this.lastTime = this.startTime = System.currentTimeMillis();
        this.methodAlias = new HashMap<Method, String>();
        this.coreInfoMap = new WeakHashMap<Integer, CoreInfo>();
        this.classAliases = new HashMap<String, String>();
        this.shorterFormat = false;
        this.classAndMethod = new Method(null, null);
    }

    public void appendThread(StringBuilder sb, LoggingEvent event) {
        Thread th = Thread.currentThread();
        sb.append(" T");
        sb.append(th.getId());
    }

    public String format(LoggingEvent event) {
        return this._format(event);
    }

    public String _format(LoggingEvent event) {
        Throwable th;
        String message = (String)event.getMessage();
        if (message == null) {
            message = "";
        }
        StringBuilder sb = new StringBuilder(message.length() + 80);
        long now = event.timeStamp;
        long timeFromStart = now - this.startTime;
        long timeSinceLast = now - this.lastTime;
        this.lastTime = now;
        String shortClassName = this.getShortClassName(event.getLocationInformation().getClassName(), event.getLocationInformation().getMethodName());
        SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
        SolrQueryRequest req = requestInfo == null ? null : requestInfo.getReq();
        SolrCore core = req == null ? null : req.getCore();
        ZkController zkController = null;
        CoreInfo info = null;
        if (core != null) {
            info = this.coreInfoMap.get(core.hashCode());
            if (info == null) {
                info = new CoreInfo();
                info.shortId = "C" + Integer.toString(CoreInfo.maxCoreNum++);
                this.coreInfoMap.put(core.hashCode(), info);
                if (sb.length() == 0) {
                    sb.append("ASYNC ");
                }
                sb.append(" NEW_CORE " + info.shortId);
                sb.append(" name=" + core.getName());
                sb.append(" " + core);
            }
            if ((zkController = core.getCoreDescriptor().getCoreContainer().getZkController()) != null) {
                if (info.url == null) {
                    info.url = zkController.getBaseUrl() + "/" + core.getName();
                    sb.append(" url=" + info.url + " node=" + zkController.getNodeName());
                }
                Map<String, Object> coreProps = this.getReplicaProps(zkController, core);
                if (info.coreProps == null || !coreProps.equals(info.coreProps)) {
                    info.coreProps = coreProps;
                    String corePropsString = "coll:" + core.getCoreDescriptor().getCloudDescriptor().getCollectionName() + " core:" + core.getName() + " props:" + coreProps;
                    sb.append(" " + info.shortId + "_STATE=" + corePropsString);
                }
            }
        }
        if (sb.length() > 0) {
            sb.append('\n');
        }
        sb.append(timeFromStart);
        this.appendThread(sb, event);
        this.appendMDC(sb);
        if (info != null) {
            sb.append(' ').append(info.shortId);
        }
        if (shortClassName.length() > 0) {
            sb.append(' ').append(shortClassName);
        }
        if (event.getLevel() != Level.INFO) {
            sb.append(' ').append(event.getLevel());
        }
        sb.append(' ');
        this.appendMultiLineString(sb, message);
        ThrowableInformation thInfo = event.getThrowableInformation();
        if (thInfo != null && (th = event.getThrowableInformation().getThrowable()) != null) {
            sb.append(' ');
            String err = SolrException.toStr(th);
            String ignoredMsg = SolrException.doIgnore(th, err);
            if (ignoredMsg != null) {
                sb.append(ignoredMsg);
            } else {
                sb.append(err);
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private Map<String, Object> getReplicaProps(ZkController zkController, SolrCore core) {
        String collection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        Replica replica = zkController.getClusterState().getReplica(collection, zkController.getCoreNodeName(core.getCoreDescriptor()));
        if (replica != null) {
            return replica.getProperties();
        }
        return Collections.EMPTY_MAP;
    }

    private void addFirstLine(StringBuilder sb, String msg) {
        if (!this.shorterFormat || !msg.startsWith("[")) {
            sb.append(msg);
            return;
        }
        int idx = msg.indexOf(93);
        if (idx < 0 || !msg.startsWith(" webapp=", idx + 1)) {
            sb.append(msg);
            return;
        }
        if ((idx = msg.indexOf(32, idx + 8)) < 0) {
            sb.append(msg);
            return;
        }
        if ((idx = msg.indexOf(61, idx + 1)) < 0) {
            sb.append(msg);
            return;
        }
        int idx2 = msg.indexOf(32, idx + 1);
        if (idx2 < 0) {
            sb.append(msg);
            return;
        }
        sb.append(msg.substring(idx + 1, idx2 + 1));
        idx = msg.indexOf("params=", idx2);
        if (idx < 0) {
            sb.append(msg.substring(idx2));
        } else {
            sb.append(msg.substring(idx + 7));
        }
    }

    private void appendMultiLineString(StringBuilder sb, String msg) {
        int idx = msg.indexOf(10);
        if (idx < 0) {
            this.addFirstLine(sb, msg);
            return;
        }
        int lastIdx = -1;
        while (true) {
            if (idx < 0) {
                if (lastIdx == -1) {
                    this.addFirstLine(sb, msg.substring(lastIdx + 1));
                    break;
                }
                sb.append(msg.substring(lastIdx + 1));
                break;
            }
            if (lastIdx == -1) {
                this.addFirstLine(sb, msg.substring(lastIdx + 1, idx));
            } else {
                sb.append(msg.substring(lastIdx + 1, idx));
            }
            sb.append("\n\t");
            lastIdx = idx;
            idx = msg.indexOf(10, lastIdx + 1);
        }
    }

    public void setShorterFormat() {
        this.shorterFormat = true;
        this.methodAlias.put(new Method("org.apache.solr.update.processor.LogUpdateProcessor", "finish"), "");
    }

    private String getShortClassName(String name, String method) {
        int idx;
        this.classAndMethod.className = name;
        this.classAndMethod.methodName = method;
        String out = this.methodAlias.get(this.classAndMethod);
        if (out != null) {
            return out;
        }
        StringBuilder sb = new StringBuilder();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name + '.' + method;
        }
        int prevIndex = -1;
        while (true) {
            char ch = name.charAt(prevIndex + 1);
            sb.append(ch);
            idx = name.indexOf(46, prevIndex + 1);
            ch = name.charAt(idx + 1);
            if (idx >= lastDot || Character.isUpperCase(ch)) break;
            prevIndex = idx;
        }
        sb.append(name.substring(idx));
        return sb.toString() + '.' + method;
    }

    public void activateOptions() {
    }

    public boolean ignoresThrowable() {
        return false;
    }

    private void appendMDC(StringBuilder sb) {
        if (!StringUtils.isEmpty(MDC.get((String)"node_name"))) {
            sb.append(" n:").append(MDC.get((String)"node_name"));
        }
        if (!StringUtils.isEmpty(MDC.get((String)"collection"))) {
            sb.append(" c:").append(MDC.get((String)"collection"));
        }
        if (!StringUtils.isEmpty(MDC.get((String)"shard"))) {
            sb.append(" s:").append(MDC.get((String)"shard"));
        }
        if (!StringUtils.isEmpty(MDC.get((String)"replica"))) {
            sb.append(" r:").append(MDC.get((String)"replica"));
        }
        if (!StringUtils.isEmpty(MDC.get((String)"core"))) {
            sb.append(" x:").append(MDC.get((String)"core"));
        }
    }

    public static class CoreInfo {
        static int maxCoreNum;
        String shortId;
        String url;
        Map<String, Object> coreProps;
    }

    public static class Method {
        public String className;
        public String methodName;

        public Method(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Method)) {
                return false;
            }
            Method other = (Method)obj;
            return this.className.equals(other.className) && this.methodName.equals(other.methodName);
        }

        public String toString() {
            return this.className + '.' + this.methodName;
        }
    }

    public static interface TG {
        public String getTag();
    }
}

