/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIdentifierValidator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Pattern identifierPattern = Pattern.compile("^(?!\\\\-)[\\\\._A-Za-z0-9\\\\-]+$");

    public static void validateCollectionName(String collectionName) throws SolrException {
        SolrIdentifierValidator.validateCoreName(collectionName);
    }

    public static void validateCoreName(String name) throws SolrException {
        if (name == null || !identifierPattern.matcher(name).matches()) {
            log.info("Validation failed on the invalid identifier [{}].  Throwing SolrException to indicate a BAD REQUEST.", (Object)name);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid name: '" + name + "' Identifiers must consist entirely of periods, hyphens, underscores and alphanumerics");
        }
    }
}

