/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String VERSION_FIELD = "_version_";
    private final UpdateLog ulog;
    private final VersionBucket[] buckets;
    private SchemaField versionField;
    private SchemaField idField;
    final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private long vclock;
    private final Object clockSync = new Object();

    public static SchemaField getAndCheckVersionField(IndexSchema schema) throws SolrException {
        String errPrefix = "_version_ field must exist in schema, using indexed=\"true\" or docValues=\"true\", stored=\"true\" and multiValued=\"false\"";
        SchemaField sf = schema.getFieldOrNull(VERSION_FIELD);
        if (null == sf) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema, using indexed=\"true\" or docValues=\"true\", stored=\"true\" and multiValued=\"false\" (_version_ does not exist)");
        }
        if (!sf.indexed() && !sf.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema, using indexed=\"true\" or docValues=\"true\", stored=\"true\" and multiValued=\"false\" (_version_ must be either indexed or have docValues");
        }
        if (!sf.stored()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema, using indexed=\"true\" or docValues=\"true\", stored=\"true\" and multiValued=\"false\" (_version_ is not stored");
        }
        if (sf.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema, using indexed=\"true\" or docValues=\"true\", stored=\"true\" and multiValued=\"false\" (_version_ is multiValued");
        }
        return sf;
    }

    public VersionInfo(UpdateLog ulog, int nBuckets) {
        this.ulog = ulog;
        IndexSchema schema = ulog.uhandler.core.getLatestSchema();
        this.versionField = VersionInfo.getAndCheckVersionField(schema);
        this.idField = schema.getUniqueKeyField();
        this.buckets = new VersionBucket[BitUtil.nextHighestPowerOfTwo((int)nBuckets)];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new VersionBucket();
        }
    }

    public void reload() {
    }

    public SchemaField getVersionField() {
        return this.versionField;
    }

    public void lockForUpdate() {
        this.lock.readLock().lock();
    }

    public void unlockForUpdate() {
        this.lock.readLock().unlock();
    }

    public void blockUpdates() {
        this.lock.writeLock().lock();
    }

    public void unblockUpdates() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="need currentTimeMillis just for getting realistic version stamps, does not assume monotonicity")
    public long getNewClock() {
        Object object = this.clockSync;
        synchronized (object) {
            long time = System.currentTimeMillis();
            long result = time << 20;
            if (result <= this.vclock) {
                result = this.vclock + 1L;
            }
            this.vclock = result;
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldClock() {
        Object object = this.clockSync;
        synchronized (object) {
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClock(long clock) {
        Object object = this.clockSync;
        synchronized (object) {
            this.vclock = Math.max(this.vclock, clock);
        }
    }

    public VersionBucket bucket(int hash) {
        int slot = hash & this.buckets.length - 1;
        return this.buckets[slot];
    }

    public Long lookupVersion(BytesRef idBytes) {
        return this.ulog.lookupVersion(idBytes);
    }

    public Long getVersionFromIndex(BytesRef idBytes) {
        RefCounted<SolrIndexSearcher> newestSearcher = this.ulog.uhandler.core.getRealtimeSearcher();
        try {
            SolrIndexSearcher searcher = newestSearcher.get();
            long lookup = searcher.lookupId(idBytes);
            if (lookup < 0L) {
                Long l = null;
                return l;
            }
            ValueSource vs = this.versionField.getType().getValueSource(this.versionField, null);
            Map context = ValueSource.newContext((IndexSearcher)searcher);
            vs.createWeight(context, (IndexSearcher)searcher);
            FunctionValues fv = vs.getValues(context, (LeafReaderContext)searcher.getTopReaderContext().leaves().get((int)(lookup >> 32)));
            long ver = fv.longVal((int)lookup);
            Long l = ver;
            return l;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading version from index", (Throwable)e);
        }
        finally {
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }

    public Long getMaxVersionFromIndex(SolrIndexSearcher searcher) throws IOException {
        String versionFieldName = this.versionField.getName();
        log.info("Refreshing highest value of {} for {} version buckets from index", (Object)versionFieldName, (Object)this.buckets.length);
        long maxVersionInIndex = 0L;
        if (this.versionField.indexed()) {
            Long max;
            Terms versionTerms = searcher.getLeafReader().terms(versionFieldName);
            Long l = max = versionTerms != null ? NumericUtils.getMaxLong((Terms)versionTerms) : null;
            if (max != null) {
                maxVersionInIndex = max;
                log.info("Found MAX value {} from Terms for {} in index", (Object)maxVersionInIndex, (Object)versionFieldName);
            } else {
                log.info("No terms found for {}, cannot seed version bucket highest value from index", (Object)versionFieldName);
            }
        } else {
            ValueSource vs = this.versionField.getType().getValueSource(this.versionField, null);
            Map funcContext = ValueSource.newContext((IndexSearcher)searcher);
            vs.createWeight(funcContext, (IndexSearcher)searcher);
            for (LeafReaderContext ctx : searcher.getTopReaderContext().leaves()) {
                int maxDoc = ctx.reader().maxDoc();
                FunctionValues fv = vs.getValues(funcContext, ctx);
                for (int doc = 0; doc < maxDoc; ++doc) {
                    long v = fv.longVal(doc);
                    maxVersionInIndex = Math.max(v, maxVersionInIndex);
                }
            }
        }
        return maxVersionInIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedBucketsWithHighestVersion(long highestVersion) {
        for (int i = 0; i < this.buckets.length; ++i) {
            VersionBucket versionBucket = this.buckets[i];
            synchronized (versionBucket) {
                if (this.buckets[i].highest < highestVersion) {
                    this.buckets[i].highest = highestVersion;
                }
                continue;
            }
        }
    }
}

