/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.HashBasedRouter;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitsFilteredPostingsEnum;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexSplitter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    SolrIndexSearcher searcher;
    SchemaField field;
    List<DocRouter.Range> ranges;
    DocRouter.Range[] rangesArr;
    List<String> paths;
    List<SolrCore> cores;
    DocRouter router;
    HashBasedRouter hashRouter;
    int numPieces;
    int currPartition = 0;
    String routeFieldName;
    String splitKey;

    public SolrIndexSplitter(SplitIndexCommand cmd) {
        this.searcher = cmd.getReq().getSearcher();
        this.ranges = cmd.ranges;
        this.paths = cmd.paths;
        this.cores = cmd.cores;
        this.router = cmd.router;
        HashBasedRouter hashBasedRouter = this.hashRouter = this.router instanceof HashBasedRouter ? (HashBasedRouter)this.router : null;
        if (this.ranges == null) {
            this.numPieces = this.paths != null ? this.paths.size() : this.cores.size();
        } else {
            this.numPieces = this.ranges.size();
            this.rangesArr = this.ranges.toArray(new DocRouter.Range[this.ranges.size()]);
        }
        this.routeFieldName = cmd.routeFieldName;
        this.field = this.routeFieldName == null ? this.searcher.getSchema().getUniqueKeyField() : this.searcher.getSchema().getField(this.routeFieldName);
        if (cmd.splitKey != null) {
            this.splitKey = SolrIndexSplitter.getRouteKey(cmd.splitKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        List leaves = this.searcher.getRawReader().leaves();
        ArrayList<FixedBitSet[]> segmentDocSets = new ArrayList<FixedBitSet[]>(leaves.size());
        log.info("SolrIndexSplitter: partitions=" + this.numPieces + " segments=" + leaves.size());
        for (LeafReaderContext readerContext : leaves) {
            assert (readerContext.ordInParent == segmentDocSets.size());
            FixedBitSet[] docSets = this.split(readerContext);
            segmentDocSets.add(docSets);
        }
        for (int partitionNumber = 0; partitionNumber < this.numPieces; ++partitionNumber) {
            IndexWriter iw;
            block13: {
                log.info("SolrIndexSplitter: partition #" + partitionNumber + " partitionCount=" + this.numPieces + (this.ranges != null ? " range=" + this.ranges.get(partitionNumber) : ""));
                boolean success = false;
                RefCounted<IndexWriter> iwRef = null;
                iw = null;
                if (this.cores != null) {
                    SolrCore subCore = this.cores.get(partitionNumber);
                    iwRef = subCore.getUpdateHandler().getSolrCoreState().getIndexWriter(subCore);
                    iw = iwRef.get();
                } else {
                    SolrCore core = this.searcher.getCore();
                    String path = this.paths.get(partitionNumber);
                    iw = SolrIndexWriter.create(core, "SplittingIndexWriter" + partitionNumber + (this.ranges != null ? " " + this.ranges.get(partitionNumber) : ""), path, core.getDirectoryFactory(), true, core.getLatestSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec());
                }
                try {
                    for (int segmentNumber = 0; segmentNumber < leaves.size(); ++segmentNumber) {
                        log.info("SolrIndexSplitter: partition #" + partitionNumber + " partitionCount=" + this.numPieces + (this.ranges != null ? " range=" + this.ranges.get(partitionNumber) : "") + " segment #" + segmentNumber + " segmentCount=" + leaves.size());
                        CodecReader subReader = SlowCodecReaderWrapper.wrap((LeafReader)((LeafReaderContext)leaves.get(segmentNumber)).reader());
                        iw.addIndexes(new CodecReader[]{new LiveDocsReader(subReader, ((FixedBitSet[])segmentDocSets.get(segmentNumber))[partitionNumber])});
                    }
                    success = true;
                    if (iwRef != null) {
                        iwRef.decref();
                        continue;
                    }
                    if (!success) break block13;
                }
                catch (Throwable throwable) {
                    if (iwRef != null) {
                        iwRef.decref();
                    } else if (success) {
                        iw.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{iw});
                    }
                    throw throwable;
                }
                iw.close();
                continue;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{iw});
        }
    }

    FixedBitSet[] split(LeafReaderContext readerContext) throws IOException {
        TermsEnum termsEnum;
        LeafReader reader = readerContext.reader();
        FixedBitSet[] docSets = new FixedBitSet[this.numPieces];
        for (int i = 0; i < docSets.length; ++i) {
            docSets[i] = new FixedBitSet(reader.maxDoc());
        }
        Bits liveDocs = reader.getLiveDocs();
        Fields fields = reader.fields();
        Terms terms = fields == null ? null : fields.terms(this.field.getName());
        TermsEnum termsEnum2 = termsEnum = terms == null ? null : terms.iterator();
        if (termsEnum == null) {
            return docSets;
        }
        BytesRef term = null;
        PostingsEnum postingsEnum = null;
        int[] docsMatchingRanges = null;
        if (this.ranges != null) {
            docsMatchingRanges = new int[this.rangesArr.length + 1];
        }
        CharsRefBuilder idRef = new CharsRefBuilder();
        while ((term = termsEnum.next()) != null) {
            int doc;
            String part1;
            this.field.getType().indexedToReadable(term, idRef);
            String idString = idRef.toString();
            if (this.splitKey != null && ((part1 = SolrIndexSplitter.getRouteKey(idString)) == null || !this.splitKey.equals(part1))) continue;
            int hash = 0;
            if (this.hashRouter != null) {
                hash = this.hashRouter.sliceHash(idString, null, null, null);
            }
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            postingsEnum = BitsFilteredPostingsEnum.wrap(postingsEnum, liveDocs);
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (this.ranges == null) {
                    docSets[this.currPartition].set(doc);
                    this.currPartition = (this.currPartition + 1) % this.numPieces;
                    continue;
                }
                int matchingRangesCount = 0;
                for (int i = 0; i < this.rangesArr.length; ++i) {
                    if (!this.rangesArr[i].includes(hash)) continue;
                    docSets[i].set(doc);
                    ++matchingRangesCount;
                }
                int n = matchingRangesCount;
                docsMatchingRanges[n] = docsMatchingRanges[n] + 1;
            }
        }
        if (docsMatchingRanges != null) {
            block8: for (int ii = 0; ii < docsMatchingRanges.length; ++ii) {
                if (0 == docsMatchingRanges[ii]) continue;
                switch (ii) {
                    case 0: {
                        log.error("Splitting {}: {} documents belong to no shards and will be dropped", (Object)reader, (Object)docsMatchingRanges[ii]);
                        continue block8;
                    }
                    case 1: {
                        log.info("Splitting {}: {} documents will move into a sub-shard", (Object)reader, (Object)docsMatchingRanges[ii]);
                        continue block8;
                    }
                    default: {
                        log.error("Splitting {}: {} documents will be moved to multiple ({}) sub-shards", new Object[]{reader, docsMatchingRanges[ii], ii});
                    }
                }
            }
        }
        return docSets;
    }

    public static String getRouteKey(String idString) {
        char ch;
        int idx = idString.indexOf("!");
        if (idx <= 0) {
            return null;
        }
        String part1 = idString.substring(0, idx);
        int commaIdx = part1.indexOf(47);
        if (commaIdx > 0 && commaIdx + 1 < part1.length() && (ch = part1.charAt(commaIdx + 1)) >= '0' && ch <= '9') {
            part1 = part1.substring(0, commaIdx);
        }
        return part1;
    }

    static class LiveDocsReader
    extends FilterCodecReader {
        final FixedBitSet liveDocs;
        final int numDocs;

        public LiveDocsReader(CodecReader in, FixedBitSet liveDocs) throws IOException {
            super(in);
            this.liveDocs = liveDocs;
            this.numDocs = liveDocs.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public Bits getLiveDocs() {
            return this.liveDocs;
        }
    }
}

