/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.function.FunctionAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupHeadsCollector;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrIndexSearcher.QueryCommand queryCommand;
    private final List<Command> commands;
    private final SolrIndexSearcher searcher;
    private final boolean needDocset;
    private final boolean truncateGroups;
    private final boolean includeHitCount;
    private boolean partialResults = false;
    private int totalHitCount;
    private DocSet docSet;

    private CommandHandler(SolrIndexSearcher.QueryCommand queryCommand, List<Command> commands, SolrIndexSearcher searcher, boolean needDocset, boolean truncateGroups, boolean includeHitCount) {
        this.queryCommand = queryCommand;
        this.commands = commands;
        this.searcher = searcher;
        this.needDocset = needDocset;
        this.truncateGroups = truncateGroups;
        this.includeHitCount = includeHitCount;
    }

    public void execute() throws IOException {
        int nrOfCommands = this.commands.size();
        ArrayList<Collector> collectors = new ArrayList<Collector>(nrOfCommands);
        for (Command command : this.commands) {
            collectors.addAll(command.create());
        }
        SolrIndexSearcher.ProcessedFilter filter = this.searcher.getProcessedFilter(this.queryCommand.getFilter(), this.queryCommand.getFilterList());
        Query query = QueryUtils.makeQueryable(this.queryCommand.getQuery());
        if (this.truncateGroups) {
            this.docSet = this.computeGroupedDocSet(query, filter, collectors);
        } else if (this.needDocset) {
            this.docSet = this.computeDocSet(query, filter, collectors);
        } else if (!collectors.isEmpty()) {
            this.searchWithTimeLimiter(query, filter, MultiCollector.wrap((Collector[])collectors.toArray(new Collector[nrOfCommands])));
        } else {
            this.searchWithTimeLimiter(query, filter, null);
        }
    }

    private DocSet computeGroupedDocSet(Query query, SolrIndexSearcher.ProcessedFilter filter, List<Collector> collectors) throws IOException {
        AbstractAllGroupHeadsCollector allGroupHeadsCollector;
        Command firstCommand = this.commands.get(0);
        String field = firstCommand.getKey();
        SchemaField sf = this.searcher.getSchema().getField(field);
        FieldType fieldType = sf.getType();
        if (fieldType.getNumericType() != null) {
            ValueSource vs = fieldType.getValueSource(sf, null);
            allGroupHeadsCollector = new FunctionAllGroupHeadsCollector(vs, new HashMap(), firstCommand.getSortWithinGroup());
        } else {
            allGroupHeadsCollector = TermAllGroupHeadsCollector.create((String)firstCommand.getKey(), (Sort)firstCommand.getSortWithinGroup());
        }
        if (collectors.isEmpty()) {
            this.searchWithTimeLimiter(query, filter, (Collector)allGroupHeadsCollector);
        } else {
            collectors.add((Collector)allGroupHeadsCollector);
            this.searchWithTimeLimiter(query, filter, MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()])));
        }
        return new BitDocSet(allGroupHeadsCollector.retrieveGroupHeads(this.searcher.maxDoc()));
    }

    private DocSet computeDocSet(Query query, SolrIndexSearcher.ProcessedFilter filter, List<Collector> collectors) throws IOException {
        int maxDoc = this.searcher.maxDoc();
        DocSetCollector docSetCollector = new DocSetCollector(maxDoc);
        ArrayList<Collector> allCollectors = new ArrayList<Collector>(collectors);
        allCollectors.add((Collector)docSetCollector);
        this.searchWithTimeLimiter(query, filter, MultiCollector.wrap(allCollectors));
        return docSetCollector.getDocSet();
    }

    public NamedList processResult(SolrIndexSearcher.QueryResult queryResult, ShardResultTransformer transformer) throws IOException {
        if (this.docSet != null) {
            queryResult.setDocSet(this.docSet);
        }
        queryResult.setPartialResults(this.partialResults);
        return transformer.transform(this.commands);
    }

    private void searchWithTimeLimiter(Query query, SolrIndexSearcher.ProcessedFilter filter, Collector collector) throws IOException {
        if (this.queryCommand.getTimeAllowed() > 0L) {
            collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), this.queryCommand.getTimeAllowed());
        }
        TotalHitCountCollector hitCountCollector = new TotalHitCountCollector();
        if (this.includeHitCount) {
            collector = MultiCollector.wrap((Collector[])new Collector[]{collector, hitCountCollector});
        }
        if (filter.filter != null) {
            query = new FilteredQuery(query, filter.filter);
        }
        if (filter.postFilter != null) {
            filter.postFilter.setLastDelegate((Collector)collector);
            collector = filter.postFilter;
        }
        try {
            this.searcher.search(query, (Collector)collector);
        }
        catch (ExitableDirectoryReader.ExitingReaderException | TimeLimitingCollector.TimeExceededException x) {
            this.partialResults = true;
            logger.warn("Query: " + query + "; " + x.getMessage());
        }
        if (this.includeHitCount) {
            this.totalHitCount = hitCountCollector.getTotalHits();
        }
    }

    public int getTotalHitCount() {
        return this.totalHitCount;
    }

    public static class Builder {
        private SolrIndexSearcher.QueryCommand queryCommand;
        private List<Command> commands = new ArrayList<Command>();
        private SolrIndexSearcher searcher;
        private boolean needDocSet = false;
        private boolean truncateGroups = false;
        private boolean includeHitCount = false;

        public Builder setQueryCommand(SolrIndexSearcher.QueryCommand queryCommand) {
            this.queryCommand = queryCommand;
            this.needDocSet = (queryCommand.getFlags() & 0x40000000) != 0;
            return this;
        }

        public Builder addCommandField(Command commandField) {
            this.commands.add(commandField);
            return this;
        }

        public Builder setSearcher(SolrIndexSearcher searcher) {
            this.searcher = searcher;
            return this;
        }

        public Builder setNeedDocSet(boolean needDocSet) {
            this.needDocSet = needDocSet;
            return this;
        }

        public Builder setTruncateGroups(boolean truncateGroups) {
            this.truncateGroups = truncateGroups;
            return this;
        }

        public Builder setIncludeHitCount(boolean includeHitCount) {
            this.includeHitCount = includeHitCount;
            return this;
        }

        public CommandHandler build() {
            if (this.queryCommand == null || this.searcher == null) {
                throw new IllegalStateException("All fields must be set");
            }
            return new CommandHandler(this.queryCommand, this.commands, this.searcher, this.needDocSet, this.truncateGroups, this.includeHitCount);
        }
    }
}

