/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetRange;

class FacetRangeParser
extends FacetParser<FacetRange> {
    public FacetRangeParser(FacetParser parent, String key) {
        super(parent, key);
        this.facet = new FacetRange();
    }

    @Override
    public FacetRange parse(Object arg) throws SyntaxError {
        List<String> lst;
        this.parseCommonParams(arg);
        if (!(arg instanceof Map)) {
            throw this.err("Missing range facet arguments");
        }
        Map m = (Map)arg;
        ((FacetRange)this.facet).field = this.getString(m, "field", null);
        ((FacetRange)this.facet).start = m.get("start");
        ((FacetRange)this.facet).end = m.get("end");
        ((FacetRange)this.facet).gap = m.get("gap");
        ((FacetRange)this.facet).hardend = this.getBoolean(m, "hardend", ((FacetRange)this.facet).hardend);
        ((FacetRange)this.facet).mincount = this.getLong(m, "mincount", 0L);
        Object o = m.get("include");
        String[] includeList = null;
        if (o != null) {
            lst = null;
            if (o instanceof List) {
                lst = (List<String>)o;
            } else if (o instanceof String) {
                lst = StrUtils.splitSmart((String)o, ',');
            }
            includeList = lst.toArray(new String[lst.size()]);
        }
        ((FacetRange)this.facet).include = FacetParams.FacetRangeInclude.parseParam(includeList);
        ((FacetRange)this.facet).others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
        o = m.get("other");
        if (o != null) {
            lst = null;
            if (o instanceof List) {
                lst = (List<String>)o;
            } else if (o instanceof String) {
                lst = StrUtils.splitSmart((String)o, ',');
            }
            for (String otherStr : lst) {
                ((FacetRange)this.facet).others.add(FacetParams.FacetRangeOther.get(otherStr));
            }
        }
        Object facetObj = m.get("facet");
        this.parseSubs(facetObj);
        return (FacetRange)this.facet;
    }
}

