/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LazyDocument;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.EnumField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.BitsFilteredPostingsEnum;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.CursorMark;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSetUtil;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.EarlyTerminatingCollector;
import org.apache.solr.search.EarlyTerminatingCollectorException;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.FilterImpl;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.QueryResultKey;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.ScoreFilter;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrQueryTimeoutImpl;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.search.WrappedQuery;
import org.apache.solr.search.facet.UnInvertedField;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.SolrIndexConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexSearcher
extends IndexSearcher
implements Closeable,
SolrInfoMBean {
    public static final String STATS_SOURCE = "org.apache.solr.stats_source";
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCore core;
    private final IndexSchema schema;
    private boolean debug = log.isDebugEnabled();
    private final String name;
    private final Date openTime = new Date();
    private final long openNanoTime = System.nanoTime();
    private Date registerTime;
    private long warmupTime = 0L;
    private final DirectoryReader reader;
    private final boolean closeReader;
    private final int queryResultWindowSize;
    private final int queryResultMaxDocsCached;
    private final boolean useFilterForSortedQuery;
    public final boolean enableLazyFieldLoading;
    private final boolean cachingEnabled;
    private final SolrCache<Query, DocSet> filterCache;
    private final SolrCache<QueryResultKey, DocList> queryResultCache;
    private final SolrCache<Integer, Document> documentCache;
    private final SolrCache<String, UnInvertedField> fieldValueCache;
    private final HashMap<String, SolrCache> cacheMap;
    private static final HashMap<String, SolrCache> noGenericCaches = new HashMap(0);
    private final SolrCache[] cacheList;
    private static final SolrCache[] noCaches = new SolrCache[0];
    private final FieldInfos fieldInfos;
    private final Collection<String> fieldNames;
    private final Set<String> allNonStoredDVs;
    private final Set<String> nonStoredDVsUsedAsStored;
    private final Set<String> nonStoredDVsWithoutCopyTargets;
    private Collection<String> storedHighlightFieldNames;
    private DirectoryFactory directoryFactory;
    private final LeafReader leafReader;
    private final DirectoryReader rawReader;
    private String path;
    private final boolean reserveDirectory;
    private boolean createdDirectory;
    private final Map<Long, IndexFingerprint> maxVersionFingerprintCache = new ConcurrentHashMap<Long, IndexFingerprint>();
    private static Query matchAllDocsQuery = new MatchAllDocsQuery();
    private static Comparator<Query> sortByCost = new Comparator<Query>(){

        @Override
        public int compare(Query q1, Query q2) {
            return ((ExtendedQuery)q1).getCost() - ((ExtendedQuery)q2).getCost();
        }
    };
    public static final int NO_CHECK_QCACHE = Integer.MIN_VALUE;
    public static final int GET_DOCSET = 0x40000000;
    static final int NO_CHECK_FILTERCACHE = 0x20000000;
    static final int NO_SET_QCACHE = 0x10000000;
    public static final int TERMINATE_EARLY = 4;
    public static final int GET_DOCLIST = 2;
    public static final int GET_SCORES = 1;

    private static DirectoryReader getReader(SolrCore core, SolrIndexConfig config, DirectoryFactory directoryFactory, String path) throws IOException {
        DirectoryReader reader = null;
        Directory dir = directoryFactory.get(path, DirectoryFactory.DirContext.DEFAULT, config.lockType);
        try {
            reader = core.getIndexReaderFactory().newReader(dir, core);
        }
        catch (Exception e) {
            directoryFactory.release(dir);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error opening Reader", (Throwable)e);
        }
        return reader;
    }

    private static DirectoryReader wrapReader(SolrCore core, DirectoryReader reader) throws IOException {
        assert (reader != null);
        return ExitableDirectoryReader.wrap((DirectoryReader)UninvertingReader.wrap((DirectoryReader)reader, core.getLatestSchema().getUninversionMap((IndexReader)reader)), (QueryTimeout)SolrQueryTimeoutImpl.getInstance());
    }

    private void buildAndRunCollectorChain(QueryResult qr, Query query, Collector collector, QueryCommand cmd, DelegatingCollector postFilter) throws IOException {
        long timeAllowed;
        boolean terminateEarly = cmd.getTerminateEarly();
        if (terminateEarly) {
            collector = new EarlyTerminatingCollector((Collector)collector, cmd.getLen());
        }
        if ((timeAllowed = cmd.getTimeAllowed()) > 0L) {
            collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), timeAllowed);
        }
        if (postFilter != null) {
            postFilter.setLastDelegate((Collector)collector);
            collector = postFilter;
        }
        try {
            super.search(query, collector);
        }
        catch (ExitableDirectoryReader.ExitingReaderException | TimeLimitingCollector.TimeExceededException x) {
            log.warn("Query: " + query + "; " + x.getMessage());
            qr.setPartialResults(true);
        }
        catch (EarlyTerminatingCollectorException etce) {
            if (collector instanceof DelegatingCollector) {
                ((DelegatingCollector)((Object)collector)).finish();
            }
            throw etce;
        }
        if (collector instanceof DelegatingCollector) {
            ((DelegatingCollector)((Object)collector)).finish();
        }
    }

    public SolrIndexSearcher(SolrCore core, String path, IndexSchema schema, SolrIndexConfig config, String name, boolean enableCache, DirectoryFactory directoryFactory) throws IOException {
        this(core, path, schema, name, SolrIndexSearcher.getReader(core, config, directoryFactory, path), true, enableCache, false, directoryFactory);
        this.createdDirectory = true;
    }

    public SolrIndexSearcher(SolrCore core, String path, IndexSchema schema, String name, DirectoryReader r, boolean closeReader, boolean enableCache, boolean reserveDirectory, DirectoryFactory directoryFactory) throws IOException {
        super((IndexReader)SolrIndexSearcher.wrapReader(core, r));
        this.path = path;
        this.directoryFactory = directoryFactory;
        this.reader = (DirectoryReader)this.readerContext.reader();
        this.rawReader = r;
        this.leafReader = SlowCompositeReaderWrapper.wrap((IndexReader)this.reader);
        this.core = core;
        this.schema = schema;
        this.name = "Searcher@" + Integer.toHexString(this.hashCode()) + "[" + core.getName() + "]" + (name != null ? " " + name : "");
        log.info("Opening " + this.name);
        if (directoryFactory.searchersReserveCommitPoints()) {
            core.getDeletionPolicy().saveCommitPoint(this.reader.getIndexCommit().getGeneration());
        }
        Directory dir = this.getIndexReader().directory();
        this.reserveDirectory = reserveDirectory;
        if (reserveDirectory) {
            directoryFactory.incRef(dir);
        }
        this.closeReader = closeReader;
        this.setSimilarity(schema.getSimilarity());
        SolrConfig solrConfig = core.getSolrConfig();
        this.queryResultWindowSize = solrConfig.queryResultWindowSize;
        this.queryResultMaxDocsCached = solrConfig.queryResultMaxDocsCached;
        this.useFilterForSortedQuery = solrConfig.useFilterForSortedQuery;
        this.enableLazyFieldLoading = solrConfig.enableLazyFieldLoading;
        this.cachingEnabled = enableCache;
        if (this.cachingEnabled) {
            ArrayList<SolrCache> clist = new ArrayList<SolrCache>();
            SolrCache<String, UnInvertedField> solrCache = this.fieldValueCache = solrConfig.fieldValueCacheConfig == null ? null : solrConfig.fieldValueCacheConfig.newInstance();
            if (this.fieldValueCache != null) {
                clist.add(this.fieldValueCache);
            }
            SolrCache<Query, DocSet> solrCache2 = this.filterCache = solrConfig.filterCacheConfig == null ? null : solrConfig.filterCacheConfig.newInstance();
            if (this.filterCache != null) {
                clist.add(this.filterCache);
            }
            SolrCache<QueryResultKey, DocList> solrCache3 = this.queryResultCache = solrConfig.queryResultCacheConfig == null ? null : solrConfig.queryResultCacheConfig.newInstance();
            if (this.queryResultCache != null) {
                clist.add(this.queryResultCache);
            }
            SolrCache<Integer, Document> solrCache4 = this.documentCache = solrConfig.documentCacheConfig == null ? null : solrConfig.documentCacheConfig.newInstance();
            if (this.documentCache != null) {
                clist.add(this.documentCache);
            }
            if (solrConfig.userCacheConfigs == null) {
                this.cacheMap = noGenericCaches;
            } else {
                this.cacheMap = new HashMap(solrConfig.userCacheConfigs.length);
                for (CacheConfig userCacheConfig : solrConfig.userCacheConfigs) {
                    SolrCache cache = null;
                    if (userCacheConfig != null) {
                        cache = userCacheConfig.newInstance();
                    }
                    if (cache == null) continue;
                    this.cacheMap.put(cache.name(), cache);
                    clist.add(cache);
                }
            }
            this.cacheList = clist.toArray(new SolrCache[clist.size()]);
        } else {
            this.filterCache = null;
            this.queryResultCache = null;
            this.documentCache = null;
            this.fieldValueCache = null;
            this.cacheMap = noGenericCaches;
            this.cacheList = noCaches;
        }
        this.fieldNames = new HashSet<String>();
        HashSet<String> nonStoredDVsUsedAsStored = new HashSet<String>();
        HashSet<String> allNonStoredDVs = new HashSet<String>();
        HashSet<String> nonStoredDVsWithoutCopyTargets = new HashSet<String>();
        this.fieldInfos = this.leafReader.getFieldInfos();
        for (FieldInfo fieldInfo : this.fieldInfos) {
            this.fieldNames.add(fieldInfo.name);
            SchemaField schemaField = schema.getFieldOrNull(fieldInfo.name);
            if (schemaField == null || schemaField.stored() || !schemaField.hasDocValues()) continue;
            if (schemaField.useDocValuesAsStored()) {
                nonStoredDVsUsedAsStored.add(fieldInfo.name);
            }
            allNonStoredDVs.add(fieldInfo.name);
            if (schema.isCopyFieldTarget(schemaField)) continue;
            nonStoredDVsWithoutCopyTargets.add(fieldInfo.name);
        }
        this.nonStoredDVsUsedAsStored = Collections.unmodifiableSet(nonStoredDVsUsedAsStored);
        this.allNonStoredDVs = Collections.unmodifiableSet(allNonStoredDVs);
        this.nonStoredDVsWithoutCopyTargets = Collections.unmodifiableSet(nonStoredDVsWithoutCopyTargets);
        this.setQueryCache(null);
        numOpens.incrementAndGet();
    }

    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        StatsSource statsSrc;
        SolrRequestInfo reqInfo = SolrRequestInfo.getRequestInfo();
        if (reqInfo != null && (statsSrc = (StatsSource)reqInfo.getReq().getContext().get(STATS_SOURCE)) != null) {
            return statsSrc.termStatistics(this, term, context);
        }
        return this.localTermStatistics(term, context);
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        StatsSource statsSrc;
        SolrRequestInfo reqInfo = SolrRequestInfo.getRequestInfo();
        if (reqInfo != null && (statsSrc = (StatsSource)reqInfo.getReq().getContext().get(STATS_SOURCE)) != null) {
            return statsSrc.collectionStatistics(this, field);
        }
        return this.localCollectionStatistics(field);
    }

    public TermStatistics localTermStatistics(Term term, TermContext context) throws IOException {
        return super.termStatistics(term, context);
    }

    public CollectionStatistics localCollectionStatistics(String field) throws IOException {
        return super.collectionStatistics(field);
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.name + "{" + this.reader + "}";
    }

    public SolrCore getCore() {
        return this.core;
    }

    public final int maxDoc() {
        return this.reader.maxDoc();
    }

    public final int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public final LeafReader getLeafReader() {
        return this.leafReader;
    }

    public final DirectoryReader getRawReader() {
        return this.rawReader;
    }

    public final DirectoryReader getIndexReader() {
        assert (this.reader == super.getIndexReader());
        return this.reader;
    }

    public void register() {
        this.core.getInfoRegistry().put("searcher", this);
        this.core.getInfoRegistry().put(this.name, this);
        for (SolrCache cache : this.cacheList) {
            cache.setState(SolrCache.State.LIVE);
            this.core.getInfoRegistry().put(cache.name(), cache);
        }
        this.registerTime = new Date();
    }

    @Override
    public void close() throws IOException {
        if (this.debug) {
            if (this.cachingEnabled) {
                StringBuilder sb = new StringBuilder();
                sb.append("Closing ").append(this.name);
                for (SolrCache cache : this.cacheList) {
                    sb.append("\n\t");
                    sb.append(cache);
                }
                log.debug(sb.toString());
            } else if (this.debug) {
                log.debug("Closing " + this.name);
            }
        }
        this.core.getInfoRegistry().remove(this.name);
        long cpg = this.reader.getIndexCommit().getGeneration();
        try {
            if (this.closeReader) {
                this.rawReader.decRef();
            }
        }
        catch (Exception e) {
            SolrException.log(log, "Problem dec ref'ing reader", e);
        }
        if (this.directoryFactory.searchersReserveCommitPoints()) {
            this.core.getDeletionPolicy().releaseCommitPoint(cpg);
        }
        for (SolrCache cache : this.cacheList) {
            cache.close();
        }
        if (this.reserveDirectory) {
            this.directoryFactory.release(this.getIndexReader().directory());
        }
        if (this.createdDirectory) {
            this.directoryFactory.release(this.getIndexReader().directory());
        }
        numCloses.incrementAndGet();
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public Collection<String> getFieldNames() {
        return this.fieldNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getStoredHighlightFieldNames() {
        SolrIndexSearcher solrIndexSearcher = this;
        synchronized (solrIndexSearcher) {
            if (this.storedHighlightFieldNames == null) {
                this.storedHighlightFieldNames = new LinkedList<String>();
                for (String fieldName : this.fieldNames) {
                    try {
                        SchemaField field = this.schema.getField(fieldName);
                        if (!field.stored() || !(field.getType() instanceof TextField) && !(field.getType() instanceof StrField)) continue;
                        this.storedHighlightFieldNames.add(fieldName);
                    }
                    catch (RuntimeException e) {
                        log.warn("Field \"" + fieldName + "\" found in index, but not defined in schema.");
                    }
                }
            }
            return this.storedHighlightFieldNames;
        }
    }

    public static void initRegenerators(SolrConfig solrConfig) {
        if (solrConfig.fieldValueCacheConfig != null && solrConfig.fieldValueCacheConfig.getRegenerator() == null) {
            solrConfig.fieldValueCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    if (oldVal instanceof UnInvertedField) {
                        UnInvertedField.getUnInvertedField((String)oldKey, newSearcher);
                    }
                    return true;
                }
            });
        }
        if (solrConfig.filterCacheConfig != null && solrConfig.filterCacheConfig.getRegenerator() == null) {
            solrConfig.filterCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    newSearcher.cacheDocSet((Query)oldKey, null, false);
                    return true;
                }
            });
        }
        if (solrConfig.queryResultCacheConfig != null && solrConfig.queryResultCacheConfig.getRegenerator() == null) {
            final int queryResultWindowSize = solrConfig.queryResultWindowSize;
            solrConfig.queryResultCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    QueryResultKey key = (QueryResultKey)oldKey;
                    int nDocs = 1;
                    if (queryResultWindowSize <= 1) {
                        DocList oldList = (DocList)oldVal;
                        int oldnDocs = oldList.offset() + oldList.size();
                        nDocs = Math.min(oldnDocs, 40);
                    }
                    int flags = Integer.MIN_VALUE | key.nc_flags;
                    QueryCommand qc = new QueryCommand();
                    qc.setQuery(key.query).setFilterList(key.filters).setSort(key.sort).setLen(nDocs).setSupersetMaxDoc(nDocs).setFlags(flags);
                    QueryResult qr = new QueryResult();
                    newSearcher.getDocListC(qr, qc);
                    return true;
                }
            });
        }
    }

    public QueryResult search(QueryResult qr, QueryCommand cmd) throws IOException {
        this.getDocListC(qr, cmd);
        return qr;
    }

    public Document doc(int i) throws IOException {
        return this.doc(i, (Set<String>)null);
    }

    public void doc(int n, StoredFieldVisitor visitor) throws IOException {
        Document cached;
        if (this.documentCache != null && (cached = this.documentCache.get(n)) != null) {
            this.visitFromCached(cached, visitor);
            return;
        }
        this.getIndexReader().document(n, visitor);
    }

    private void visitFromCached(Document document, StoredFieldVisitor visitor) throws IOException {
        for (IndexableField f : document) {
            FieldInfo info = this.fieldInfos.fieldInfo(f.name());
            switch (visitor.needsField(info)) {
                case YES: {
                    if (f.binaryValue() != null) {
                        BytesRef binaryValue = f.binaryValue();
                        byte[] copy = new byte[binaryValue.length];
                        System.arraycopy(binaryValue.bytes, binaryValue.offset, copy, 0, copy.length);
                        visitor.binaryField(info, copy);
                        break;
                    }
                    if (f.numericValue() != null) {
                        Number numericValue = f.numericValue();
                        if (numericValue instanceof Double) {
                            visitor.doubleField(info, numericValue.doubleValue());
                            break;
                        }
                        if (numericValue instanceof Integer) {
                            visitor.intField(info, numericValue.intValue());
                            break;
                        }
                        if (numericValue instanceof Float) {
                            visitor.floatField(info, numericValue.floatValue());
                            break;
                        }
                        if (numericValue instanceof Long) {
                            visitor.longField(info, numericValue.longValue());
                            break;
                        }
                        throw new AssertionError();
                    }
                    visitor.stringField(info, f.stringValue().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case NO: {
                    break;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    public Document doc(int i, Set<String> fields) throws IOException {
        Document d;
        if (this.documentCache != null && (d = this.documentCache.get(i)) != null) {
            return d;
        }
        if (!this.enableLazyFieldLoading || fields == null) {
            d = this.getIndexReader().document(i);
        } else {
            SetNonLazyFieldSelector visitor = new SetNonLazyFieldSelector(fields, (IndexReader)this.getIndexReader(), i);
            this.getIndexReader().document(i, (StoredFieldVisitor)visitor);
            d = visitor.doc;
        }
        if (this.documentCache != null) {
            this.documentCache.put(i, d);
        }
        return d;
    }

    public void decorateDocValueFields(SolrDocumentBase doc, int docid, Set<String> fields) throws IOException {
        for (String fieldName : fields) {
            SchemaField schemaField = this.schema.getFieldOrNull(fieldName);
            if (schemaField == null || !schemaField.hasDocValues() || doc.containsKey(fieldName)) {
                log.warn("Couldn't decorate docValues for field: {}, schemaField: {}", (Object)fieldName, (Object)schemaField);
                continue;
            }
            if (schemaField.multiValued()) {
                SortedSetDocValues values = this.getLeafReader().getSortedSetDocValues(fieldName);
                if (values == null || values.getValueCount() <= 0L || !DocValues.getDocsWithField((LeafReader)this.leafReader, (String)fieldName).get(docid)) continue;
                values.setDocument(docid);
                LinkedList<Object> outValues = new LinkedList<Object>();
                long ord = values.nextOrd();
                while (ord != -1L) {
                    if (schemaField.getType() instanceof TrieIntField) {
                        outValues.add(NumericUtils.prefixCodedToInt((BytesRef)values.lookupOrd(ord)));
                    } else if (schemaField.getType() instanceof TrieLongField) {
                        outValues.add(NumericUtils.prefixCodedToLong((BytesRef)values.lookupOrd(ord)));
                    } else if (schemaField.getType() instanceof TrieFloatField) {
                        outValues.add(Float.valueOf(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)values.lookupOrd(ord)))));
                    } else if (schemaField.getType() instanceof TrieDoubleField) {
                        outValues.add(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)values.lookupOrd(ord))));
                    } else if (schemaField.getType() instanceof TrieDateField) {
                        outValues.add(new Date(NumericUtils.prefixCodedToLong((BytesRef)values.lookupOrd(ord))));
                    } else if (schemaField.getType() instanceof EnumField) {
                        outValues.add(((EnumField)schemaField.getType()).intValueToStringValue(NumericUtils.prefixCodedToInt((BytesRef)values.lookupOrd(ord))));
                    } else if (schemaField.getType() instanceof StrField) {
                        outValues.add(values.lookupOrd(ord).utf8ToString());
                    }
                    ord = values.nextOrd();
                }
                if (outValues.size() <= 0) continue;
                doc.addField(fieldName, outValues);
                continue;
            }
            DocValuesType dvType = this.fieldInfos.fieldInfo(fieldName).getDocValuesType();
            switch (dvType) {
                case NUMERIC: {
                    if (!DocValues.getDocsWithField((LeafReader)this.leafReader, (String)fieldName).get(docid)) break;
                    NumericDocValues ndv = this.leafReader.getNumericDocValues(fieldName);
                    Object val = ndv.get(docid);
                    if (schemaField.getType() instanceof TrieIntField) {
                        val = ((Long)val).intValue();
                    } else if (schemaField.getType() instanceof TrieFloatField) {
                        val = Float.valueOf(Float.intBitsToFloat(((Long)val).intValue()));
                    } else if (schemaField.getType() instanceof TrieDoubleField) {
                        val = Double.longBitsToDouble((Long)val);
                    } else if (schemaField.getType() instanceof TrieDateField) {
                        val = new Date((Long)val);
                    } else if (schemaField.getType() instanceof EnumField) {
                        val = ((EnumField)schemaField.getType()).intValueToStringValue(((Long)val).intValue());
                    }
                    doc.addField(fieldName, val);
                    break;
                }
                case BINARY: {
                    if (!DocValues.getDocsWithField((LeafReader)this.leafReader, (String)fieldName).get(docid)) break;
                    BinaryDocValues bdv = this.leafReader.getBinaryDocValues(fieldName);
                    doc.addField(fieldName, bdv.get(docid));
                    break;
                }
                case SORTED: {
                    SortedDocValues sdv = this.leafReader.getSortedDocValues(fieldName);
                    if (sdv.getOrd(docid) < 0) break;
                    doc.addField(fieldName, sdv.get(docid).utf8ToString());
                }
            }
        }
    }

    public void readDocs(Document[] docs, DocList ids) throws IOException {
        this.readDocs(docs, ids, null);
    }

    public void readDocs(Document[] docs, DocList ids, Set<String> fields) throws IOException {
        DocIterator iter = ids.iterator();
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = this.doc(iter.nextDoc(), fields);
        }
    }

    public Set<String> getNonStoredDVs(boolean onlyUseDocValuesAsStored) {
        return onlyUseDocValuesAsStored ? this.nonStoredDVsUsedAsStored : this.allNonStoredDVs;
    }

    public Set<String> getNonStoredDVsWithoutCopyTargets() {
        return this.nonStoredDVsWithoutCopyTargets;
    }

    public SolrCache<String, UnInvertedField> getFieldValueCache() {
        return this.fieldValueCache;
    }

    public Sort weightSort(Sort sort) throws IOException {
        return sort != null ? sort.rewrite((IndexSearcher)this) : null;
    }

    public int getFirstMatch(Term t) throws IOException {
        Terms terms = this.leafReader.terms(t.field());
        if (terms == null) {
            return -1;
        }
        BytesRef termBytes = t.bytes();
        TermsEnum termsEnum = terms.iterator();
        if (!termsEnum.seekExact(termBytes)) {
            return -1;
        }
        PostingsEnum docs = termsEnum.postings(null, 0);
        int id = (docs = BitsFilteredPostingsEnum.wrap(docs, this.leafReader.getLiveDocs())).nextDoc();
        return id == Integer.MAX_VALUE ? -1 : id;
    }

    public long lookupId(BytesRef idBytes) throws IOException {
        String field = this.schema.getUniqueKeyField().getName();
        int c = this.leafContexts.size();
        for (int i = 0; i < c; ++i) {
            TermsEnum te;
            LeafReaderContext leaf = (LeafReaderContext)this.leafContexts.get(i);
            LeafReader reader = leaf.reader();
            Terms terms = reader.terms(field);
            if (terms == null || !(te = terms.iterator()).seekExact(idBytes)) continue;
            PostingsEnum docs = te.postings(null, 0);
            int id = (docs = BitsFilteredPostingsEnum.wrap(docs, reader.getLiveDocs())).nextDoc();
            if (id == Integer.MAX_VALUE) continue;
            assert (docs.nextDoc() == Integer.MAX_VALUE);
            return (long)i << 32 | (long)id;
        }
        return -1L;
    }

    public void cacheDocSet(Query query, DocSet optionalAnswer, boolean mustCache) throws IOException {
        if (optionalAnswer != null) {
            if (this.filterCache != null) {
                this.filterCache.put(query, optionalAnswer);
            }
            return;
        }
        this.getDocSet(query);
    }

    public BitDocSet getDocSetBits(Query q) throws IOException {
        DocSet answer = this.getDocSet(q);
        if (answer instanceof BitDocSet) {
            return (BitDocSet)answer;
        }
        FixedBitSet bs = new FixedBitSet(this.maxDoc());
        DocIterator iter = answer.iterator();
        while (iter.hasNext()) {
            bs.set(iter.nextDoc());
        }
        BitDocSet answerBits = new BitDocSet(bs, answer.size());
        if (this.filterCache != null) {
            this.filterCache.put(q, answerBits);
        }
        return answerBits;
    }

    public DocSet getDocSet(Query query) throws IOException {
        DocSet answer;
        DocSet absAnswer;
        boolean positive;
        ExtendedQuery eq;
        if (query instanceof ExtendedQuery && !(eq = (ExtendedQuery)query).getCache()) {
            if (query instanceof WrappedQuery) {
                query = ((WrappedQuery)query).getWrappedQuery();
            }
            query = QueryUtils.makeQueryable(query);
            return this.getDocSetNC(query, null);
        }
        Query absQ = QueryUtils.getAbs(query);
        boolean bl = positive = query == absQ;
        if (this.filterCache != null && (absAnswer = this.filterCache.get(absQ)) != null) {
            if (positive) {
                return absAnswer;
            }
            return this.getPositiveDocSet(matchAllDocsQuery).andNot(absAnswer);
        }
        absAnswer = this.getDocSetNC(absQ, null);
        DocSet docSet = answer = positive ? absAnswer : this.getPositiveDocSet(matchAllDocsQuery).andNot(absAnswer);
        if (this.filterCache != null) {
            this.filterCache.put(absQ, absAnswer);
        }
        return answer;
    }

    DocSet getPositiveDocSet(Query q) throws IOException {
        DocSet answer;
        if (this.filterCache != null && (answer = this.filterCache.get(q)) != null) {
            return answer;
        }
        answer = this.getDocSetNC(q, null);
        if (this.filterCache != null) {
            this.filterCache.put(q, answer);
        }
        return answer;
    }

    private DocSet getDocSetScore(List<Query> queries) throws IOException {
        Query main = queries.remove(0);
        ProcessedFilter pf = this.getProcessedFilter(null, queries);
        DocSetCollector setCollector = new DocSetCollector(this.maxDoc());
        SimpleCollector collector = setCollector;
        if (pf.postFilter != null) {
            pf.postFilter.setLastDelegate((Collector)collector);
            collector = pf.postFilter;
        }
        if (pf.filter != null) {
            this.search((Query)new FilteredQuery(main, pf.filter), (Collector)collector);
        } else {
            this.search(main, (Collector)collector);
        }
        if (collector instanceof DelegatingCollector) {
            ((DelegatingCollector)collector).finish();
        }
        DocSet docSet = setCollector.getDocSet();
        return docSet;
    }

    public DocSet getDocSet(List<Query> queries) throws IOException {
        if (queries != null) {
            for (Query q : queries) {
                if (!(q instanceof ScoreFilter)) continue;
                return this.getDocSetScore(queries);
            }
        }
        ProcessedFilter pf = this.getProcessedFilter(null, queries);
        if (pf.answer != null) {
            return pf.answer;
        }
        DocSetCollector setCollector = new DocSetCollector(this.maxDoc());
        SimpleCollector collector = setCollector;
        if (pf.postFilter != null) {
            pf.postFilter.setLastDelegate((Collector)collector);
            collector = pf.postFilter;
        }
        for (LeafReaderContext leaf : this.leafContexts) {
            int docid;
            LeafReader reader = leaf.reader();
            Bits liveDocs = reader.getLiveDocs();
            DocIdSet idSet = null;
            if (pf.filter != null && (idSet = pf.filter.getDocIdSet(leaf, liveDocs)) == null) continue;
            DocIdSetIterator idIter = null;
            if (idSet != null) {
                idIter = idSet.iterator();
                if (idIter == null) continue;
                if (!pf.hasDeletedDocs) {
                    liveDocs = null;
                }
            }
            LeafCollector leafCollector = collector.getLeafCollector(leaf);
            int max = reader.maxDoc();
            if (idIter == null) {
                for (docid = 0; docid < max; ++docid) {
                    if (liveDocs != null && !liveDocs.get(docid)) continue;
                    leafCollector.collect(docid);
                }
                continue;
            }
            if (liveDocs != null) {
                docid = -1;
                while ((docid = idIter.advance(docid + 1)) < max) {
                    if (!liveDocs.get(docid)) continue;
                    leafCollector.collect(docid);
                }
                continue;
            }
            docid = -1;
            while ((docid = idIter.advance(docid + 1)) < max) {
                leafCollector.collect(docid);
            }
        }
        if (collector instanceof DelegatingCollector) {
            ((DelegatingCollector)collector).finish();
        }
        return setCollector.getDocSet();
    }

    public ProcessedFilter getProcessedFilter(DocSet setFilter, List<Query> queries) throws IOException {
        int i;
        ProcessedFilter pf = new ProcessedFilter();
        if (queries == null || queries.size() == 0) {
            if (setFilter != null) {
                pf.filter = setFilter.getTopFilter();
            }
            return pf;
        }
        DocSet answer = null;
        boolean[] neg = new boolean[queries.size() + 1];
        DocSet[] sets = new DocSet[queries.size() + 1];
        ArrayList<Query> notCached = null;
        ArrayList<Query> postFilters = null;
        int end = 0;
        int smallestIndex = -1;
        if (setFilter != null) {
            int n = end++;
            DocSet docSet = setFilter;
            sets[n] = docSet;
            answer = docSet;
            smallestIndex = end;
        }
        int smallestCount = Integer.MAX_VALUE;
        for (Query q : queries) {
            ExtendedQuery eq;
            if (q instanceof ExtendedQuery && !(eq = (ExtendedQuery)q).getCache()) {
                if (eq.getCost() >= 100 && eq instanceof PostFilter) {
                    if (postFilters == null) {
                        postFilters = new ArrayList<Query>(sets.length - end);
                    }
                    postFilters.add(q);
                    continue;
                }
                if (notCached == null) {
                    notCached = new ArrayList(sets.length - end);
                }
                notCached.add(q);
                continue;
            }
            if (this.filterCache == null) {
                if (notCached == null) {
                    notCached = new ArrayList<Query>(sets.length - end);
                }
                WrappedQuery uncached = new WrappedQuery(q);
                uncached.setCache(false);
                notCached.add(uncached);
                continue;
            }
            Query posQuery = QueryUtils.getAbs(q);
            sets[end] = this.getPositiveDocSet(posQuery);
            if (q == posQuery) {
                neg[end] = false;
                int sz = sets[end].size();
                if (sz < smallestCount) {
                    smallestCount = sz;
                    smallestIndex = end;
                    answer = sets[end];
                }
            } else {
                neg[end] = true;
            }
            ++end;
        }
        if (end > 0 && answer == null) {
            answer = this.getPositiveDocSet(matchAllDocsQuery);
        }
        for (i = 0; i < end; ++i) {
            if (!neg[i]) continue;
            answer = answer.andNot(sets[i]);
        }
        for (i = 0; i < end; ++i) {
            if (neg[i] || i == smallestIndex) continue;
            answer = answer.intersection(sets[i]);
        }
        if (notCached != null) {
            Collections.sort(notCached, sortByCost);
            ArrayList<Weight> weights = new ArrayList<Weight>(notCached.size());
            for (Query q : notCached) {
                Query qq = QueryUtils.makeQueryable(q);
                weights.add(this.createNormalizedWeight(qq, true));
            }
            pf.filter = new FilterImpl(answer, weights);
            pf.hasDeletedDocs = answer == null;
        } else {
            if (postFilters == null) {
                if (answer == null) {
                    answer = this.getPositiveDocSet(matchAllDocsQuery);
                }
                pf.answer = answer;
            }
            if (answer != null) {
                pf.filter = answer.getTopFilter();
            }
        }
        if (postFilters != null) {
            Collections.sort(postFilters, sortByCost);
            for (int i2 = postFilters.size() - 1; i2 >= 0; --i2) {
                DelegatingCollector prev = pf.postFilter;
                pf.postFilter = ((PostFilter)postFilters.get(i2)).getFilterCollector(this);
                if (prev == null) continue;
                pf.postFilter.setDelegate((Collector)prev);
            }
        }
        return pf;
    }

    public DocSet getDocSet(DocsEnumState deState) throws IOException {
        DocSet result;
        DocSet result2;
        int largestPossible = deState.termsEnum.docFreq();
        boolean useCache = this.filterCache != null && largestPossible >= deState.minSetSizeCached;
        TermQuery key = null;
        if (useCache && (result2 = this.filterCache.get((Query)(key = new TermQuery(new Term(deState.fieldName, deState.termsEnum.term()))))) != null) {
            return result2;
        }
        int smallSetSize = DocSetUtil.smallSetSize(this.maxDoc());
        int scratchSize = Math.min(smallSetSize, largestPossible);
        if (deState.scratch == null || deState.scratch.length < scratchSize) {
            deState.scratch = new int[scratchSize];
        }
        int[] docs = deState.scratch;
        int upto = 0;
        int bitsSet = 0;
        FixedBitSet fbs = null;
        PostingsEnum postingsEnum = deState.termsEnum.postings(deState.postingsEnum, 0);
        postingsEnum = BitsFilteredPostingsEnum.wrap(postingsEnum, deState.liveDocs);
        if (deState.postingsEnum == null) {
            deState.postingsEnum = postingsEnum;
        }
        if (postingsEnum instanceof MultiPostingsEnum) {
            MultiPostingsEnum.EnumWithSlice[] subs = ((MultiPostingsEnum)postingsEnum).getSubs();
            int numSubs = ((MultiPostingsEnum)postingsEnum).getNumSubs();
            for (int subindex = 0; subindex < numSubs; ++subindex) {
                int docid;
                MultiPostingsEnum.EnumWithSlice sub = subs[subindex];
                if (sub.postingsEnum == null) continue;
                int base = sub.slice.start;
                if (largestPossible > docs.length) {
                    if (fbs == null) {
                        fbs = new FixedBitSet(this.maxDoc());
                    }
                    while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        fbs.set(docid + base);
                        ++bitsSet;
                    }
                    continue;
                }
                while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    docs[upto++] = docid + base;
                }
            }
        } else if (largestPossible > docs.length) {
            int docid;
            if (fbs == null) {
                fbs = new FixedBitSet(this.maxDoc());
            }
            while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                fbs.set(docid);
                ++bitsSet;
            }
        } else {
            int docid;
            while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                docs[upto++] = docid;
            }
        }
        if (fbs != null) {
            for (int i = 0; i < upto; ++i) {
                fbs.set(docs[i]);
            }
            result = new BitDocSet(fbs, bitsSet += upto);
        } else {
            DocSet docSet = result = upto == 0 ? DocSet.EMPTY : new SortedIntDocSet(Arrays.copyOf(docs, upto));
        }
        if (useCache) {
            this.filterCache.put((Query)key, result);
        }
        return result;
    }

    protected DocSet getDocSetNC(Query query, DocSet filter) throws IOException {
        return DocSetUtil.createDocSet(this, query, filter);
    }

    public DocSet getDocSet(Query query, DocSet filter) throws IOException {
        boolean positive;
        ExtendedQuery eq;
        if (filter == null) {
            return this.getDocSet(query);
        }
        if (query instanceof ExtendedQuery && !(eq = (ExtendedQuery)query).getCache()) {
            if (query instanceof WrappedQuery) {
                query = ((WrappedQuery)query).getWrappedQuery();
            }
            query = QueryUtils.makeQueryable(query);
            return this.getDocSetNC(query, filter);
        }
        Query absQ = QueryUtils.getAbs(query);
        boolean bl = positive = absQ == query;
        if (this.filterCache != null) {
            DocSet first = this.filterCache.get(absQ);
            if (first == null) {
                first = this.getDocSetNC(absQ, null);
                this.filterCache.put(absQ, first);
            }
            return positive ? first.intersection(filter) : filter.andNot(first);
        }
        return positive ? this.getDocSetNC(absQ, filter) : filter.andNot(this.getPositiveDocSet(absQ));
    }

    public DocList getDocList(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    public DocList getDocList(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    private void getDocListC(QueryResult qr, QueryCommand cmd) throws IOException {
        ExtendedQuery eq;
        DocListAndSet out = new DocListAndSet();
        qr.setDocListAndSet(out);
        QueryResultKey key = null;
        int maxDocRequested = cmd.getOffset() + cmd.getLen();
        if (maxDocRequested < 0 || maxDocRequested > this.maxDoc()) {
            maxDocRequested = this.maxDoc();
        }
        int supersetMaxDoc = maxDocRequested;
        DocList superset = null;
        int flags = cmd.getFlags();
        Query q = cmd.getQuery();
        if (q instanceof ExtendedQuery && !(eq = (ExtendedQuery)q).getCache()) {
            flags |= 0xB0000000;
        }
        if (this.queryResultCache != null && cmd.getFilter() == null && (flags & 0x90000000) != -1879048192) {
            key = new QueryResultKey(q, cmd.getFilterList(), cmd.getSort(), flags);
            if ((flags & Integer.MIN_VALUE) == 0) {
                superset = this.queryResultCache.get(key);
                if (superset != null && ((flags & 1) == 0 || superset.hasScores())) {
                    out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
                }
                if (out.docList != null) {
                    if (out.docSet == null && (flags & 0x40000000) != 0) {
                        if (cmd.getFilterList() == null) {
                            out.docSet = this.getDocSet(cmd.getQuery());
                        } else {
                            ArrayList<Query> newList = new ArrayList<Query>(cmd.getFilterList().size() + 1);
                            newList.add(cmd.getQuery());
                            newList.addAll(cmd.getFilterList());
                            out.docSet = this.getDocSet(newList);
                        }
                    }
                    return;
                }
            }
            if ((flags & 0x10000000) == 0) {
                if (maxDocRequested < this.queryResultWindowSize) {
                    supersetMaxDoc = this.queryResultWindowSize;
                } else {
                    supersetMaxDoc = ((maxDocRequested - 1) / this.queryResultWindowSize + 1) * this.queryResultWindowSize;
                    if (supersetMaxDoc < 0) {
                        supersetMaxDoc = maxDocRequested;
                    }
                }
            } else {
                key = null;
            }
        }
        cmd.setSupersetMaxDoc(supersetMaxDoc);
        boolean useFilterCache = false;
        if ((flags & 0x20000001) == 0 && this.useFilterForSortedQuery && cmd.getSort() != null && this.filterCache != null) {
            SortField[] sfields;
            useFilterCache = true;
            for (SortField sf : sfields = cmd.getSort().getSort()) {
                if (sf.getType() != SortField.Type.SCORE) continue;
                useFilterCache = false;
                break;
            }
        }
        if (useFilterCache) {
            if (out.docSet == null) {
                out.docSet = this.getDocSet(cmd.getQuery(), cmd.getFilter());
                DocSet bigFilt = this.getDocSet(cmd.getFilterList());
                if (bigFilt != null) {
                    out.docSet = out.docSet.intersection(bigFilt);
                }
            }
            this.sortDocSet(qr, cmd);
        } else {
            if ((flags & 0x40000000) != 0) {
                DocSet qDocSet = this.getDocListAndSetNC(qr, cmd);
                if (qDocSet != null && this.filterCache != null && !qr.isPartialResults()) {
                    this.filterCache.put(cmd.getQuery(), qDocSet);
                }
            } else {
                this.getDocListNC(qr, cmd);
            }
            assert (null != out.docList) : "docList is null";
        }
        if (null == cmd.getCursorMark()) {
            superset = out.docList;
            out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
        } else {
            assert (null == superset) : "cursor: superset isn't null";
            assert (0 == cmd.getOffset()) : "cursor: command offset mismatch";
            assert (0 == out.docList.offset()) : "cursor: docList offset mismatch";
            assert (cmd.getLen() >= supersetMaxDoc) : "cursor: superset len mismatch: " + cmd.getLen() + " vs " + supersetMaxDoc;
        }
        if (key != null && superset.size() <= this.queryResultMaxDocsCached && !qr.isPartialResults()) {
            this.queryResultCache.put(key, superset);
        }
    }

    private void populateNextCursorMarkFromTopDocs(QueryResult qr, QueryCommand qc, TopDocs topDocs) {
        if (null == qc.getCursorMark()) {
            return;
        }
        CursorMark lastCursorMark = qc.getCursorMark();
        assert (topDocs instanceof TopFieldDocs) : "TopFieldDocs cursor constraint violated";
        TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
        ScoreDoc[] scoreDocs = topFieldDocs.scoreDocs;
        if (0 == scoreDocs.length) {
            qr.setNextCursorMark(lastCursorMark);
        } else {
            ScoreDoc lastDoc = scoreDocs[scoreDocs.length - 1];
            assert (lastDoc instanceof FieldDoc) : "FieldDoc cursor constraint violated";
            List<Object> lastFields = Arrays.asList(((FieldDoc)lastDoc).fields);
            CursorMark nextCursorMark = lastCursorMark.createNext(lastFields);
            assert (null != nextCursorMark) : "null nextCursorMark";
            qr.setNextCursorMark(nextCursorMark);
        }
    }

    private TopDocsCollector buildTopDocsCollector(int len, QueryCommand cmd) throws IOException {
        Query q = cmd.getQuery();
        if (q instanceof RankQuery) {
            RankQuery rq = (RankQuery)q;
            return rq.getTopDocsCollector(len, cmd, this);
        }
        if (null == cmd.getSort()) {
            assert (null == cmd.getCursorMark()) : "have cursor but no sort";
            return TopScoreDocCollector.create((int)len);
        }
        boolean needScores = (cmd.getFlags() & 1) != 0;
        Sort weightedSort = this.weightSort(cmd.getSort());
        CursorMark cursor = cmd.getCursorMark();
        boolean fillFields = null != cursor;
        FieldDoc searchAfter = null != cursor ? cursor.getSearchAfterFieldDoc() : null;
        return TopFieldCollector.create((Sort)weightedSort, (int)len, (FieldDoc)searchAfter, (boolean)fillFields, (boolean)needScores, (boolean)needScores);
    }

    private void getDocListNC(QueryResult qr, QueryCommand cmd) throws IOException {
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int nDocsReturned;
        int len = cmd.getSupersetMaxDoc();
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        int lastDocRequested = last;
        boolean needScores = (cmd.getFlags() & 1) != 0;
        Query query = QueryUtils.makeQueryable(cmd.getQuery());
        ProcessedFilter pf = this.getProcessedFilter(cmd.getFilter(), cmd.getFilterList());
        if (pf.filter != null) {
            query = new FilteredQuery(query, pf.filter);
        }
        if (lastDocRequested <= 0) {
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            final int[] numHits = new int[1];
            SimpleCollector collector = !needScores ? new SimpleCollector(){

                public void collect(int doc) {
                    numHits[0] = numHits[0] + 1;
                }

                public boolean needsScores() {
                    return false;
                }
            } : new SimpleCollector(){
                Scorer scorer;

                public void setScorer(Scorer scorer) {
                    this.scorer = scorer;
                }

                public void collect(int doc) throws IOException {
                    numHits[0] = numHits[0] + 1;
                    float score = this.scorer.score();
                    if (score > topscore[0]) {
                        topscore[0] = score;
                    }
                }

                public boolean needsScores() {
                    return true;
                }
            };
            this.buildAndRunCollectorChain(qr, query, (Collector)collector, cmd, pf.postFilter);
            nDocsReturned = 0;
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = numHits[0];
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
            qr.setNextCursorMark(cmd.getCursorMark());
        } else {
            TopDocsCollector topCollector;
            TopDocsCollector collector = topCollector = this.buildTopDocsCollector(len, cmd);
            this.buildAndRunCollectorChain(qr, query, (Collector)collector, cmd, pf.postFilter);
            totalHits = topCollector.getTotalHits();
            TopDocs topDocs = topCollector.topDocs(0, len);
            this.populateNextCursorMarkFromTopDocs(qr, cmd, topDocs);
            maxScore = totalHits > 0 ? topDocs.getMaxScore() : 0.0f;
            nDocsReturned = topDocs.scoreDocs.length;
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            for (int i = 0; i < nDocsReturned; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                ids[i] = scoreDoc.doc;
                if (scores == null) continue;
                scores[i] = scoreDoc.score;
            }
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore));
    }

    private DocSet getDocListAndSetNC(QueryResult qr, QueryCommand cmd) throws IOException {
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int nDocsReturned;
        DocSet set;
        int len = cmd.getSupersetMaxDoc();
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        int lastDocRequested = last;
        boolean needScores = (cmd.getFlags() & 1) != 0;
        int maxDoc = this.maxDoc();
        ProcessedFilter pf = this.getProcessedFilter(cmd.getFilter(), cmd.getFilterList());
        Query query = QueryUtils.makeQueryable(cmd.getQuery());
        if (pf.filter != null) {
            query = new FilteredQuery(query, pf.filter);
        }
        if (lastDocRequested <= 0) {
            DocSetCollector collector;
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            DocSetCollector setCollector = new DocSetCollector(maxDoc);
            if (!needScores) {
                collector = setCollector;
            } else {
                SimpleCollector topScoreCollector = new SimpleCollector(){
                    Scorer scorer;

                    public void setScorer(Scorer scorer) throws IOException {
                        this.scorer = scorer;
                    }

                    public void collect(int doc) throws IOException {
                        float score = this.scorer.score();
                        if (score > topscore[0]) {
                            topscore[0] = score;
                        }
                    }

                    public boolean needsScores() {
                        return true;
                    }
                };
                collector = MultiCollector.wrap((Collector[])new Collector[]{setCollector, topScoreCollector});
            }
            this.buildAndRunCollectorChain(qr, query, (Collector)collector, cmd, pf.postFilter);
            set = setCollector.getDocSet();
            nDocsReturned = 0;
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = set.size();
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
            qr.setNextCursorMark(cmd.getCursorMark());
        } else {
            TopDocsCollector topCollector = this.buildTopDocsCollector(len, cmd);
            DocSetCollector setCollector = new DocSetCollector(maxDoc);
            Collector collector = MultiCollector.wrap((Collector[])new Collector[]{topCollector, setCollector});
            this.buildAndRunCollectorChain(qr, query, collector, cmd, pf.postFilter);
            set = setCollector.getDocSet();
            totalHits = topCollector.getTotalHits();
            assert (totalHits == set.size());
            TopDocs topDocs = topCollector.topDocs(0, len);
            this.populateNextCursorMarkFromTopDocs(qr, cmd, topDocs);
            maxScore = totalHits > 0 ? topDocs.getMaxScore() : 0.0f;
            nDocsReturned = topDocs.scoreDocs.length;
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            for (int i = 0; i < nDocsReturned; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                ids[i] = scoreDoc.doc;
                if (scores == null) continue;
                scores[i] = scoreDoc.score;
            }
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore));
        qr.setDocSet(set);
        return pf.filter == null && pf.postFilter == null ? qr.getDocSet() : null;
    }

    public DocList getDocList(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    protected void sortDocSet(QueryResult qr, QueryCommand cmd) throws IOException {
        DocSet set = qr.getDocListAndSet().docSet;
        int nDocs = cmd.getSupersetMaxDoc();
        if (nDocs == 0) {
            qr.getDocListAndSet().docList = new DocSlice(0, 0, new int[0], null, set.size(), 0.0f);
            qr.setNextCursorMark(cmd.getCursorMark());
            return;
        }
        boolean inOrder = set instanceof BitDocSet || set instanceof SortedIntDocSet;
        TopDocsCollector topCollector = this.buildTopDocsCollector(nDocs, cmd);
        DocIterator iter = set.iterator();
        int base = 0;
        int end = 0;
        int readerIndex = 0;
        LeafCollector leafCollector = null;
        while (iter.hasNext()) {
            int doc = iter.nextDoc();
            while (doc >= end) {
                LeafReaderContext leaf = (LeafReaderContext)this.leafContexts.get(readerIndex++);
                base = leaf.docBase;
                end = base + leaf.reader().maxDoc();
                leafCollector = topCollector.getLeafCollector(leaf);
            }
            leafCollector.collect(doc - base);
        }
        TopDocs topDocs = topCollector.topDocs(0, nDocs);
        int nDocsReturned = topDocs.scoreDocs.length;
        int[] ids = new int[nDocsReturned];
        for (int i = 0; i < nDocsReturned; ++i) {
            ScoreDoc scoreDoc = topDocs.scoreDocs[i];
            ids[i] = scoreDoc.doc;
        }
        qr.getDocListAndSet().docList = new DocSlice(0, nDocsReturned, ids, null, topDocs.totalHits, 0.0f);
        this.populateNextCursorMarkFromTopDocs(qr, cmd, topDocs);
    }

    public int numDocs(Query a, DocSet b) throws IOException {
        if (this.filterCache != null) {
            Query absQ = QueryUtils.getAbs(a);
            DocSet positiveA = this.getPositiveDocSet(absQ);
            return a == absQ ? b.intersectionSize(positiveA) : b.andNotSize(positiveA);
        }
        TotalHitCountCollector collector = new TotalHitCountCollector();
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add(QueryUtils.makeQueryable(a), BooleanClause.Occur.MUST);
        bq.add((Query)new ConstantScoreQuery((Query)b.getTopFilter()), BooleanClause.Occur.MUST);
        super.search((Query)bq.build(), (Collector)collector);
        return collector.getTotalHits();
    }

    public int numDocs(DocSet a, DocsEnumState deState) throws IOException {
        return a.intersectionSize(this.getDocSet(deState));
    }

    public int numDocs(Query a, Query b) throws IOException {
        Query absA = QueryUtils.getAbs(a);
        Query absB = QueryUtils.getAbs(b);
        DocSet positiveA = this.getPositiveDocSet(absA);
        DocSet positiveB = this.getPositiveDocSet(absB);
        if (a == absA) {
            if (b == absB) {
                return positiveA.intersectionSize(positiveB);
            }
            return positiveA.andNotSize(positiveB);
        }
        if (b == absB) {
            return positiveB.andNotSize(positiveA);
        }
        DocSet all = this.getPositiveDocSet(matchAllDocsQuery);
        return all.andNotSize(positiveA.union(positiveB));
    }

    public Document[] readDocs(DocList ids) throws IOException {
        Document[] docs = new Document[ids.size()];
        this.readDocs(docs, ids);
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warm(SolrIndexSearcher old) throws IOException {
        long warmingStartTime = System.nanoTime();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("warming", "true");
        for (int i = 0; i < this.cacheList.length; ++i) {
            if (this.debug) {
                log.debug("autowarming " + this + " from " + old + "\n\t" + old.cacheList[i]);
            }
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, params){

                @Override
                public SolrIndexSearcher getSearcher() {
                    return SolrIndexSearcher.this;
                }

                @Override
                public void close() {
                }
            };
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.clearRequestInfo();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            try {
                this.cacheList[i].warm(this, old.cacheList[i]);
            }
            finally {
                try {
                    req.close();
                }
                finally {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
            if (!this.debug) continue;
            log.debug("autowarming result for " + this + "\n\t" + this.cacheList[i]);
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    public SolrCache getCache(String cacheName) {
        return this.cacheMap.get(cacheName);
    }

    public Object cacheLookup(String cacheName, Object key) {
        SolrCache cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.get(key);
    }

    public Object cacheInsert(String cacheName, Object key, Object val) {
        SolrCache cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.put(key, val);
    }

    public Date getOpenTimeStamp() {
        return this.openTime;
    }

    public long getOpenNanoTime() {
        return this.openNanoTime;
    }

    @Deprecated
    public long getOpenTime() {
        return this.openTime.getTime();
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return super.explain(QueryUtils.makeQueryable(query), doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexFingerprint getIndexFingerprint(long maxVersion) throws IOException {
        IndexFingerprint fingerprint = this.maxVersionFingerprintCache.get(maxVersion);
        if (fingerprint != null) {
            return fingerprint;
        }
        Map<Long, IndexFingerprint> map = this.maxVersionFingerprintCache;
        synchronized (map) {
            fingerprint = this.maxVersionFingerprintCache.get(this.maxVersionFingerprintCache);
            if (fingerprint != null) {
                return fingerprint;
            }
            fingerprint = IndexFingerprint.getFingerprint(this, maxVersion);
            this.maxVersionFingerprintCache.put(maxVersion, fingerprint);
            return fingerprint;
        }
    }

    @Override
    public String getName() {
        return SolrIndexSearcher.class.getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "index searcher";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList<Object> getStatistics() {
        SimpleOrderedMap<Object> lst = new SimpleOrderedMap<Object>();
        lst.add("searcherName", this.name);
        lst.add("caching", this.cachingEnabled);
        lst.add("numDocs", this.reader.numDocs());
        lst.add("maxDoc", this.reader.maxDoc());
        lst.add("deletedDocs", this.reader.maxDoc() - this.reader.numDocs());
        lst.add("reader", this.reader.toString());
        lst.add("readerDir", this.reader.directory());
        lst.add("indexVersion", this.reader.getVersion());
        lst.add("openedAt", this.openTime);
        if (this.registerTime != null) {
            lst.add("registeredAt", this.registerTime);
        }
        lst.add("warmupTime", this.warmupTime);
        return lst;
    }

    public static class QueryResult {
        private boolean partialResults;
        private DocListAndSet docListAndSet;
        private CursorMark nextCursorMark;
        public Object groupedResults;

        public DocList getDocList() {
            return this.docListAndSet.docList;
        }

        public void setDocList(DocList list) {
            if (this.docListAndSet == null) {
                this.docListAndSet = new DocListAndSet();
            }
            this.docListAndSet.docList = list;
        }

        public DocSet getDocSet() {
            return this.docListAndSet.docSet;
        }

        public void setDocSet(DocSet set) {
            if (this.docListAndSet == null) {
                this.docListAndSet = new DocListAndSet();
            }
            this.docListAndSet.docSet = set;
        }

        public boolean isPartialResults() {
            return this.partialResults;
        }

        public void setPartialResults(boolean partialResults) {
            this.partialResults = partialResults;
        }

        public void setDocListAndSet(DocListAndSet listSet) {
            this.docListAndSet = listSet;
        }

        public DocListAndSet getDocListAndSet() {
            return this.docListAndSet;
        }

        public void setNextCursorMark(CursorMark next) {
            this.nextCursorMark = next;
        }

        public CursorMark getNextCursorMark() {
            return this.nextCursorMark;
        }
    }

    public static class QueryCommand {
        private Query query;
        private List<Query> filterList;
        private DocSet filter;
        private Sort sort;
        private int offset;
        private int len;
        private int supersetMaxDoc;
        private int flags;
        private long timeAllowed = -1L;
        private CursorMark cursorMark;

        public CursorMark getCursorMark() {
            return this.cursorMark;
        }

        public QueryCommand setCursorMark(CursorMark cursorMark) {
            this.cursorMark = cursorMark;
            if (null != cursorMark) {
                this.flags |= 0x90000000;
            }
            return this;
        }

        public Query getQuery() {
            return this.query;
        }

        public QueryCommand setQuery(Query query) {
            this.query = query;
            return this;
        }

        public List<Query> getFilterList() {
            return this.filterList;
        }

        public QueryCommand setFilterList(List<Query> filterList) {
            if (this.filter != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filterList = filterList;
            return this;
        }

        public QueryCommand setFilterList(Query f) {
            if (this.filter != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filterList = null;
            if (f != null) {
                this.filterList = new ArrayList<Query>(2);
                this.filterList.add(f);
            }
            return this;
        }

        public DocSet getFilter() {
            return this.filter;
        }

        public QueryCommand setFilter(DocSet filter) {
            if (this.filterList != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filter = filter;
            return this;
        }

        public Sort getSort() {
            return this.sort;
        }

        public QueryCommand setSort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public int getOffset() {
            return this.offset;
        }

        public QueryCommand setOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public int getLen() {
            return this.len;
        }

        public QueryCommand setLen(int len) {
            this.len = len;
            return this;
        }

        public int getSupersetMaxDoc() {
            return this.supersetMaxDoc;
        }

        public QueryCommand setSupersetMaxDoc(int supersetMaxDoc) {
            this.supersetMaxDoc = supersetMaxDoc;
            return this;
        }

        public int getFlags() {
            return this.flags;
        }

        public QueryCommand replaceFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public QueryCommand setFlags(int flags) {
            this.flags |= flags;
            return this;
        }

        public QueryCommand clearFlags(int flags) {
            this.flags &= ~flags;
            return this;
        }

        public long getTimeAllowed() {
            return this.timeAllowed;
        }

        public QueryCommand setTimeAllowed(long timeAllowed) {
            this.timeAllowed = timeAllowed;
            return this;
        }

        public boolean isNeedDocSet() {
            return (this.flags & 0x40000000) != 0;
        }

        public QueryCommand setNeedDocSet(boolean needDocSet) {
            return needDocSet ? this.setFlags(0x40000000) : this.clearFlags(0x40000000);
        }

        public boolean getTerminateEarly() {
            return (this.flags & 4) != 0;
        }

        public QueryCommand setTerminateEarly(boolean segmentTerminateEarly) {
            return segmentTerminateEarly ? this.setFlags(4) : this.clearFlags(4);
        }
    }

    public static class DocsEnumState {
        public String fieldName;
        public TermsEnum termsEnum;
        public Bits liveDocs;
        public PostingsEnum postingsEnum;
        public int minSetSizeCached;
        public int[] scratch;
    }

    public static class ProcessedFilter {
        public DocSet answer;
        public Filter filter;
        public DelegatingCollector postFilter;
        public boolean hasDeletedDocs;
    }

    static class SetNonLazyFieldSelector
    extends StoredFieldVisitor {
        private Set<String> fieldsToLoad;
        final Document doc = new Document();
        final LazyDocument lazyDoc;

        SetNonLazyFieldSelector(Set<String> toLoad, IndexReader reader, int docID) {
            this.fieldsToLoad = toLoad;
            this.lazyDoc = new LazyDocument(reader, docID);
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
            if (this.fieldsToLoad.contains(fieldInfo.name)) {
                return StoredFieldVisitor.Status.YES;
            }
            this.doc.add(this.lazyDoc.getField(fieldInfo));
            return StoredFieldVisitor.Status.NO;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.doc.add((IndexableField)new StoredField(fieldInfo.name, value));
        }

        public void stringField(FieldInfo fieldInfo, byte[] bytes) throws IOException {
            String value = new String(bytes, StandardCharsets.UTF_8);
            FieldType ft = new FieldType(org.apache.lucene.document.TextField.TYPE_STORED);
            ft.setStoreTermVectors(fieldInfo.hasVectors());
            ft.setOmitNorms(fieldInfo.omitsNorms());
            ft.setIndexOptions(fieldInfo.getIndexOptions());
            this.doc.add((IndexableField)new Field(fieldInfo.name, value, ft));
        }

        public void intField(FieldInfo fieldInfo, int value) {
            FieldType ft = new FieldType(IntField.TYPE_NOT_STORED);
            ft.setStored(true);
            ft.setIndexOptions(fieldInfo.getIndexOptions());
            this.doc.add((IndexableField)new IntField(fieldInfo.name, value, ft));
        }

        public void longField(FieldInfo fieldInfo, long value) {
            FieldType ft = new FieldType(LongField.TYPE_NOT_STORED);
            ft.setStored(true);
            ft.setIndexOptions(fieldInfo.getIndexOptions());
            this.doc.add((IndexableField)new LongField(fieldInfo.name, value, ft));
        }

        public void floatField(FieldInfo fieldInfo, float value) {
            FieldType ft = new FieldType(FloatField.TYPE_NOT_STORED);
            ft.setStored(true);
            ft.setIndexOptions(fieldInfo.getIndexOptions());
            this.doc.add((IndexableField)new FloatField(fieldInfo.name, value, ft));
        }

        public void doubleField(FieldInfo fieldInfo, double value) {
            FieldType ft = new FieldType(DoubleField.TYPE_NOT_STORED);
            ft.setStored(true);
            ft.setIndexOptions(fieldInfo.getIndexOptions());
            this.doc.add((IndexableField)new DoubleField(fieldInfo.name, value, ft));
        }
    }
}

