/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.IntFloatHashMap;
import com.carrotsearch.hppc.IntIntHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class ReRankQParserPlugin
extends QParserPlugin {
    public static final String NAME = "rerank";
    private static Query defaultQuery = new MatchAllDocsQuery();
    public static final String RERANK_QUERY = "reRankQuery";
    public static final String RERANK_DOCS = "reRankDocs";
    public static final int RERANK_DOCS_DEFAULT = 200;
    public static final String RERANK_WEIGHT = "reRankWeight";
    public static final double RERANK_WEIGHT_DEFAULT = 2.0;

    @Override
    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ReRankQParser(query, localParams, params, req);
    }

    static /* synthetic */ Query access$000() {
        return defaultQuery;
    }

    public class BoostedComp
    implements Comparator {
        IntFloatHashMap boostedMap;

        public BoostedComp(IntIntHashMap boostedDocs, ScoreDoc[] scoreDocs, float maxScore) {
            int idx;
            this.boostedMap = new IntFloatHashMap(boostedDocs.size() * 2);
            for (int i = 0; i < scoreDocs.length && (idx = boostedDocs.indexOf(scoreDocs[i].doc)) >= 0; ++i) {
                this.boostedMap.put(scoreDocs[i].doc, maxScore + (float)boostedDocs.indexGet(idx));
            }
        }

        public int compare(Object o1, Object o2) {
            ScoreDoc doc1 = (ScoreDoc)o1;
            ScoreDoc doc2 = (ScoreDoc)o2;
            float score1 = doc1.score;
            float score2 = doc2.score;
            int idx = this.boostedMap.indexOf(doc1.doc);
            if (idx >= 0) {
                score1 = this.boostedMap.indexGet(idx);
            }
            if ((idx = this.boostedMap.indexOf(doc2.doc)) >= 0) {
                score2 = this.boostedMap.indexGet(idx);
            }
            return -Float.compare(score1, score2);
        }
    }

    private class ReRankCollector
    extends TopDocsCollector {
        private Query reRankQuery;
        private TopDocsCollector mainCollector;
        private IndexSearcher searcher;
        private int reRankDocs;
        private int length;
        private double reRankWeight;
        private Map<BytesRef, Integer> boostedPriority;

        public ReRankCollector(int reRankDocs, int length, Query reRankQuery, double reRankWeight, SolrIndexSearcher.QueryCommand cmd, IndexSearcher searcher, Map<BytesRef, Integer> boostedPriority) throws IOException {
            super(null);
            this.reRankQuery = reRankQuery;
            this.reRankDocs = reRankDocs;
            this.length = length;
            this.boostedPriority = boostedPriority;
            Sort sort = cmd.getSort();
            if (sort == null) {
                this.mainCollector = TopScoreDocCollector.create((int)Math.max(this.reRankDocs, length));
            } else {
                sort = sort.rewrite(searcher);
                this.mainCollector = TopFieldCollector.create((Sort)sort, (int)Math.max(this.reRankDocs, length), (boolean)false, (boolean)true, (boolean)true);
            }
            this.searcher = searcher;
            this.reRankWeight = reRankWeight;
        }

        public int getTotalHits() {
            return this.mainCollector.getTotalHits();
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return this.mainCollector.getLeafCollector(context);
        }

        public boolean needsScores() {
            return true;
        }

        public TopDocs topDocs(int start, int howMany) {
            try {
                TopDocs mainDocs = this.mainCollector.topDocs(0, Math.max(this.reRankDocs, this.length));
                if (mainDocs.totalHits == 0 || mainDocs.scoreDocs.length == 0) {
                    return mainDocs;
                }
                if (this.boostedPriority != null) {
                    SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
                    Map<Object, Object> requestContext = null;
                    if (info != null) {
                        requestContext = info.getReq().getContext();
                    }
                    IntIntHashMap boostedDocs = QueryElevationComponent.getBoostDocs((SolrIndexSearcher)this.searcher, this.boostedPriority, requestContext);
                    ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
                    ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
                    System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
                    mainDocs.scoreDocs = reRankScoreDocs;
                    TopDocs rescoredDocs = new QueryRescorer(this.reRankQuery){

                        protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                            float score = firstPassScore;
                            if (secondPassMatches) {
                                score = (float)((double)score + ReRankCollector.this.reRankWeight * (double)secondPassScore);
                            }
                            return score;
                        }
                    }.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
                    Arrays.sort(rescoredDocs.scoreDocs, new BoostedComp(boostedDocs, mainDocs.scoreDocs, rescoredDocs.getMaxScore()));
                    howMany = Math.min(howMany, mainScoreDocs.length);
                    if (howMany == rescoredDocs.scoreDocs.length) {
                        return rescoredDocs;
                    }
                    if (howMany > rescoredDocs.scoreDocs.length) {
                        ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                        System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                        System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                        rescoredDocs.scoreDocs = scoreDocs;
                        return rescoredDocs;
                    }
                    ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                    System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
                    rescoredDocs.scoreDocs = scoreDocs;
                    return rescoredDocs;
                }
                ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
                ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
                System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
                mainDocs.scoreDocs = reRankScoreDocs;
                TopDocs rescoredDocs = new QueryRescorer(this.reRankQuery){

                    protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                        float score = firstPassScore;
                        if (secondPassMatches) {
                            score = (float)((double)score + ReRankCollector.this.reRankWeight * (double)secondPassScore);
                        }
                        return score;
                    }
                }.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
                howMany = Math.min(howMany, mainScoreDocs.length);
                if (howMany == rescoredDocs.scoreDocs.length) {
                    return rescoredDocs;
                }
                if (howMany > rescoredDocs.scoreDocs.length) {
                    ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                    System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                    System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                    rescoredDocs.scoreDocs = scoreDocs;
                    return rescoredDocs;
                }
                ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
                rescoredDocs.scoreDocs = scoreDocs;
                return rescoredDocs;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
    }

    private class ReRankWeight
    extends Weight {
        private Query reRankQuery;
        private IndexSearcher searcher;
        private Weight mainWeight;
        private double reRankWeight;

        public ReRankWeight(Query mainQuery, Query reRankQuery, double reRankWeight, IndexSearcher searcher, boolean needsScores) throws IOException {
            super(mainQuery);
            this.reRankQuery = reRankQuery;
            this.searcher = searcher;
            this.reRankWeight = reRankWeight;
            this.mainWeight = mainQuery.createWeight(searcher, needsScores);
        }

        public void extractTerms(Set<Term> terms) {
            this.mainWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.mainWeight.getValueForNormalization();
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return this.mainWeight.scorer(context);
        }

        public void normalize(float norm, float topLevelBoost) {
            this.mainWeight.normalize(norm, topLevelBoost);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation mainExplain = this.mainWeight.explain(context, doc);
            return new QueryRescorer(this.reRankQuery){

                protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                    float score = firstPassScore;
                    if (secondPassMatches) {
                        score = (float)((double)score + ReRankWeight.this.reRankWeight * (double)secondPassScore);
                    }
                    return score;
                }
            }.explain(this.searcher, mainExplain, context.docBase + doc);
        }
    }

    private final class ReRankQuery
    extends RankQuery {
        private Query mainQuery = ReRankQParserPlugin.access$000();
        private Query reRankQuery;
        private int reRankDocs;
        private int length;
        private double reRankWeight;
        private Map<BytesRef, Integer> boostedPriority;

        public int hashCode() {
            return 31 * super.hashCode() + this.mainQuery.hashCode() + this.reRankQuery.hashCode() + (int)this.reRankWeight + this.reRankDocs;
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            ReRankQuery rrq = (ReRankQuery)o;
            return this.mainQuery.equals((Object)rrq.mainQuery) && this.reRankQuery.equals((Object)rrq.reRankQuery) && this.reRankWeight == rrq.reRankWeight && this.reRankDocs == rrq.reRankDocs;
        }

        public ReRankQuery(Query reRankQuery, int reRankDocs, double reRankWeight, int length) {
            this.reRankQuery = reRankQuery;
            this.reRankDocs = reRankDocs;
            this.reRankWeight = reRankWeight;
            this.length = length;
        }

        @Override
        public RankQuery wrap(Query _mainQuery) {
            if (_mainQuery != null) {
                this.mainQuery = _mainQuery;
            }
            return this;
        }

        @Override
        public MergeStrategy getMergeStrategy() {
            return null;
        }

        @Override
        public TopDocsCollector getTopDocsCollector(int len, SolrIndexSearcher.QueryCommand cmd, IndexSearcher searcher) throws IOException {
            SolrRequestInfo info;
            if (this.boostedPriority == null && (info = SolrRequestInfo.getRequestInfo()) != null) {
                Map<Object, Object> context = info.getReq().getContext();
                this.boostedPriority = (Map)context.get("BOOSTED_PRIORITY");
            }
            return new ReRankCollector(this.reRankDocs, this.length, this.reRankQuery, this.reRankWeight, cmd, searcher, this.boostedPriority);
        }

        @Override
        public String toString(String s) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("{!").append(ReRankQParserPlugin.NAME);
            sb.append(" mainQuery='").append(this.mainQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_QUERY).append("='").append(this.reRankQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_DOCS).append('=').append(this.reRankDocs).append(' ');
            sb.append(ReRankQParserPlugin.RERANK_WEIGHT).append('=').append(this.reRankWeight).append('}');
            return sb.toString();
        }

        public Query rewrite(IndexReader reader) throws IOException {
            if (this.getBoost() != 1.0f) {
                return super.rewrite(reader);
            }
            Query q = this.mainQuery.rewrite(reader);
            if (q != this.mainQuery) {
                return new ReRankQuery(this.reRankQuery, this.reRankDocs, this.reRankWeight, this.length).wrap(q);
            }
            return super.rewrite(reader);
        }

        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new ReRankWeight(this.mainQuery, this.reRankQuery, this.reRankWeight, searcher, needsScores);
        }
    }

    private class ReRankQParser
    extends QParser {
        public ReRankQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(query, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String reRankQueryString = this.localParams.get(ReRankQParserPlugin.RERANK_QUERY);
            if (reRankQueryString == null || reRankQueryString.trim().length() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "reRankQuery parameter is mandatory");
            }
            QParser reRankParser = QParser.getParser(reRankQueryString, null, this.req);
            Query reRankQuery = reRankParser.parse();
            int reRankDocs = this.localParams.getInt(ReRankQParserPlugin.RERANK_DOCS, 200);
            reRankDocs = Math.max(1, reRankDocs);
            double reRankWeight = this.localParams.getDouble(ReRankQParserPlugin.RERANK_WEIGHT, 2.0);
            int start = this.params.getInt("start", 0);
            int rows = this.params.getInt("rows", 10);
            int length = start + rows;
            return new ReRankQuery(reRankQuery, reRankDocs, reRankWeight, length);
        }
    }
}

