/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.ChildDocTransformer;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class ChildDocTransformerFactory
extends TransformerFactory {
    @Override
    public DocTransformer create(String field, SolrParams params, SolrQueryRequest req) {
        SchemaField uniqueKeyField = req.getSchema().getUniqueKeyField();
        if (uniqueKeyField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, " ChildDocTransformer requires the schema to have a uniqueKeyField.");
        }
        String parentFilter = params.get("parentFilter");
        if (parentFilter == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Parent filter should be sent as parentFilter=filterCondition");
        }
        String childFilter = params.get("childFilter");
        int limit = params.getInt("limit", 10);
        QueryBitSetProducer parentsFilter = null;
        try {
            Query parentFilterQuery = QParser.getParser(parentFilter, null, req).getQuery();
            parentsFilter = new QueryBitSetProducer((Query)new QueryWrapperFilter(parentFilterQuery));
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Failed to create correct parent filter query");
        }
        Query childFilterQuery = null;
        if (childFilter != null) {
            try {
                childFilterQuery = QParser.getParser(childFilter, null, req).getQuery();
            }
            catch (SyntaxError syntaxError) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Failed to create correct child filter query");
            }
        }
        return new ChildDocTransformer(field, (BitSetProducer)parentsFilter, uniqueKeyField, req.getSchema(), childFilterQuery, limit);
    }
}

