/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsInfo;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.util.PivotListEntry;

public class PivotFacetHelper {
    public static String encodeRefinementValuePath(List<String> values) {
        assert (null != values);
        if (values.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (String val : values) {
            if (null == val) {
                out.append('^');
            } else {
                out.append('~');
                StrUtils.appendEscapedTextToBuilder(out, val, ',');
            }
            out.append(',');
        }
        out.deleteCharAt(out.length() - 1);
        return out.toString();
    }

    public static List<String> decodeRefinementValuePath(String valuePath) {
        List<String> rawvals = StrUtils.splitSmart(valuePath, ",", true);
        if (rawvals.isEmpty()) {
            return rawvals;
        }
        ArrayList<String> out = new ArrayList<String>(rawvals.size());
        for (String raw : rawvals) {
            assert (0 < raw.length());
            if ('^' == raw.charAt(0)) {
                assert (1 == raw.length());
                out.add(null);
                continue;
            }
            assert ('~' == raw.charAt(0));
            out.add(raw.substring(1));
        }
        return out;
    }

    public static Comparable getValue(NamedList<Object> pivotList) {
        return (Comparable)PivotListEntry.VALUE.extract(pivotList);
    }

    public static String getField(NamedList<Object> pivotList) {
        return (String)PivotListEntry.FIELD.extract(pivotList);
    }

    public static Integer getCount(NamedList<Object> pivotList) {
        return (Integer)PivotListEntry.COUNT.extract(pivotList);
    }

    public static List<NamedList<Object>> getPivots(NamedList<Object> pivotList) {
        return (List)PivotListEntry.PIVOT.extract(pivotList);
    }

    public static NamedList<NamedList<NamedList<?>>> getStats(NamedList<Object> pivotList) {
        return (NamedList)PivotListEntry.STATS.extract(pivotList);
    }

    public static NamedList<Number> getQueryCounts(NamedList<Object> pivotList) {
        return (NamedList)PivotListEntry.QUERIES.extract(pivotList);
    }

    public static SimpleOrderedMap<SimpleOrderedMap<Object>> getRanges(NamedList<Object> pivotList) {
        return (SimpleOrderedMap)PivotListEntry.RANGES.extract(pivotList);
    }

    public static Map<String, StatsValues> mergeStats(Map<String, StatsValues> merged, NamedList<NamedList<NamedList<?>>> remoteWrapper, StatsInfo statsInfo) {
        if (null == merged) {
            merged = new LinkedHashMap<String, StatsValues>();
        }
        NamedList<NamedList<?>> remoteStats = StatsComponent.unwrapStats(remoteWrapper);
        for (Map.Entry<String, NamedList<?>> entry : remoteStats) {
            StatsValues receivingStatsValues = merged.get(entry.getKey());
            if (receivingStatsValues == null) {
                StatsField receivingStatsField = statsInfo.getStatsField(entry.getKey());
                if (null == receivingStatsField) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No stats.field found corresponding to pivot stats received from shard: " + entry.getKey());
                }
                receivingStatsValues = StatsValuesFactory.createStatsValues(receivingStatsField);
                merged.put(entry.getKey(), receivingStatsValues);
            }
            receivingStatsValues.accumulate(entry.getValue());
        }
        return merged;
    }

    static NamedList<Number> mergeQueryCounts(NamedList<Number> globalQueryCounts, NamedList<Number> shardQueryCounts) {
        if (globalQueryCounts == null) {
            return shardQueryCounts;
        }
        for (Map.Entry<String, Number> entry : shardQueryCounts) {
            int idx = globalQueryCounts.indexOf(entry.getKey(), 0);
            if (idx == -1) {
                globalQueryCounts.add(entry.getKey(), entry.getValue());
                continue;
            }
            globalQueryCounts.setVal(idx, FacetComponent.num(globalQueryCounts.getVal(idx).longValue() + entry.getValue().longValue()));
        }
        return globalQueryCounts;
    }
}

