/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.base.Objects;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.highlight.DefaultSolrHighlighter;
import org.apache.solr.highlight.PostingsSolrHighlighter;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;

public class HighlightComponent
extends SearchComponent
implements PluginInfoInitialized,
SolrCoreAware {
    public static final String COMPONENT_NAME = "highlight";
    private PluginInfo info = PluginInfo.EMPTY_INFO;
    private SolrHighlighter highlighter;

    public static SolrHighlighter getHighlighter(SolrCore core) {
        HighlightComponent hl = (HighlightComponent)core.getSearchComponents().get(COMPONENT_NAME);
        return hl == null ? null : hl.getHighlighter();
    }

    @Override
    public void init(PluginInfo info) {
        this.info = info;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        rb.doHighlights = this.highlighter.isHighlightingEnabled(params);
        if (rb.doHighlights) {
            String hlq = params.get("hl.q");
            String hlparser = (String)Objects.firstNonNull((Object)params.get("hl.qparser"), (Object)params.get("defType", "lucene"));
            if (hlq != null) {
                try {
                    QParser parser = QParser.getParser(hlq, hlparser, rb.req);
                    rb.setHighlightQuery(parser.getHighlightQuery());
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void inform(SolrCore core) {
        List<PluginInfo> children = this.info.getChildren("highlighting");
        if (children.isEmpty()) {
            PluginInfo pluginInfo = core.getSolrConfig().getPluginInfo(SolrHighlighter.class.getName());
            if (pluginInfo != null) {
                this.highlighter = core.createInitInstance(pluginInfo, SolrHighlighter.class, null, DefaultSolrHighlighter.class.getName());
            } else {
                DefaultSolrHighlighter defHighlighter = new DefaultSolrHighlighter(core);
                defHighlighter.init(PluginInfo.EMPTY_INFO);
                this.highlighter = defHighlighter;
            }
        } else {
            this.highlighter = core.createInitInstance(children.get(0), SolrHighlighter.class, null, DefaultSolrHighlighter.class.getName());
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doHighlights) {
            NamedList<Object> sumData;
            SolrQueryRequest req = rb.req;
            SolrParams params = req.getParams();
            String[] defaultHighlightFields = rb.getQparser() != null ? rb.getQparser().getDefaultHighlightFields() : params.getParams("df");
            Query highlightQuery = rb.getHighlightQuery();
            if (highlightQuery == null) {
                if (rb.getQparser() != null) {
                    try {
                        highlightQuery = rb.getQparser().getHighlightQuery();
                        rb.setHighlightQuery(highlightQuery);
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                } else {
                    highlightQuery = rb.getQuery();
                    rb.setHighlightQuery(highlightQuery);
                }
            }
            if (highlightQuery != null) {
                boolean rewrite = !(this.highlighter instanceof PostingsSolrHighlighter) && (Boolean.valueOf(params.get("hl.usePhraseHighlighter", "true")) == false || Boolean.valueOf(params.get("hl.highlightMultiTerm", "true")) == false);
                Query query = highlightQuery = rewrite ? highlightQuery.rewrite((IndexReader)req.getSearcher().getIndexReader()) : highlightQuery;
            }
            if (highlightQuery != null && (sumData = this.highlighter.doHighlighting(rb.getResults().docList, highlightQuery, req, defaultHighlightFields)) != null) {
                rb.rsp.add("highlighting", sumData);
            }
        }
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doHighlights) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            sreq.purpose |= 0x80;
            sreq.params.set("hl", "true");
        } else {
            sreq.params.set("hl", "false");
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.doHighlights && rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            NamedList.NamedListEntry[] arr = new NamedList.NamedListEntry[rb.resultIds.size()];
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x80) == 0) continue;
                for (ShardResponse srsp : sreq.responses) {
                    if (srsp.getException() != null) continue;
                    NamedList hl = (NamedList)srsp.getSolrResponse().getResponse().get("highlighting");
                    SolrPluginUtils.copyNamedListIntoArrayByDocPosInResponse(hl, rb.resultIds, arr);
                }
            }
            rb.rsp.add("highlighting", SolrPluginUtils.removeNulls(arr, new SimpleOrderedMap()));
        }
    }

    public SolrHighlighter getHighlighter() {
        return this.highlighter;
    }

    @Override
    public String getDescription() {
        return "Highlighting";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }
}

