/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetsHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    public static long DEFAULT_ZK_TIMEOUT = 300000L;

    public ConfigSetsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        if (this.coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get(a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            ConfigSetOperation operation = ConfigSetOperation.get(action);
            log.info("Invoked ConfigSet Action :{} with params {} ", (Object)action.toLower(), (Object)req.getParamString());
            Map<String, Object> result = operation.call(req, rsp, this);
            if (result != null) {
                result.put("operation", "configsets:" + operation.action.toLower());
                ZkNodeProps props = new ZkNodeProps(result);
                this.handleResponse(operation.action.toLower(), props, rsp, DEFAULT_ZK_TIMEOUT);
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        rsp.setHttpCaching(false);
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerConfigSetQueue().offer(Utils.toJSON(m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize(event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException(new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode(code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg")));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset unknown case");
        }
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator<String> iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        return props;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud ConfigSets";
    }

    static enum ConfigSetOperation {
        CREATE_OP(ConfigSetParams.ConfigSetAction.CREATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                Map<String, Object> props = req.getParams().required().getAll(null, "name", "baseConfigSet");
                return ConfigSetsHandler.copyPropertiesWithPrefix(req.getParams(), props, "configSetProp.");
            }
        }
        ,
        DELETE_OP(ConfigSetParams.ConfigSetAction.DELETE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                return req.getParams().required().getAll(null, "name");
            }
        }
        ,
        LIST_OP(ConfigSetParams.ConfigSetAction.LIST){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                NamedList<List<String>> results = new NamedList<List<String>>();
                SolrZkClient zk = h.coreContainer.getZkController().getZkStateReader().getZkClient();
                ZkConfigManager zkConfigManager = new ZkConfigManager(zk);
                List<String> configSetsList = zkConfigManager.listConfigs();
                results.add("configSets", configSetsList);
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(((SolrResponse)response).getResponse());
                return null;
            }
        };

        ConfigSetParams.ConfigSetAction action;

        private ConfigSetOperation(ConfigSetParams.ConfigSetAction action) {
            this.action = action;
        }

        abstract Map<String, Object> call(SolrQueryRequest var1, SolrQueryResponse var2, ConfigSetsHandler var3) throws Exception;

        public static ConfigSetOperation get(ConfigSetParams.ConfigSetAction action) {
            for (ConfigSetOperation op : ConfigSetOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action" + (Object)((Object)action));
        }
    }
}

