/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.util.CryptoKeys;
import org.apache.solr.util.SimplePostTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarRepository {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Random RANDOM;
    private final CoreContainer coreContainer;
    private Map<String, JarContent> jars = new ConcurrentHashMap<String, JarContent>();

    public JarRepository(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarContentRef getJarIncRef(String key) {
        JarContent jar = this.jars.get(key);
        if (jar == null) {
            if (this.coreContainer.isZooKeeperAware()) {
                ByteBuffer b;
                Replica replica = this.getSystemCollReplica();
                String url = replica.getStr("base_url") + "/.system/blob/" + key + "?wt=filestream";
                HttpClient httpClient = this.coreContainer.getUpdateShardHandler().getHttpClient();
                HttpGet httpGet = new HttpGet(url);
                try {
                    HttpResponse entity = httpClient.execute((HttpUriRequest)httpGet);
                    int statusCode = entity.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "no such blob or version available: " + key);
                    }
                    b = SimplePostTool.inputStreamToByteArray(entity.getEntity().getContent());
                }
                catch (Exception e) {
                    if (e instanceof SolrException) {
                        throw (SolrException)e;
                    }
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "could not load : " + key, (Throwable)e);
                }
                finally {
                    httpGet.releaseConnection();
                }
                jar = new JarContent(key, b);
                this.jars.put(key, jar);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Jar loading is not supported in non-cloud mode");
            }
        }
        JarContentRef ref = new JarContentRef(jar);
        Set set = jar.references;
        synchronized (set) {
            jar.references.add(ref);
        }
        return ref;
    }

    private Replica getSystemCollReplica() {
        ZkStateReader zkStateReader = this.coreContainer.getZkController().getZkStateReader();
        ClusterState cs = zkStateReader.getClusterState();
        DocCollection coll = cs.getCollectionOrNull(".system");
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, ".system collection not available");
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(coll.getActiveSlices());
        if (slices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No active slices for .system collection");
        }
        Collections.shuffle(slices, RANDOM);
        Replica replica = null;
        block0: for (Slice slice : slices) {
            ArrayList<Replica> replicas = new ArrayList<Replica>(slice.getReplicasMap().values());
            Collections.shuffle(replicas, RANDOM);
            for (Replica r : replicas) {
                if (r.getState() != Replica.State.ACTIVE) continue;
                if (zkStateReader.getClusterState().getLiveNodes().contains(r.get("node_name"))) {
                    replica = r;
                    continue block0;
                }
                log.info("replica {} says it is active but not a member of live nodes", r.get("node_name"));
            }
        }
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, ".no active replica available for .system collection");
        }
        return replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementJarRefCount(JarContentRef ref) {
        if (ref == null) {
            return;
        }
        Set set = ref.jar.references;
        synchronized (set) {
            if (!ref.jar.references.remove(ref)) {
                log.error("Multiple releases for the same reference");
            }
            if (ref.jar.references.isEmpty()) {
                this.jars.remove(ref.jar.key);
            }
        }
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
    }

    public static class JarContentRef {
        public final JarContent jar;

        private JarContentRef(JarContent jar) {
            this.jar = jar;
        }
    }

    public static class JarContent {
        private final String key;
        private final ByteBuffer buffer;
        private final Set<JarContentRef> references = new HashSet<JarContentRef>();

        public JarContent(String key, ByteBuffer buffer) {
            this.key = key;
            this.buffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer getFileContent(String entryName) throws IOException {
            ByteArrayInputStream zipContents = new ByteArrayInputStream(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.limit());
            ZipInputStream zis = new ZipInputStream(zipContents);
            try {
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    int size;
                    if (entryName != null && !entryName.equals(entry.getName())) continue;
                    SimplePostTool.BAOS out = new SimplePostTool.BAOS();
                    byte[] buffer = new byte[2048];
                    while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, size);
                    }
                    out.close();
                    ByteBuffer byteBuffer = out.getByteBuffer();
                    return byteBuffer;
                }
            }
            finally {
                zis.closeEntry();
            }
            return null;
        }

        public String checkSignature(String base64Sig, CryptoKeys keys) {
            return keys.verify(base64Sig, this.buffer);
        }
    }
}

