/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.LockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryFactory
implements NamedListInitializedPlugin,
Closeable {
    public static final IOContext IOCONTEXT_NO_CACHE = new IOContext(new FlushInfo(10000000, 100000000000L));
    protected static final String INDEX_W_TIMESTAMP_REGEX = "index\\.[0-9]{17}";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String LOCK_TYPE_SIMPLE = "simple";
    public static final String LOCK_TYPE_NATIVE = "native";
    public static final String LOCK_TYPE_SINGLE = "single";
    public static final String LOCK_TYPE_NONE = "none";
    public static final String LOCK_TYPE_HDFS = "hdfs";

    public abstract void doneWithDirectory(Directory var1) throws IOException;

    public abstract void addCloseListener(Directory var1, CachingDirectoryFactory.CloseListener var2);

    @Override
    public abstract void close() throws IOException;

    protected abstract Directory create(String var1, LockFactory var2, DirContext var3) throws IOException;

    protected abstract LockFactory createLockFactory(String var1) throws IOException;

    public abstract boolean exists(String var1) throws IOException;

    public abstract void remove(Directory var1) throws IOException;

    public abstract void remove(Directory var1, boolean var2) throws IOException;

    public abstract void remove(String var1, boolean var2) throws IOException;

    public abstract void remove(String var1) throws IOException;

    public void move(Directory fromDir, Directory toDir, String fileName, IOContext ioContext) throws IOException {
        toDir.copyFrom(fromDir, fileName, fileName, ioContext);
        fromDir.deleteFile(fileName);
    }

    public abstract Directory get(String var1, DirContext var2, String var3) throws IOException;

    public abstract void incRef(Directory var1);

    public abstract boolean isPersistent();

    public boolean isSharedStorage() {
        return false;
    }

    public abstract void release(Directory var1) throws IOException;

    public String normalize(String path) throws IOException {
        return path;
    }

    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    public static long sizeOfDirectory(Directory directory) throws IOException {
        String[] files = directory.listAll();
        long size = 0L;
        for (String file : files) {
            if ((size += DirectoryFactory.sizeOf(directory, file)) < 0L) break;
        }
        return size;
    }

    public static long sizeOf(Directory directory, String file) throws IOException {
        try {
            return directory.fileLength(file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static boolean empty(Directory dir) {
        boolean isSuccess = true;
        try {
            String[] contents = dir.listAll();
            if (contents != null) {
                for (String file : contents) {
                    dir.deleteFile(file);
                }
            }
        }
        catch (IOException e) {
            SolrException.log(log, "Error deleting files from Directory", e);
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean searchersReserveCommitPoints() {
        return false;
    }

    public String getDataHome(CoreDescriptor cd) throws IOException {
        return cd.getInstanceDir().resolve(cd.getDataDir()).toAbsolutePath().toString();
    }

    public Collection<SolrInfoMBean> offerMBeans() {
        return Collections.emptySet();
    }

    public void cleanupOldIndexDirectories(String dataDirPath, String currentIndexDirPath) {
        File dataDir = new File(dataDirPath);
        if (!dataDir.isDirectory()) {
            log.warn("{} does not point to a valid data directory; skipping clean-up of old index directories.", (Object)dataDirPath);
            return;
        }
        final File currentIndexDir = new File(currentIndexDirPath);
        File[] oldIndexDirs = dataDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileName = file.getName();
                return file.isDirectory() && !file.equals(currentIndexDir) && (fileName.equals("index") || fileName.matches(DirectoryFactory.INDEX_W_TIMESTAMP_REGEX));
            }
        });
        if (oldIndexDirs == null || oldIndexDirs.length == 0) {
            return;
        }
        log.info("Found {} old index directories to clean-up under {}", (Object)oldIndexDirs.length, (Object)dataDirPath);
        for (File dir : oldIndexDirs) {
            String dirToRmPath = dir.getAbsolutePath();
            try {
                if (this.deleteOldIndexDirectory(dirToRmPath)) {
                    log.info("Deleted old index directory: {}", (Object)dirToRmPath);
                    continue;
                }
                log.warn("Delete old index directory {} failed.", (Object)dirToRmPath);
            }
            catch (IOException ioExc) {
                log.error("Failed to delete old directory {} due to: {}", (Object)dir.getAbsolutePath(), (Object)ioExc.toString());
            }
        }
    }

    protected boolean deleteOldIndexDirectory(String oldDirPath) throws IOException {
        File dirToRm = new File(oldDirPath);
        FileUtils.deleteDirectory((File)dirToRm);
        return !dirToRm.isDirectory();
    }

    public static enum DirContext {
        DEFAULT,
        META_DATA;

    }
}

