/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.validator;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.captcha.exception.CaptchaException;
import org.wso2.carbon.identity.captcha.util.CaptchaConstants;
import org.wso2.carbon.identity.captcha.util.CaptchaUtil;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class FailLoginAttemptValidationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(FailLoginAttemptValidationHandler.class);

    public String getName() {
        return "failLoginAttemptValidator";
    }

    public boolean canHandle(MessageContext messageContext) throws IdentityRuntimeException {
        return super.canHandle(messageContext) && this.isFailLoginAttemptValidatorEnabled();
    }

    public void handleEvent(Event event) throws IdentityEventException {
        if (this.canHandleEvent(event)) {
            AuthenticationContext context = (AuthenticationContext)event.getEventProperties().get("context");
            Map unmodifiableParamMap = (Map)event.getEventProperties().get("params");
            String eventName = event.getEventName();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getName() + " received event : " + eventName));
            }
            if (IdentityEventConstants.EventName.AUTHENTICATION_STEP_FAILURE.name().equals(eventName)) {
                this.handleAuthenticationStepFailure(context, unmodifiableParamMap);
            }
        }
    }

    protected void handleAuthenticationStepFailure(AuthenticationContext authenticationContext, Map<String, Object> map) {
        String currentAuthenticator = authenticationContext.getCurrentAuthenticator();
        if (StringUtils.isBlank((String)currentAuthenticator) && MapUtils.isNotEmpty(map)) {
            currentAuthenticator = (String)map.get("authenticator");
        }
        if (("BasicAuthenticator".equals(currentAuthenticator) || CaptchaUtil.isValidAuthenticator(authenticationContext, currentAuthenticator)) && MapUtils.isNotEmpty(map) && map.get("user") != null && map.get("user") instanceof User) {
            User failedUser = (User)map.get("user");
            String username = this.getDomainQualifiedUsername(failedUser);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Evaluating failed login attempts for user: " + username + " authenticated from: " + currentAuthenticator));
            }
            try {
                if (CaptchaUtil.isMaximumFailedLoginAttemptsReached(username, failedUser.getTenantDomain())) {
                    CaptchaConstants.setEnableSecurityMechanism("enable");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User: " + username + " reached maximum no of failed login attempts. Enabling captcha for user."));
                    }
                }
            }
            catch (CaptchaException e) {
                log.error((Object)("Failed to evaluate max failed login attempts of the user: " + username), (Throwable)e);
            }
        }
    }

    private boolean isFailLoginAttemptValidatorEnabled() throws IdentityRuntimeException {
        if (this.configs.getModuleProperties() != null) {
            String handlerEnabled = this.configs.getModuleProperties().getProperty("failLoginAttemptValidator.enable");
            return Boolean.parseBoolean(handlerEnabled);
        }
        return false;
    }

    private boolean canHandleEvent(Event event) {
        return event != null && event.getEventProperties().get("context") instanceof AuthenticationContext && event.getEventProperties().get("params") instanceof Map;
    }

    private String getDomainQualifiedUsername(User user) {
        String username = user.getUserName();
        if (!StringUtils.isBlank((String)user.getUserStoreDomain()) && !IdentityUtil.getPrimaryDomainName().equals(user.getUserStoreDomain())) {
            username = UserCoreUtil.addDomainToName((String)username, (String)user.getUserStoreDomain());
        }
        return username;
    }
}

