/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.captcha.exception.CaptchaClientException;
import org.wso2.carbon.identity.captcha.exception.CaptchaException;
import org.wso2.carbon.identity.captcha.exception.CaptchaServerException;
import org.wso2.carbon.identity.captcha.internal.CaptchaDataHolder;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CaptchaUtil {
    private static final Log log = LogFactory.getLog(CaptchaUtil.class);

    public static void buildReCaptchaFilterProperties() {
        Path path = Paths.get(CaptchaUtil.getCarbonHomeDirectory().toString(), "repository", "conf", "identity", "captcha-config.properties");
        if (Files.exists(path, new LinkOption[0])) {
            Properties properties = new Properties();
            try (InputStreamReader in = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while loading 'captcha-config.properties' configuration file", e);
            }
            boolean reCaptchaEnabled = Boolean.valueOf(properties.getProperty("recaptcha.enabled"));
            String reCaptchaFailedRedirectUrls = properties.getProperty("recaptcha.failed.redirect.urls");
            if (StringUtils.isNotBlank((String)reCaptchaFailedRedirectUrls)) {
                CaptchaDataHolder.getInstance().setReCaptchaErrorRedirectUrls(reCaptchaFailedRedirectUrls);
            }
            if (reCaptchaEnabled) {
                CaptchaDataHolder.getInstance().setReCaptchaEnabled(true);
                CaptchaUtil.setReCaptchaConfigs(properties);
            } else {
                CaptchaDataHolder.getInstance().setReCaptchaEnabled(false);
            }
        }
    }

    public static Path getCarbonHomeDirectory() {
        return Paths.get(System.getProperty("carbon.home"), new String[0]);
    }

    public static boolean isPathAvailable(String currentPath, String securedPaths) {
        if (!StringUtils.isBlank((String)securedPaths)) {
            String[] paths;
            for (String path : paths = securedPaths.split(",")) {
                if (!currentPath.equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getUpdatedUrl(String url, Map<String, String> attributes) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while building URL.", (Throwable)e);
            }
            return url;
        }
    }

    public static String getOnFailRedirectUrl(String referrerUrl, List<String> onFailRedirectUrls, Map<String, String> attributes) {
        URIBuilder uriBuilder;
        if (StringUtils.isBlank((String)referrerUrl) || onFailRedirectUrls.isEmpty()) {
            return CaptchaUtil.getErrorPage("Human Verification Failed.", "Something went wrong. Please try again.");
        }
        try {
            uriBuilder = new URIBuilder(referrerUrl);
        }
        catch (URISyntaxException e) {
            return CaptchaUtil.getErrorPage("Human Verification Failed.", "Something went wrong. Please try again.");
        }
        for (String url : onFailRedirectUrls) {
            if (StringUtils.isBlank((String)url) || !url.equalsIgnoreCase(uriBuilder.getPath())) continue;
            for (NameValuePair pair : uriBuilder.getQueryParams()) {
                attributes.put(pair.getName(), pair.getValue());
            }
            return CaptchaUtil.getUpdatedUrl(url, attributes);
        }
        return CaptchaUtil.getErrorPage("Human Verification Failed.", "Something went wrong. Please try again.");
    }

    public static String getErrorPage(String status, String statusMsg) {
        try {
            URIBuilder uriBuilder = new URIBuilder("/authenticationendpoint/retry.do");
            uriBuilder.addParameter("status", status);
            uriBuilder.addParameter("statusMsg", statusMsg);
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while building URL.", (Throwable)e);
            }
            return "/authenticationendpoint/retry.do";
        }
    }

    public static Map<String, String> getClaimValues(User user, int tenantId, String[] claimUris) throws CaptchaServerException {
        Map claimValues;
        block7: {
            UserStoreManager userStoreManager;
            UserRealm userRealm;
            String username = user.getUserName();
            if (!StringUtils.isBlank((String)user.getUserStoreDomain()) && !"PRIMARY".equals(user.getUserStoreDomain())) {
                username = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
            }
            RealmService realmService = CaptchaDataHolder.getInstance().getRealmService();
            try {
                userRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new CaptchaServerException("Failed to retrieve user realm from tenant id : " + tenantId, e);
            }
            try {
                userStoreManager = userRealm.getUserStoreManager();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new CaptchaServerException("Failed to retrieve user store manager.", e);
            }
            claimValues = null;
            try {
                claimValues = userStoreManager.getUserClaimValues(username, claimUris, "default");
            }
            catch (UserStoreException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Error occurred while retrieving user claims.", (Throwable)e);
            }
        }
        return claimValues;
    }

    public static boolean isValidCaptcha(String reCaptchaResponse) throws CaptchaException {
        CloseableHttpResponse response;
        CloseableHttpClient httpclient = HttpClientBuilder.create().useSystemProperties().build();
        HttpPost httppost = new HttpPost(CaptchaDataHolder.getInstance().getReCaptchaVerifyUrl());
        List<BasicNameValuePair> params = Arrays.asList(new BasicNameValuePair("secret", CaptchaDataHolder.getInstance().getReCaptchaSecretKey()), new BasicNameValuePair("response", reCaptchaResponse));
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        try {
            response = httpclient.execute((HttpUriRequest)httppost);
        }
        catch (IOException e) {
            throw new CaptchaServerException("Unable to get the verification response.", e);
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new CaptchaServerException("reCaptcha verification response is not received.");
        }
        try (InputStream in = entity.getContent();){
            JsonObject verificationResponse = new JsonParser().parse(IOUtils.toString((InputStream)in)).getAsJsonObject();
            if (verificationResponse == null || verificationResponse.get("success") == null || !verificationResponse.get("success").getAsBoolean()) {
                throw new CaptchaClientException("reCaptcha verification failed. Please try again.");
            }
        }
        catch (IOException e) {
            throw new CaptchaServerException("Unable to read the verification response.", e);
        }
        return true;
    }

    public static boolean isMaximumFailedLoginAttemptsReached(String usernameWithDomain, String tenantDomain) throws CaptchaException {
        Map claimValues;
        UserStoreManager userStoreManager;
        UserRealm userRealm;
        int tenantId;
        Property[] connectorConfigs;
        String CONNECTOR_NAME = "sso.login.recaptcha";
        String RECAPTCHA_VERIFICATION_CLAIM = "http://wso2.org/claims/identity/failedLoginAttempts";
        try {
            connectorConfigs = CaptchaDataHolder.getInstance().getIdentityGovernanceService().getConfiguration(new String[]{CONNECTOR_NAME + ".enable", CONNECTOR_NAME + ".on.max.failed.attempts"}, tenantDomain);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to load connector configuration.", (Throwable)e);
            }
            return false;
        }
        if (connectorConfigs == null) {
            return false;
        }
        String maxAttemptsStr = null;
        for (Property property : connectorConfigs) {
            if ((CONNECTOR_NAME + ".enable").equals(property.getName()) && !Boolean.valueOf(property.getValue()).booleanValue()) {
                return false;
            }
            if (!(CONNECTOR_NAME + ".on.max.failed.attempts").equals(property.getName())) continue;
            maxAttemptsStr = property.getValue();
        }
        if (StringUtils.isBlank(maxAttemptsStr) || !NumberUtils.isNumber(maxAttemptsStr)) {
            throw new CaptchaServerException("Invalid reCaptcha configuration.");
        }
        int maxAttempts = Integer.parseInt(maxAttemptsStr);
        RealmService realmService = CaptchaDataHolder.getInstance().getRealmService();
        try {
            tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CaptchaServerException("Failed to retrieve tenant id from tenant domain : " + tenantDomain, e);
        }
        if (-1 == tenantId) {
            throw new CaptchaServerException("Invalid tenant domain : " + tenantDomain);
        }
        try {
            userRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CaptchaServerException("Failed to retrieve user realm from tenant id : " + tenantId, e);
        }
        try {
            userStoreManager = userRealm.getUserStoreManager();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CaptchaServerException("Failed to retrieve user store manager.", e);
        }
        try {
            claimValues = userStoreManager.getUserClaimValues(MultitenantUtils.getTenantAwareUsername((String)usernameWithDomain), new String[]{RECAPTCHA_VERIFICATION_CLAIM}, "default");
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while retrieving user claims.", (Throwable)e);
            }
            return false;
        }
        int currentAttempts = 0;
        if (NumberUtils.isNumber((String)((String)claimValues.get(RECAPTCHA_VERIFICATION_CLAIM)))) {
            currentAttempts = Integer.parseInt((String)claimValues.get(RECAPTCHA_VERIFICATION_CLAIM));
        }
        return currentAttempts >= maxAttempts;
    }

    private static void setReCaptchaConfigs(Properties properties) {
        String reCaptchaAPIUrl = properties.getProperty("recaptcha.api.url");
        if (StringUtils.isBlank((String)reCaptchaAPIUrl)) {
            throw new RuntimeException(CaptchaUtil.getValidationErrorMessage("recaptcha.api.url"));
        }
        CaptchaDataHolder.getInstance().setReCaptchaAPIUrl(reCaptchaAPIUrl);
        String reCaptchaVerifyUrl = properties.getProperty("recaptcha.verify.url");
        if (StringUtils.isBlank((String)reCaptchaVerifyUrl)) {
            throw new RuntimeException(CaptchaUtil.getValidationErrorMessage("recaptcha.verify.url"));
        }
        CaptchaDataHolder.getInstance().setReCaptchaVerifyUrl(reCaptchaVerifyUrl);
        String reCaptchaSiteKey = properties.getProperty("recaptcha.site.key");
        if (StringUtils.isBlank((String)reCaptchaSiteKey)) {
            throw new RuntimeException(CaptchaUtil.getValidationErrorMessage("recaptcha.site.key"));
        }
        CaptchaDataHolder.getInstance().setReCaptchaSiteKey(reCaptchaSiteKey);
        String reCaptchaSecretKey = properties.getProperty("recaptcha.secret.key");
        if (StringUtils.isBlank((String)reCaptchaSecretKey)) {
            throw new RuntimeException(CaptchaUtil.getValidationErrorMessage("recaptcha.secret.key"));
        }
        CaptchaDataHolder.getInstance().setReCaptchaSecretKey(reCaptchaSecretKey);
    }

    private static void setSSOLoginConnectorConfigs(Properties properties) {
        HashMap<String, String> connectorPropertyMap = new HashMap<String, String>();
        String CONNECTOR_NAME = "sso.login";
        connectorPropertyMap.put("sso.login.enable", properties.getProperty("sso.login.enable"));
        connectorPropertyMap.put("sso.login.connector.identifier.attribute", properties.getProperty("sso.login.connector.identifier.attribute"));
        connectorPropertyMap.put("sso.login.user.identifier.attribute", properties.getProperty("sso.login.user.identifier.attribute"));
        connectorPropertyMap.put("sso.login.verification.claim", properties.getProperty("sso.login.verification.claim"));
        connectorPropertyMap.put("sso.login.on.max.failed.attempts", properties.getProperty("sso.login.on.max.failed.attempts"));
        CaptchaDataHolder.getInstance().setSSOLoginReCaptchaConnectorPropertyMap(connectorPropertyMap);
    }

    private static void setPathBasedConnectorConfigs(Properties properties) {
        HashMap<String, String> connectorPropertyMap = new HashMap<String, String>();
        String CONNECTOR_NAME = "path.based";
        connectorPropertyMap.put("path.based.enable", properties.getProperty("path.based.enable"));
        connectorPropertyMap.put("path.based.secured.pages", properties.getProperty("path.based.secured.pages"));
        connectorPropertyMap.put("path.based.secured.destinations", properties.getProperty("path.based.secured.destinations"));
        CaptchaDataHolder.getInstance().setPathBasedReCaptchaConnectorPropertyMap(connectorPropertyMap);
    }

    private static String getValidationErrorMessage(String property) {
        return "Invalid value for " + property + " in the " + "captcha-config.properties" + " file.";
    }

    public static Property[] getConnectorConfigs(ServletRequest servletRequest, IdentityGovernanceService identityGovernanceService, String PROPERTY_ENABLE_RECAPTCHA) throws Exception {
        String tenantDomain = servletRequest.getParameter("tenantDomain");
        if (StringUtils.isEmpty((String)tenantDomain)) {
            tenantDomain = servletRequest.getParameter("tenant-domain");
        }
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        Property[] connectorConfigs = identityGovernanceService.getConfiguration(new String[]{PROPERTY_ENABLE_RECAPTCHA}, tenantDomain);
        return connectorConfigs;
    }

    public static boolean isValidAuthenticator(AuthenticationContext authenticationContext, String currentAuthenticatorName) {
        ApplicationAuthenticator currentApplicationAuthenticator = CaptchaUtil.getCurrentAuthenticator(authenticationContext, currentAuthenticatorName);
        if (currentApplicationAuthenticator != null) {
            return "basic".equals(currentApplicationAuthenticator.getAuthMechanism());
        }
        return false;
    }

    private static ApplicationAuthenticator getCurrentAuthenticator(AuthenticationContext authenticationContext, String currentAuthenticatorName) {
        Map stepConfigMap;
        int currentStep = authenticationContext.getCurrentStep();
        SequenceConfig sequenceConfig = authenticationContext.getSequenceConfig();
        if (sequenceConfig != null && MapUtils.isNotEmpty((Map)(stepConfigMap = sequenceConfig.getStepMap())) && stepConfigMap.containsKey(currentStep)) {
            List authenticatorList = ((StepConfig)stepConfigMap.get(currentStep)).getAuthenticatorList();
            for (AuthenticatorConfig authenticatorConfig : authenticatorList) {
                if (!authenticatorConfig.getName().equals(currentAuthenticatorName)) continue;
                return authenticatorConfig.getApplicationAuthenticator();
            }
        }
        return null;
    }
}

