/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class CaptchaHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;

    public CaptchaHttpServletRequestWrapper(HttpServletRequest httpServletRequest) throws IOException {
        super(httpServletRequest);
        ServletInputStream is = super.getInputStream();
        this.body = IOUtils.toByteArray((InputStream)is);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamImpl(new ByteArrayInputStream(this.body));
    }

    public BufferedReader getReader() throws IOException {
        String enc = this.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), enc));
    }

    private class ServletInputStreamImpl
    extends ServletInputStream {
        private InputStream is;

        public ServletInputStreamImpl(InputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public boolean markSupported() {
            return false;
        }

        public synchronized void mark(int i) {
            throw new RuntimeException(new IOException("mark/reset not supported"));
        }

        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }
    }
}

