/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.captcha.connector.CaptchaConnector;
import org.wso2.carbon.identity.captcha.connector.recaptcha.AbstractReCaptchaConnector;
import org.wso2.carbon.identity.captcha.connector.recaptcha.PasswordRecoveryReCaptchaConnector;
import org.wso2.carbon.identity.captcha.connector.recaptcha.ResendConfirmationReCaptchaConnector;
import org.wso2.carbon.identity.captcha.connector.recaptcha.SSOLoginReCaptchaConfig;
import org.wso2.carbon.identity.captcha.connector.recaptcha.SelfSignUpReCaptchaConnector;
import org.wso2.carbon.identity.captcha.connector.recaptcha.UsernameRecoveryReCaptchaConnector;
import org.wso2.carbon.identity.captcha.internal.CaptchaDataHolder;
import org.wso2.carbon.identity.captcha.util.CaptchaUtil;
import org.wso2.carbon.identity.captcha.validator.FailLoginAttemptValidationHandler;
import org.wso2.carbon.identity.captcha.validator.FailLoginAttemptValidator;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.handler.event.account.lock.service.AccountLockService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.captcha.internal.CaptchaComponent", immediate=true)
public class CaptchaComponent {
    private static final Log log = LogFactory.getLog(CaptchaComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            CaptchaUtil.buildReCaptchaFilterProperties();
            SSOLoginReCaptchaConfig connector = new SSOLoginReCaptchaConfig();
            connector.init(CaptchaDataHolder.getInstance().getIdentityGovernanceService());
            context.getBundleContext().registerService(IdentityConnectorConfig.class, (Object)connector, null);
            CaptchaDataHolder.getInstance().addCaptchaConnector(connector);
            AbstractReCaptchaConnector captchaConnector = new SelfSignUpReCaptchaConnector();
            captchaConnector.init(CaptchaDataHolder.getInstance().getIdentityGovernanceService());
            CaptchaDataHolder.getInstance().addCaptchaConnector(captchaConnector);
            captchaConnector = new UsernameRecoveryReCaptchaConnector();
            captchaConnector.init(CaptchaDataHolder.getInstance().getIdentityGovernanceService());
            CaptchaDataHolder.getInstance().addCaptchaConnector(captchaConnector);
            captchaConnector = new PasswordRecoveryReCaptchaConnector();
            captchaConnector.init(CaptchaDataHolder.getInstance().getIdentityGovernanceService());
            CaptchaDataHolder.getInstance().addCaptchaConnector(captchaConnector);
            captchaConnector = new ResendConfirmationReCaptchaConnector();
            captchaConnector.init(CaptchaDataHolder.getInstance().getIdentityGovernanceService());
            CaptchaDataHolder.getInstance().addCaptchaConnector(captchaConnector);
            FailLoginAttemptValidator failedLoginAttemptValidator = new FailLoginAttemptValidator();
            context.getBundleContext().registerService(AuthenticationDataPublisher.class, (Object)failedLoginAttemptValidator, null);
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)new FailLoginAttemptValidationHandler(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Captcha Component is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to start CaptchaComponent", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Captcha Component is de-activated");
        }
    }

    @Reference(name="CaptchaConnectors", service=CaptchaConnector.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetCaptchaConnector")
    protected void setCaptchaConnector(CaptchaConnector captchaConnector) {
        CaptchaDataHolder.getInstance().addCaptchaConnector(captchaConnector);
    }

    protected void unsetCaptchaConnector(CaptchaConnector captchaConnector) {
        CaptchaDataHolder.getInstance().getCaptchaConnectors().remove(captchaConnector);
    }

    @Reference(name="IdentityGovernanceConnectors", service=IdentityConnectorConfig.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityGovernanceConnector")
    protected void setIdentityGovernanceConnector(IdentityConnectorConfig identityConnectorConfig) {
        if (identityConnectorConfig instanceof CaptchaConnector && CaptchaDataHolder.getInstance().getCaptchaConnectors().contains(identityConnectorConfig)) {
            CaptchaDataHolder.getInstance().addCaptchaConnector((CaptchaConnector)identityConnectorConfig);
        }
    }

    protected void unsetIdentityGovernanceConnector(IdentityConnectorConfig identityConnectorConfig) {
        if (identityConnectorConfig instanceof CaptchaConnector) {
            CaptchaDataHolder.getInstance().getCaptchaConnectors().remove(identityConnectorConfig);
        }
    }

    @Reference(name="IdentityGovernanceService", service=IdentityGovernanceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityGovernanceService")
    protected void setIdentityGovernanceService(IdentityGovernanceService identityGovernanceService) {
        CaptchaDataHolder.getInstance().setIdentityGovernanceService(identityGovernanceService);
    }

    protected void unsetIdentityGovernanceService(IdentityGovernanceService identityGovernanceService) {
        CaptchaDataHolder.getInstance().setIdentityGovernanceService(null);
    }

    @Reference(name="RealmService", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        CaptchaDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        CaptchaDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="AccountLockService", service=AccountLockService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAccountLockService")
    protected void setAccountLockService(AccountLockService accountLockService) {
        CaptchaDataHolder.getInstance().setAccountLockService(accountLockService);
    }

    protected void unsetAccountLockService(AccountLockService accountLockService) {
        CaptchaDataHolder.getInstance().setAccountLockService(null);
    }
}

