/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.filter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.captcha.connector.CaptchaConnector;
import org.wso2.carbon.identity.captcha.connector.CaptchaPostValidationResponse;
import org.wso2.carbon.identity.captcha.connector.CaptchaPreValidationResponse;
import org.wso2.carbon.identity.captcha.exception.CaptchaClientException;
import org.wso2.carbon.identity.captcha.exception.CaptchaException;
import org.wso2.carbon.identity.captcha.internal.CaptchaDataHolder;
import org.wso2.carbon.identity.captcha.util.CaptchaHttpServletResponseWrapper;
import org.wso2.carbon.identity.captcha.util.CaptchaUtil;

public class CaptchaFilter
implements Filter {
    private static final Log log = LogFactory.getLog(CaptchaFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Captcha filter activated.");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            if (!CaptchaDataHolder.getInstance().isReCaptchaEnabled()) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            List<CaptchaConnector> captchaConnectors = CaptchaDataHolder.getInstance().getCaptchaConnectors();
            CaptchaConnector selectedCaptchaConnector = null;
            for (CaptchaConnector captchaConnector : captchaConnectors) {
                if (!captchaConnector.canHandle(servletRequest, servletResponse) || selectedCaptchaConnector != null && captchaConnector.getPriority() <= selectedCaptchaConnector.getPriority()) continue;
                selectedCaptchaConnector = captchaConnector;
            }
            if (selectedCaptchaConnector == null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            CaptchaPreValidationResponse captchaPreValidationResponse = selectedCaptchaConnector.preValidate(servletRequest, servletResponse);
            if (captchaPreValidationResponse == null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
            if (captchaPreValidationResponse.isCaptchaValidationRequired()) {
                try {
                    boolean validCaptcha = selectedCaptchaConnector.verifyCaptcha(servletRequest, servletResponse);
                    if (!validCaptcha) {
                        log.warn((Object)"Captcha validation failed for the user.");
                        httpResponse.sendRedirect(CaptchaUtil.getOnFailRedirectUrl(httpRequest.getHeader("referer"), captchaPreValidationResponse.getOnCaptchaFailRedirectUrls(), captchaPreValidationResponse.getCaptchaAttributes()));
                        return;
                    }
                }
                catch (CaptchaClientException e) {
                    log.warn((Object)("Captcha validation failed for the user. Cause : " + e.getMessage()));
                    httpResponse.sendRedirect(CaptchaUtil.getOnFailRedirectUrl(httpRequest.getHeader("referer"), captchaPreValidationResponse.getOnCaptchaFailRedirectUrls(), captchaPreValidationResponse.getCaptchaAttributes()));
                    return;
                }
            }
            if (captchaPreValidationResponse.isEnableCaptchaForRequestPath()) {
                if (captchaPreValidationResponse.getCaptchaAttributes() != null) {
                    for (Map.Entry<String, String> parameter : captchaPreValidationResponse.getCaptchaAttributes().entrySet()) {
                        servletRequest.setAttribute(parameter.getKey(), (Object)parameter.getValue());
                    }
                }
                this.doFilter(captchaPreValidationResponse, servletRequest, servletResponse, filterChain);
                return;
            }
            if (!captchaPreValidationResponse.isPostValidationRequired() || !captchaPreValidationResponse.isCaptchaValidationRequired() && !captchaPreValidationResponse.isMaxFailedLimitReached()) {
                this.doFilter(captchaPreValidationResponse, servletRequest, servletResponse, filterChain);
                return;
            }
            CaptchaHttpServletResponseWrapper responseWrapper = new CaptchaHttpServletResponseWrapper(httpResponse);
            this.doFilter(captchaPreValidationResponse, servletRequest, (ServletResponse)responseWrapper, filterChain);
            CaptchaPostValidationResponse postValidationResponse = selectedCaptchaConnector.postValidate(servletRequest, (ServletResponse)responseWrapper);
            if (postValidationResponse == null || postValidationResponse.isSuccessfulAttempt()) {
                if (responseWrapper.isRedirect()) {
                    httpResponse.sendRedirect(responseWrapper.getRedirectURL());
                }
                return;
            }
            if (postValidationResponse.isEnableCaptchaResponsePath() && responseWrapper.isRedirect()) {
                httpResponse.sendRedirect(CaptchaUtil.getUpdatedUrl(responseWrapper.getRedirectURL(), postValidationResponse.getCaptchaAttributes()));
            }
        }
        catch (CaptchaException e) {
            log.error((Object)"Error occurred in processing captcha.", (Throwable)e);
            ((HttpServletResponse)servletResponse).sendRedirect(CaptchaUtil.getErrorPage("Server Error", "Something went wrong. Please try again"));
        }
    }

    public void destroy() {
    }

    private void doFilter(CaptchaPreValidationResponse preValidationResponse, ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (preValidationResponse.getWrappedHttpServletRequest() != null) {
            filterChain.doFilter((ServletRequest)preValidationResponse.getWrappedHttpServletRequest(), servletResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

