/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.connector.recaptcha;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.captcha.connector.CaptchaPostValidationResponse;
import org.wso2.carbon.identity.captcha.connector.CaptchaPreValidationResponse;
import org.wso2.carbon.identity.captcha.connector.recaptcha.AbstractReCaptchaConnector;
import org.wso2.carbon.identity.captcha.exception.CaptchaClientException;
import org.wso2.carbon.identity.captcha.exception.CaptchaException;
import org.wso2.carbon.identity.captcha.util.CaptchaUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;

public class UsernameRecoveryReCaptchaConnector
extends AbstractReCaptchaConnector {
    private static final Log log = LogFactory.getLog(UsernameRecoveryReCaptchaConnector.class);
    private static final String RECOVER_USERNAME_URL = "/api/identity/recovery/v0.9/recover-username/";
    private final String PROPERTY_USERNAME_RECAPTCHA_ENABLE = "Recovery.ReCaptcha.Username.Enable";
    private IdentityGovernanceService identityGovernanceService;

    @Override
    public void init(IdentityGovernanceService identityGovernanceService) {
        this.identityGovernanceService = identityGovernanceService;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean canHandle(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        Property[] connectorConfigs;
        String path = ((HttpServletRequest)servletRequest).getRequestURI();
        String enable = null;
        if (StringUtils.isBlank((String)path) || !CaptchaUtil.isPathAvailable(path, RECOVER_USERNAME_URL)) {
            return false;
        }
        try {
            connectorConfigs = CaptchaUtil.getConnectorConfigs(servletRequest, this.identityGovernanceService, "Recovery.ReCaptcha.Username.Enable");
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to load connector configuration.", (Throwable)e);
            }
            return false;
        }
        for (Property connectorConfig : connectorConfigs) {
            if (!"Recovery.ReCaptcha.Username.Enable".equals(connectorConfig.getName())) continue;
            enable = connectorConfig.getValue();
        }
        return Boolean.parseBoolean(enable);
    }

    @Override
    public CaptchaPreValidationResponse preValidate(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        CaptchaPreValidationResponse preValidationResponse = new CaptchaPreValidationResponse();
        String path = ((HttpServletRequest)servletRequest).getRequestURI();
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (CaptchaUtil.isPathAvailable(path, RECOVER_USERNAME_URL)) {
            httpServletResponse.setHeader("reCaptcha", "conditional");
            preValidationResponse.setCaptchaValidationRequired(true);
        }
        return preValidationResponse;
    }

    @Override
    public boolean verifyCaptcha(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        String reCaptchaResponse = ((HttpServletRequest)servletRequest).getHeader("g-recaptcha-response");
        if (StringUtils.isBlank((String)reCaptchaResponse)) {
            throw new CaptchaClientException("reCaptcha response is not available in the request.");
        }
        return CaptchaUtil.isValidCaptcha(reCaptchaResponse);
    }

    @Override
    public CaptchaPostValidationResponse postValidate(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        return null;
    }
}

