/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.connector.recaptcha;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.captcha.connector.CaptchaPostValidationResponse;
import org.wso2.carbon.identity.captcha.connector.CaptchaPreValidationResponse;
import org.wso2.carbon.identity.captcha.connector.recaptcha.AbstractReCaptchaConnector;
import org.wso2.carbon.identity.captcha.exception.CaptchaClientException;
import org.wso2.carbon.identity.captcha.exception.CaptchaException;
import org.wso2.carbon.identity.captcha.internal.CaptchaDataHolder;
import org.wso2.carbon.identity.captcha.util.CaptchaUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;

public class SelfSignUpReCaptchaConnector
extends AbstractReCaptchaConnector {
    private static final Log log = LogFactory.getLog(SelfSignUpReCaptchaConnector.class);
    private static final String SELF_REGISTRATION_INITIATE_URL = "/api/identity/recovery/v0.9/claims";
    private static final String SELF_REGISTRATION_URL = "/api/identity/user/v0.9/me";
    private final String PROPERTY_ENABLE_RECAPTCHA = "SelfRegistration.ReCaptcha";
    private IdentityGovernanceService identityGovernanceService;

    @Override
    public void init(IdentityGovernanceService identityGovernanceService) {
        this.identityGovernanceService = identityGovernanceService;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean canHandle(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        Property[] connectorConfigs;
        String path = ((HttpServletRequest)servletRequest).getRequestURI();
        if (StringUtils.isBlank((String)path) || !CaptchaUtil.isPathAvailable(path, SELF_REGISTRATION_INITIATE_URL) && !CaptchaUtil.isPathAvailable(path, SELF_REGISTRATION_URL)) {
            return false;
        }
        String isUsernameRecovery = servletRequest.getParameter("isUsernameRecovery");
        if (isUsernameRecovery != null) {
            return false;
        }
        try {
            connectorConfigs = CaptchaUtil.getConnectorConfigs(servletRequest, this.identityGovernanceService, "SelfRegistration.ReCaptcha");
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to load connector configuration.", (Throwable)e);
            }
            return false;
        }
        String enable = null;
        for (Property connectorConfig : connectorConfigs) {
            if (!"SelfRegistration.ReCaptcha".equals(connectorConfig.getName())) continue;
            enable = connectorConfig.getValue();
        }
        return Boolean.parseBoolean(enable);
    }

    @Override
    public CaptchaPreValidationResponse preValidate(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        CaptchaPreValidationResponse preValidationResponse = new CaptchaPreValidationResponse();
        String path = ((HttpServletRequest)servletRequest).getRequestURI();
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (CaptchaUtil.isPathAvailable(path, SELF_REGISTRATION_INITIATE_URL)) {
            httpServletResponse.setHeader("reCaptcha", "true");
        } else {
            httpServletResponse.setHeader("reCaptcha", "conditional");
            preValidationResponse.setCaptchaValidationRequired(true);
            preValidationResponse.setMaxFailedLimitReached(true);
        }
        httpServletResponse.setHeader("reCaptchaKey", CaptchaDataHolder.getInstance().getReCaptchaSiteKey());
        httpServletResponse.setHeader("reCaptchaAPI", CaptchaDataHolder.getInstance().getReCaptchaAPIUrl());
        return preValidationResponse;
    }

    @Override
    public boolean verifyCaptcha(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        String reCaptchaResponse = ((HttpServletRequest)servletRequest).getHeader("g-recaptcha-response");
        if (StringUtils.isBlank((String)reCaptchaResponse)) {
            throw new CaptchaClientException("reCaptcha response is not available in the request.");
        }
        return CaptchaUtil.isValidCaptcha(reCaptchaResponse);
    }

    @Override
    public CaptchaPostValidationResponse postValidate(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        return null;
    }
}

