/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.captcha.connector.recaptcha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.captcha.connector.CaptchaPostValidationResponse;
import org.wso2.carbon.identity.captcha.connector.CaptchaPreValidationResponse;
import org.wso2.carbon.identity.captcha.connector.recaptcha.AbstractReCaptchaConnector;
import org.wso2.carbon.identity.captcha.exception.CaptchaException;
import org.wso2.carbon.identity.captcha.internal.CaptchaDataHolder;
import org.wso2.carbon.identity.captcha.util.CaptchaConstants;
import org.wso2.carbon.identity.captcha.util.CaptchaUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SSOLoginReCaptchaConfig
extends AbstractReCaptchaConnector
implements IdentityConnectorConfig {
    private static final Log log = LogFactory.getLog(SSOLoginReCaptchaConfig.class);
    private static final String CONNECTOR_NAME = "sso.login.recaptcha";
    private static final String CONNECTOR_IDENTIFIER_ATTRIBUTE = "username,password";
    private static final String RECAPTCHA_VERIFICATION_CLAIM = "http://wso2.org/claims/identity/failedLoginAttempts";
    private static final String SECURED_DESTINATIONS = "/commonauth,/samlsso,/oauth2";
    private static final String ON_FAIL_REDIRECT_URL = "/authenticationendpoint/login.do";
    private IdentityGovernanceService identityGovernanceService;

    @Override
    public void init(IdentityGovernanceService identityGovernanceService) {
        this.identityGovernanceService = identityGovernanceService;
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public boolean canHandle(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        String[] connectorIdentifierAttributes;
        Object[] connectorConfigs;
        String userName = servletRequest.getParameter("username");
        if (StringUtils.isBlank((String)userName)) {
            return false;
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        try {
            connectorConfigs = this.identityGovernanceService.getConfiguration(new String[]{"sso.login.recaptcha.enable.always", "sso.login.recaptcha.enable"}, tenantDomain);
        }
        catch (IdentityGovernanceException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to load connector configuration.", (Throwable)e);
            }
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])connectorConfigs) || connectorConfigs.length != 2 || !Boolean.parseBoolean(connectorConfigs[0].getValue()) && !Boolean.parseBoolean(connectorConfigs[1].getValue())) {
            return false;
        }
        String currentPath = ((HttpServletRequest)servletRequest).getRequestURI();
        if (StringUtils.isBlank((String)currentPath) || !CaptchaUtil.isPathAvailable(currentPath, SECURED_DESTINATIONS)) {
            return false;
        }
        for (String attribute : connectorIdentifierAttributes = CONNECTOR_IDENTIFIER_ATTRIBUTE.split(",")) {
            if (servletRequest.getParameter(attribute) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public CaptchaPreValidationResponse preValidate(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        CaptchaPreValidationResponse preValidationResponse = new CaptchaPreValidationResponse();
        String userName = servletRequest.getParameter("username");
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        Property[] connectorConfigs = null;
        try {
            connectorConfigs = this.identityGovernanceService.getConfiguration(new String[]{"sso.login.recaptcha.enable.always"}, tenantDomain);
        }
        catch (IdentityGovernanceException e) {
            log.error((Object)"Unable to load connector configuration.", (Throwable)e);
        }
        if (connectorConfigs != null && connectorConfigs.length != 0 && Boolean.parseBoolean(connectorConfigs[0].getValue())) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("authFailure", "true");
            params.put("authFailureMsg", "recaptcha.fail.message");
            preValidationResponse.setCaptchaAttributes(params);
            preValidationResponse.setOnCaptchaFailRedirectUrls(this.getFailedUrlList());
            preValidationResponse.setCaptchaValidationRequired(true);
        } else if (CaptchaUtil.isMaximumFailedLoginAttemptsReached(MultitenantUtils.getTenantAwareUsername((String)userName), tenantDomain)) {
            preValidationResponse.setCaptchaValidationRequired(true);
            preValidationResponse.setMaxFailedLimitReached(true);
            preValidationResponse.setOnCaptchaFailRedirectUrls(this.getFailedUrlList());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("reCaptcha", "true");
            params.put("reCaptchaKey", CaptchaDataHolder.getInstance().getReCaptchaSiteKey());
            params.put("reCaptchaAPI", CaptchaDataHolder.getInstance().getReCaptchaAPIUrl());
            params.put("authFailure", "true");
            params.put("authFailureMsg", "recaptcha.fail.message");
            preValidationResponse.setCaptchaAttributes(params);
        }
        preValidationResponse.setMaxFailedLimitReached(true);
        preValidationResponse.setPostValidationRequired(true);
        return preValidationResponse;
    }

    @Override
    public CaptchaPostValidationResponse postValidate(ServletRequest servletRequest, ServletResponse servletResponse) throws CaptchaException {
        if (!StringUtils.isBlank((String)CaptchaConstants.getEnableSecurityMechanism())) {
            CaptchaConstants.removeEnabledSecurityMechanism();
            CaptchaPostValidationResponse validationResponse = new CaptchaPostValidationResponse();
            validationResponse.setSuccessfulAttempt(false);
            validationResponse.setEnableCaptchaResponsePath(true);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("reCaptcha", "true");
            params.put("reCaptchaKey", CaptchaDataHolder.getInstance().getReCaptchaSiteKey());
            params.put("reCaptchaAPI", CaptchaDataHolder.getInstance().getReCaptchaAPIUrl());
            validationResponse.setCaptchaAttributes(params);
            return validationResponse;
        }
        return null;
    }

    public String getName() {
        return CONNECTOR_NAME;
    }

    public String getFriendlyName() {
        return "reCaptcha for SSO Login";
    }

    public String getCategory() {
        return "Login Attempts Security";
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("sso.login.recaptcha.enable.always", "Always prompt reCaptcha");
        nameMapping.put("sso.login.recaptcha.enable", "Prompt reCaptcha after max failed attempts");
        nameMapping.put("sso.login.recaptcha.on.max.failed.attempts", "Max failed attempts for reCaptcha");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("sso.login.recaptcha.enable.always", "Always prompt reCaptcha verification during SSO login flow.");
        descriptionMapping.put("sso.login.recaptcha.enable", "Prompt reCaptcha verification during SSO login flow only after the max failed attempts exceeded.");
        descriptionMapping.put("sso.login.recaptcha.on.max.failed.attempts", "Number of failed attempts allowed without prompting reCaptcha verification.");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        return new String[]{"sso.login.recaptcha.enable.always", "sso.login.recaptcha.enable", "sso.login.recaptcha.on.max.failed.attempts"};
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        Map<String, String> defaultProperties = CaptchaDataHolder.getInstance().getSSOLoginReCaptchaConnectorPropertyMap();
        if (StringUtils.isBlank((String)defaultProperties.get("sso.login.recaptcha.enable.always"))) {
            defaultProperties.put("sso.login.recaptcha.enable.always", "false");
        }
        if (StringUtils.isBlank((String)defaultProperties.get("sso.login.recaptcha.enable"))) {
            defaultProperties.put("sso.login.recaptcha.enable", "false");
        }
        if (StringUtils.isBlank((String)defaultProperties.get("sso.login.recaptcha.on.max.failed.attempts"))) {
            defaultProperties.put("sso.login.recaptcha.on.max.failed.attempts", "3");
        }
        Properties properties = new Properties();
        properties.putAll(defaultProperties);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }

    private List<String> getFailedUrlList() {
        ArrayList<String> failedRedirectUrls = new ArrayList<String>();
        String failedRedirectUrlStr = CaptchaDataHolder.getInstance().getReCaptchaErrorRedirectUrls();
        if (StringUtils.isNotBlank((String)failedRedirectUrlStr)) {
            failedRedirectUrls = Arrays.asList(failedRedirectUrlStr.split(","));
        }
        failedRedirectUrls.add(ON_FAIL_REDIRECT_URL);
        return failedRedirectUrls;
    }
}

