/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObjectContentReference;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidationProvider;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.SAMLSSOException;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOErrorConstants;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.xml.sax.SAXException;

public class SSOUtils {
    private static final Log log = LogFactory.getLog(SSOUtils.class);

    private SSOUtils() {
    }

    public static String createID() {
        RandomIdentifierGenerationStrategy generator = new RandomIdentifierGenerationStrategy();
        return generator.generateIdentifier();
    }

    public static void setSignature(LogoutResponse response, String signatureAlgorithm, String digestAlgorithm, boolean includeCert, X509Credential cred) throws SAMLSSOException {
        SSOUtils.doSetSignature((SignableXMLObject)response, signatureAlgorithm, digestAlgorithm, includeCert, cred);
    }

    public static void setSignature(RequestAbstractType request, String signatureAlgorithm, String digestAlgorithm, boolean includeCert, X509Credential cred) throws SAMLSSOException {
        SSOUtils.doSetSignature((SignableXMLObject)request, signatureAlgorithm, digestAlgorithm, includeCert, cred);
    }

    public static void doSetSignature(SignableXMLObject request, String signatureAlgorithm, String digestAlgorithm, boolean includeCert, X509Credential x509Credential) throws SAMLSSOException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (x509Credential == null) {
            throw new IllegalArgumentException("X509Credential cannot be null");
        }
        if (x509Credential.getEntityCertificate() == null) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.IDP_CERTIFICATE_MISSING.getCode(), SSOErrorConstants.ErrorMessages.IDP_CERTIFICATE_MISSING.getMessage());
        }
        if (StringUtils.isEmpty((String)signatureAlgorithm)) {
            signatureAlgorithm = (String)IdentityApplicationManagementUtil.getXMLSignatureAlgorithms().get("RSA with SHA1");
        }
        if (StringUtils.isEmpty((String)digestAlgorithm)) {
            digestAlgorithm = (String)IdentityApplicationManagementUtil.getXMLDigestAlgorithms().get("SHA1");
        }
        Signature signature = (Signature)SSOUtils.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)x509Credential);
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        if (includeCert) {
            KeyInfo keyInfo = (KeyInfo)SSOUtils.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)SSOUtils.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)SSOUtils.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = null;
            try {
                value = org.apache.xml.security.utils.Base64.encode((byte[])x509Credential.getEntityCertificate().getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.RETRIEVING_THE_CERTIFICATE_FAILED.getCode(), "Error getting the certificate to include in the signature", e);
            }
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
        }
        request.setSignature(signature);
        ((SAMLObjectContentReference)signature.getContentReferences().get(0)).setDigestAlgorithm(digestAlgorithm);
        ArrayList<Signature> signatureList = new ArrayList<Signature>();
        signatureList.add(signature);
        MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)request);
        try {
            marshaller.marshall((XMLObject)request);
        }
        catch (MarshallingException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.MARSHALLING_SAML_REQUEST_FOR_SIGNING_FAILED.getCode(), SSOErrorConstants.ErrorMessages.MARSHALLING_SAML_REQUEST_FOR_SIGNING_FAILED.getMessage(), e);
        }
        Init.init();
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(SignatureValidationProvider.class.getClassLoader());
        try {
            Signer.signObjects(signatureList);
        }
        catch (SignatureException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SIGNING_SAML_REQUEST_FAILED.getCode(), SSOErrorConstants.ErrorMessages.SIGNING_SAML_REQUEST_FAILED.getMessage(), e);
        }
        finally {
            thread.setContextClassLoader(originalClassLoader);
        }
    }

    public static void addSignatureToHTTPQueryString(StringBuilder httpQueryString, String signatureAlgorithmURI, X509Credential credential) throws SAMLSSOException {
        try {
            httpQueryString.append("&SigAlg=");
            httpQueryString.append(URLEncoder.encode(signatureAlgorithmURI, "UTF-8").trim());
            byte[] rawSignature = XMLSigningUtil.signWithURI((Credential)credential, (String)signatureAlgorithmURI, (byte[])httpQueryString.toString().getBytes("UTF-8"));
            String base64Signature = new String(Base64.encodeBase64((byte[])rawSignature, (boolean)false));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generated digital signature value (base64-encoded) {} " + base64Signature));
            }
            httpQueryString.append("&Signature=" + URLEncoder.encode(base64Signature, "UTF-8").trim());
        }
        catch (org.opensaml.security.SecurityException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_SIGN_QUERY_STRING.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_SIGN_QUERY_STRING.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.ADDING_SIGNATURE_TO_HTTP_QUERY_STRING_FAILED.getCode(), SSOErrorConstants.ErrorMessages.ADDING_SIGNATURE_TO_HTTP_QUERY_STRING_FAILED.getMessage(), e);
        }
    }

    private static XMLObject buildXMLObject(QName objectQName) throws SAMLSSOException {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_RETRIEVE_BUILDER_FOR_OBJECT_QNAME.getCode(), String.format(SSOErrorConstants.ErrorMessages.UNABLE_TO_RETRIEVE_BUILDER_FOR_OBJECT_QNAME.getMessage(), objectQName));
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static String decode(String encodedStr) throws SAMLSSOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" >> encoded string in the SSOUtils/decode : " + encodedStr));
            }
            Base64 base64Decoder = new Base64();
            byte[] xmlBytes = encodedStr.getBytes("UTF-8");
            byte[] base64DecodedByteArray = base64Decoder.decode(xmlBytes);
            try {
                Inflater inflater = new Inflater(true);
                inflater.setInput(base64DecodedByteArray);
                byte[] xmlMessageBytes = new byte[5000];
                int resultLength = inflater.inflate(xmlMessageBytes);
                if (!inflater.finished()) {
                    throw new RuntimeException("End of the compressed data stream has NOT been reached");
                }
                inflater.end();
                String decodedString = new String(xmlMessageBytes, 0, resultLength, "UTF-8");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Request message " + decodedString));
                }
                return decodedString;
            }
            catch (DataFormatException e) {
                ByteArrayInputStream bais = new ByteArrayInputStream(base64DecodedByteArray);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InflaterInputStream iis = new InflaterInputStream(bais);
                byte[] buf = new byte[1024];
                int count = iis.read(buf);
                while (count != -1) {
                    baos.write(buf, 0, count);
                    count = iis.read(buf);
                }
                iis.close();
                String decodedStr = new String(baos.toByteArray(), Charset.forName("UTF-8"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Request message " + decodedStr));
                }
                return decodedStr;
            }
        }
        catch (IOException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.IO_ERROR.getCode(), "Error when decoding the SAML Request.", e);
        }
    }

    public static String decodeForPost(String encodedStr) throws SAMLSSOException {
        try {
            Base64 base64Decoder = new Base64();
            byte[] xmlBytes = encodedStr.getBytes("UTF-8");
            byte[] base64DecodedByteArray = base64Decoder.decode(xmlBytes);
            String decodedString = new String(base64DecodedByteArray, "UTF-8");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request message " + decodedString));
            }
            return decodedString;
        }
        catch (IOException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.IO_ERROR.getCode(), "Error when decoding the SAML Request.", e);
        }
    }

    public static String marshall(XMLObject xmlObject) throws SAMLSSOException {
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return byteArrayOutputStrm.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error Serializing the SAML Response");
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.IO_ERROR.getCode(), "Error Serializing the SAML Response", e);
        }
    }

    public static XMLObject unmarshall(String samlString) throws SAMLSSOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
            documentBuilderFactory.setIgnoringComments(true);
            Document document = SSOUtils.getDocument(documentBuilderFactory, samlString);
            if (SSOUtils.isSignedWithComments(document)) {
                documentBuilderFactory.setIgnoringComments(false);
                document = SSOUtils.getDocument(documentBuilderFactory, samlString);
            }
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (IOException | ParserConfigurationException | UnmarshallingException | SAXException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNMARSHALLING_SAML_REQUEST_ENCODED_STRING_FAILED.getCode(), SSOErrorConstants.ErrorMessages.UNMARSHALLING_SAML_REQUEST_ENCODED_STRING_FAILED.getMessage(), e);
        }
    }

    public static String encode(String xmlString) {
        String encodedRequestMessage = new String(Base64.encodeBase64((byte[])xmlString.getBytes(), (boolean)false));
        return encodedRequestMessage.trim();
    }

    public static boolean isAuthnRequestSigned(Map<String, String> properties) {
        String prop;
        if (properties != null && (prop = properties.get("ISAuthnReqSigned")) != null) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static boolean isLogoutEnabled(Map<String, String> properties) {
        String prop;
        if (properties != null && (prop = properties.get("IsLogoutEnabled")) != null) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static boolean isLogoutRequestSigned(Map<String, String> properties) {
        String prop;
        if (properties != null && (prop = properties.get("IsLogoutReqSigned")) != null) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static boolean isAuthnResponseSigned(Map<String, String> properties) {
        String prop;
        if (properties != null && (prop = properties.get("IsAuthnRespSigned")) != null) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static boolean isAssertionSigningEnabled(Map<String, String> properties) {
        String prop;
        if (properties != null && (prop = properties.get("isAssertionSigned")) != null) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static boolean isAssertionEncryptionEnabled(Map<String, String> properties) {
        String prop;
        if (properties != null && (prop = properties.get("IsAssertionEncrypted")) != null) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static boolean isArtifactResolveReqSigningEnabled(Map<String, String> properties) {
        String prop;
        if (properties != null && StringUtils.isNotBlank((String)(prop = properties.get("ISArtifactResolveReqSigned")))) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static boolean isArtifactResponseSigningEnabled(Map<String, String> properties) {
        String prop;
        if (properties != null && StringUtils.isNotBlank((String)(prop = properties.get("ISArtifactResponseSigned")))) {
            return Boolean.parseBoolean(prop);
        }
        return false;
    }

    public static String getArtifactResolveUrl(Map<String, String> properties) {
        String artifactResolveUrl = null;
        if (properties != null) {
            artifactResolveUrl = properties.get("ArtifactResolveUrl");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Artifact Resolution Service Url: " + artifactResolveUrl));
            }
        }
        return artifactResolveUrl;
    }

    public static String getSignatureAlgorithm(Map<String, String> properties) {
        String signatureAlgo = null;
        if (properties != null) {
            signatureAlgo = properties.get("SignatureAlgorithm");
        }
        if (StringUtils.isEmpty(signatureAlgo)) {
            signatureAlgo = "RSA with SHA1";
        }
        signatureAlgo = (String)IdentityApplicationManagementUtil.getXMLSignatureAlgorithms().get(signatureAlgo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signature Algorithm: " + signatureAlgo));
        }
        return signatureAlgo;
    }

    public static String getDigestAlgorithm(Map<String, String> properties) {
        String digestAlgo = null;
        if (properties != null) {
            digestAlgo = properties.get("DigestAlgorithm");
        }
        if (StringUtils.isEmpty(digestAlgo)) {
            digestAlgo = "SHA1";
        }
        digestAlgo = (String)IdentityApplicationManagementUtil.getXMLDigestAlgorithms().get(digestAlgo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest Algorithm: " + digestAlgo));
        }
        return digestAlgo;
    }

    public static String getSPEntityID(Map<String, String> properties) {
        String spEntityID = null;
        if (properties != null) {
            spEntityID = properties.get("SPEntityId");
            if (log.isDebugEnabled()) {
                log.debug((Object)("SP Entity ID: " + spEntityID));
            }
        }
        return spEntityID;
    }

    public static Map<String, String> getQueryMap(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)query)) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] paramSplitArr = param.split("=");
                String name = paramSplitArr[0];
                String value = "";
                if (paramSplitArr.length > 1) {
                    value = paramSplitArr[1];
                }
                map.put(name, value);
            }
        }
        return map;
    }

    private static boolean isSignedWithComments(Document document) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String assertionId = (String)xPath.compile("//*[local-name()='Assertion']/@ID").evaluate(document, XPathConstants.STRING);
            if (StringUtils.isBlank((String)assertionId)) {
                return false;
            }
            NodeList nodeList = (NodeList)xPath.compile("//*[local-name()='Assertion']/*[local-name()='Signature']/*[local-name()='SignedInfo']/*[local-name()='Reference'][@URI='#" + assertionId + "']/*[local-name()='Transforms']/*[local-name()='Transform'][@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#WithComments']").evaluate(document, XPathConstants.NODESET);
            return nodeList != null && nodeList.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            String message = "Failed to find the canonicalization algorithm of the assertion. Defaulting to: http://www.w3.org/2001/10/xml-exc-c14n#";
            log.warn((Object)message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            return false;
        }
    }

    private static Document getDocument(DocumentBuilderFactory documentBuilderFactory, String samlString) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(samlString.getBytes());
        return docBuilder.parse(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadKeyStoreFromFileSystem(String keyStorePath, String password, String type) {
        try (FileInputStream inputStream = new FileInputStream(keyStorePath);){
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(inputStream, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException e1) {
            throw new SecurityException("Could not get a keystore instance of type: " + type + ": " + e1);
        }
        catch (IOException e2) {
            throw new SecurityException("Could not open keystore in path: " + keyStorePath + ": " + e2);
        }
        catch (NoSuchAlgorithmException | CertificateException e3) {
            throw new SecurityException("Error in loading keystore in path: " + keyStorePath + ": " + e3);
        }
    }
}

