/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.manager;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.crypto.SecretKey;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.SAMLSSOException;
import org.wso2.carbon.identity.application.authenticator.samlsso.internal.SAMLSSOAuthenticatorServiceDataHolder;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOErrorConstants;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.user.api.UserStoreException;

public class X509CredentialImpl
implements X509Credential {
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private X509Certificate entityCertificate;
    private String entityId;
    private static KeyStore superTenantSignKeyStore = null;
    private static final Log log = LogFactory.getLog(X509CredentialImpl.class);
    public static final String SECURITY_SAML_SIGN_KEY_STORE_LOCATION = "Security.SAMLSignKeyStore.Location";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_TYPE = "Security.SAMLSignKeyStore.Type";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_PASSWORD = "Security.SAMLSignKeyStore.Password";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS = "Security.SAMLSignKeyStore.KeyAlias";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD = "Security.SAMLSignKeyStore.KeyPassword";

    public X509CredentialImpl(String tenantDomain, String idpCert) throws SAMLSSOException {
        PrivateKey key;
        X509Certificate cert;
        block39: {
            int tenantId;
            this.publicKey = null;
            this.privateKey = null;
            this.entityCertificate = null;
            this.entityId = "";
            if (idpCert != null && !idpCert.isEmpty()) {
                try {
                    cert = (X509Certificate)IdentityApplicationManagementUtil.decodeCertificate((String)idpCert);
                }
                catch (CertificateException e) {
                    throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.RETRIEVING_THE_CERTIFICATE_FAILED.getCode(), String.format("Error retrieving the certificate for alias %s", idpCert), e);
                }
            }
            try {
                tenantId = SAMLSSOAuthenticatorServiceDataHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.RETRIEVING_TENANT_ID_FAILED.getCode(), String.format(SSOErrorConstants.ErrorMessages.RETRIEVING_TENANT_ID_FAILED.getMessage(), tenantDomain), e);
            }
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            try {
                if (!tenantDomain.equals("carbon.super")) {
                    FrameworkUtils.startTenantFlow((String)tenantDomain);
                    String ksName = tenantDomain.trim().replace(".", "-");
                    String jksName = ksName + ".jks";
                    key = (PrivateKey)keyStoreManager.getPrivateKey(jksName, tenantDomain);
                    cert = (X509Certificate)keyStoreManager.getKeyStore(jksName).getCertificate(tenantDomain);
                    break block39;
                }
                if (this.isSignKeyStoreConfigured()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Initializing Key Data for super tenant using separate sign key store");
                    }
                    try {
                        if (superTenantSignKeyStore == null) {
                            String keyStoreLocation = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_LOCATION);
                            try (FileInputStream is = new FileInputStream(keyStoreLocation);){
                                String keyStoreType = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_TYPE);
                                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                                char[] keyStorePassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_PASSWORD).toCharArray();
                                keyStore.load(is, keyStorePassword);
                                superTenantSignKeyStore = keyStore;
                            }
                            catch (FileNotFoundException e) {
                                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_LOCATE_KEYSTORE.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_LOCATE_KEYSTORE.getMessage(), e);
                            }
                            catch (IOException e) {
                                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_READ_KEYSTORE.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_READ_KEYSTORE.getMessage(), e);
                            }
                            catch (CertificateException e) {
                                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_READ_CERTIFICATE.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_READ_CERTIFICATE.getMessage(), e);
                            }
                        }
                        String keyAlias = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS);
                        char[] keyPassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD).toCharArray();
                        Key privateKey = superTenantSignKeyStore.getKey(keyAlias, keyPassword);
                        Certificate publicKey = superTenantSignKeyStore.getCertificate(keyAlias);
                        if (!(privateKey instanceof PrivateKey)) {
                            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.CONFIGURED_PRIVATE_KEY_IS_INVALID.getCode(), SSOErrorConstants.ErrorMessages.CONFIGURED_PRIVATE_KEY_IS_INVALID.getMessage());
                        }
                        key = (PrivateKey)privateKey;
                        if (publicKey instanceof X509Certificate) {
                            cert = (X509Certificate)publicKey;
                            break block39;
                        }
                        throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.CONFIGURED_PUBLIC_KEY_IS_INVALID.getCode(), SSOErrorConstants.ErrorMessages.CONFIGURED_PUBLIC_KEY_IS_INVALID.getMessage());
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.INVALID_ALGORITHM.getCode(), SSOErrorConstants.ErrorMessages.INVALID_ALGORITHM.getMessage(), e);
                    }
                    catch (UnrecoverableKeyException e) {
                        throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_LOAD_KEY.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_LOAD_KEY.getMessage(), e);
                    }
                    catch (KeyStoreException e) {
                        throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_LOAD_KEYSTORE.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_LOAD_KEYSTORE.getMessage(), e);
                    }
                }
                key = keyStoreManager.getDefaultPrivateKey();
                cert = keyStoreManager.getDefaultPrimaryCertificate();
            }
            catch (Exception e) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.RETRIEVING_PRIVATE_KEY_AND_CERTIFICATE_FOR_TENANT_FAILED.getCode(), String.format(SSOErrorConstants.ErrorMessages.RETRIEVING_PRIVATE_KEY_AND_CERTIFICATE_FOR_TENANT_FAILED.getMessage(), tenantDomain), e);
            }
            finally {
                if (!tenantDomain.equals("carbon.super")) {
                    FrameworkUtils.endTenantFlow();
                }
            }
        }
        if (key == null) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.CANNOT_FIND_THE_PRIVATE_KEY_FOR_TENANT.getCode(), String.format(SSOErrorConstants.ErrorMessages.CANNOT_FIND_THE_PRIVATE_KEY_FOR_TENANT.getMessage(), tenantDomain));
        }
        this.privateKey = key;
        if (cert == null) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.CANNOT_FIND_THE_CERTIFICATE.getCode(), SSOErrorConstants.ErrorMessages.CANNOT_FIND_THE_CERTIFICATE.getMessage());
        }
        this.entityCertificate = cert;
        this.publicKey = cert.getPublicKey();
    }

    public X509CredentialImpl(X509Certificate certificate, String entityId) {
        this.publicKey = null;
        this.privateKey = null;
        this.entityCertificate = null;
        this.entityId = "";
        this.publicKey = certificate.getPublicKey();
        this.entityId = entityId;
    }

    private boolean isSignKeyStoreConfigured() {
        String keyStoreLocation = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_LOCATION);
        String keyStoreType = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_TYPE);
        String keyStorePassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_PASSWORD);
        String keyAlias = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS);
        String keyPassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD);
        return StringUtils.isNotBlank((String)keyStoreLocation) && StringUtils.isNotBlank((String)keyStoreType) && StringUtils.isNotBlank((String)keyStorePassword) && StringUtils.isNotBlank((String)keyAlias) && StringUtils.isNotBlank((String)keyPassword);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getEntityCertificate() {
        return this.entityCertificate;
    }

    public Collection<X509CRL> getCRLs() {
        return CollectionUtils.EMPTY_COLLECTION;
    }

    public Collection<X509Certificate> getEntityCertificateChain() {
        return Collections.emptySet();
    }

    public CredentialContextSet getCredentialContextSet() {
        return null;
    }

    public Class<? extends Credential> getCredentialType() {
        return null;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Collection<String> getKeyNames() {
        return Collections.emptySet();
    }

    public SecretKey getSecretKey() {
        return null;
    }

    public UsageType getUsageType() {
        return UsageType.UNSPECIFIED;
    }
}

