/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.manager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.ExtensionsBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeImpl;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.authentication.framework.config.builder.FileBasedConfigurationBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationRequest;
import org.wso2.carbon.identity.application.authenticator.samlsso.artifact.SAMLSSOArtifactResolutionService;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.ArtifactResolutionException;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.SAMLSSOException;
import org.wso2.carbon.identity.application.authenticator.samlsso.internal.SAMLSSOAuthenticatorServiceDataHolder;
import org.wso2.carbon.identity.application.authenticator.samlsso.manager.SAML2SSOManager;
import org.wso2.carbon.identity.application.authenticator.samlsso.manager.X509CredentialImpl;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOErrorConstants;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOUtils;
import org.wso2.carbon.identity.application.common.model.CertificateInfo;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class DefaultSAML2SSOManager
implements SAML2SSOManager {
    private static final String SIGN_AUTH2_SAML_USING_SUPER_TENANT = "SignAuth2SAMLUsingSuperTenant";
    private static final String NAME_ID_TYPE = "NameIDType";
    private static final Log log = LogFactory.getLog(DefaultSAML2SSOManager.class);
    private static boolean bootStrapped = false;
    private static String DEFAULT_MULTI_ATTRIBUTE_SEPARATOR = ",";
    private static String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final String VERIFY_ASSERTION_ISSUER = "VerifyAssertionIssuer";
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private IdentityProvider identityProvider = null;
    private Map<String, String> properties;
    private String tenantDomain;

    public static void doBootstrap() {
        if (!bootStrapped) {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            thread.setContextClassLoader(new DefaultSAML2SSOManager().getClass().getClassLoader());
            try {
                SAMLInitializer.doBootstrap();
                bootStrapped = true;
            }
            catch (InitializationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML3 library", (Throwable)e);
            }
            finally {
                thread.setContextClassLoader(loader);
            }
        }
    }

    @Override
    public void init(String tenantDomain, Map<String, String> properties, IdentityProvider idp) throws SAMLSSOException {
        this.tenantDomain = tenantDomain;
        this.identityProvider = idp;
        this.properties = properties;
    }

    @Override
    public String buildRequest(HttpServletRequest request, boolean isLogout, boolean isPassive, String loginPage, AuthenticationContext context) throws SAMLSSOException {
        AuthnRequest requestMessage;
        String queryParam;
        DefaultSAML2SSOManager.doBootstrap();
        String contextIdentifier = context.getContextIdentifier();
        if (request.getParameter("SAMLRequest") == null && (queryParam = context.getQueryParams()) != null) {
            String[] params;
            for (String param : params = queryParam.split("&")) {
                String[] values = param.split("=");
                if (values.length != 2 || !"SAMLRequest".equals(values[0])) continue;
                request.setAttribute("SAMLRequest", (Object)values[1]);
                break;
            }
        }
        if (!isLogout) {
            requestMessage = this.buildAuthnRequest(request, isPassive, loginPage, context);
        } else {
            String username = (String)request.getSession().getAttribute("logoutUsername");
            String sessionIndex = (String)request.getSession().getAttribute("logoutSessionIndex");
            String nameQualifier = (String)request.getSession().getAttribute("nameQualifier");
            String spNameQualifier = (String)request.getSession().getAttribute("spNameQualifier");
            String nameIdFormat = (String)request.getSession().getAttribute("nameIdFormat");
            requestMessage = this.buildLogoutRequest(username, sessionIndex, loginPage, nameQualifier, spNameQualifier, nameIdFormat, context);
        }
        String idpUrl = null;
        boolean isSignAuth2SAMLUsingSuperTenant = false;
        String encodedRequestMessage = this.encodeRequestMessage((RequestAbstractType)requestMessage);
        StringBuilder httpQueryString = new StringBuilder("SAMLRequest=" + encodedRequestMessage);
        try {
            httpQueryString.append("&RelayState=" + URLEncoder.encode(contextIdentifier, "UTF-8").trim());
        }
        catch (UnsupportedEncodingException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.URL_ENCODING_RELAY_STATE.getCode(), SSOErrorConstants.ErrorMessages.URL_ENCODING_RELAY_STATE.getMessage(), e);
        }
        boolean isRequestSigned = !isLogout ? SSOUtils.isAuthnRequestSigned(this.properties) : SSOUtils.isLogoutRequestSigned(this.properties);
        if (isRequestSigned) {
            String signatureAlgoProp = this.properties.get("SignatureAlgorithm");
            if (StringUtils.isEmpty((String)signatureAlgoProp)) {
                signatureAlgoProp = "RSA with SHA1";
            }
            String signatureAlgo = (String)IdentityApplicationManagementUtil.getXMLSignatureAlgorithms().get(signatureAlgoProp);
            Map parameterMap = FileBasedConfigurationBuilder.getInstance().getAuthenticatorBean("SAMLSSOAuthenticator").getParameterMap();
            if (parameterMap.size() > 0) {
                isSignAuth2SAMLUsingSuperTenant = Boolean.parseBoolean((String)parameterMap.get(SIGN_AUTH2_SAML_USING_SUPER_TENANT));
            }
            if (isSignAuth2SAMLUsingSuperTenant) {
                SSOUtils.addSignatureToHTTPQueryString(httpQueryString, signatureAlgo, new X509CredentialImpl("carbon.super", null));
            } else {
                SSOUtils.addSignatureToHTTPQueryString(httpQueryString, signatureAlgo, new X509CredentialImpl(context.getTenantDomain(), null));
            }
        }
        idpUrl = loginPage.indexOf("?") > -1 ? loginPage.concat("&").concat(httpQueryString.toString()) : loginPage.concat("?").concat(httpQueryString.toString());
        return idpUrl;
    }

    public String buildPostRequest(HttpServletRequest request, boolean isLogout, boolean isPassive, String loginPage, AuthenticationContext context) throws SAMLSSOException {
        AuthnRequest requestMessage;
        DefaultSAML2SSOManager.doBootstrap();
        String signatureAlgoProp = null;
        String digestAlgoProp = null;
        String includeCertProp = null;
        String signatureAlgo = null;
        String digestAlgo = null;
        boolean includeCert = false;
        signatureAlgoProp = this.properties.get("SignatureAlgorithm");
        if (StringUtils.isEmpty((String)signatureAlgoProp)) {
            signatureAlgoProp = "RSA with SHA1";
        }
        signatureAlgo = (String)IdentityApplicationManagementUtil.getXMLSignatureAlgorithms().get(signatureAlgoProp);
        digestAlgoProp = this.properties.get("DigestAlgorithm");
        if (StringUtils.isEmpty((String)digestAlgoProp)) {
            digestAlgoProp = "SHA1";
        }
        digestAlgo = (String)IdentityApplicationManagementUtil.getXMLDigestAlgorithms().get(digestAlgoProp);
        includeCertProp = this.properties.get("IncludeCert");
        if (StringUtils.isEmpty((String)includeCertProp) || Boolean.parseBoolean(includeCertProp)) {
            includeCert = true;
        }
        if (!isLogout) {
            requestMessage = this.buildAuthnRequest(request, isPassive, loginPage, context);
            if (SSOUtils.isAuthnRequestSigned(this.properties)) {
                SSOUtils.setSignature((RequestAbstractType)requestMessage, signatureAlgo, digestAlgo, includeCert, (X509Credential)new X509CredentialImpl(context.getTenantDomain(), null));
            }
        } else {
            String username = (String)request.getSession().getAttribute("logoutUsername");
            String sessionIndex = (String)request.getSession().getAttribute("logoutSessionIndex");
            String nameQualifier = (String)request.getSession().getAttribute("nameQualifier");
            String spNameQualifier = (String)request.getSession().getAttribute("spNameQualifier");
            String nameIdFormat = (String)request.getSession().getAttribute("nameIdFormat");
            requestMessage = this.buildLogoutRequest(username, sessionIndex, loginPage, nameQualifier, spNameQualifier, nameIdFormat, context);
            if (SSOUtils.isLogoutRequestSigned(this.properties)) {
                SSOUtils.setSignature((RequestAbstractType)requestMessage, signatureAlgo, digestAlgo, includeCert, (X509Credential)new X509CredentialImpl(context.getTenantDomain(), null));
            }
        }
        return SSOUtils.encode(SSOUtils.marshall((XMLObject)requestMessage));
    }

    @Override
    public void processResponse(HttpServletRequest request) throws SAMLSSOException {
        DefaultSAML2SSOManager.doBootstrap();
        if (this.isSAMLArtifactResponse(request)) {
            this.processArtifactResponse(request);
        } else {
            this.processSAMLResponse(request);
        }
    }

    private void processArtifactResponse(HttpServletRequest request) throws SAMLSSOException {
        SAMLSSOArtifactResolutionService artifactResolutionService = new SAMLSSOArtifactResolutionService(this.properties, this.tenantDomain);
        try {
            ArtifactResponse artifactResponse = artifactResolutionService.getSAMLArtifactResponse(request.getParameter("SAMLart"));
            this.validateSignature(artifactResponse);
            for (XMLObject child : artifactResponse.getOrderedChildren()) {
                if (!(child instanceof Response) && !(child instanceof LogoutResponse)) continue;
                this.validateResponseFormat(child);
                for (XMLObject responseElement : child.getOrderedChildren()) {
                    if (!(responseElement instanceof Status)) continue;
                    for (XMLObject statusElement : responseElement.getOrderedChildren()) {
                        String code = this.getStatusCode(statusElement);
                        if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(code)) {
                            this.executeSAMLReponse(request, child);
                            continue;
                        }
                        throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SAML_RESPONSE_STATUS_CODE_MISMATCHED_WITH_SUCCESS_CODE.getCode(), SSOErrorConstants.ErrorMessages.SAML_RESPONSE_STATUS_CODE_MISMATCHED_WITH_SUCCESS_CODE.getMessage());
                    }
                }
            }
        }
        catch (ArtifactResolutionException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.ARTIFACT_RESPONSE_RESOLUTION_FAILED.getCode(), SSOErrorConstants.ErrorMessages.ARTIFACT_RESPONSE_RESOLUTION_FAILED.getMessage(), e);
        }
    }

    private void processSAMLResponse(HttpServletRequest request) throws SAMLSSOException {
        String decodedResponse = new String(Base64.decodeBase64((byte[])request.getParameter("SAMLResponse").getBytes()));
        XMLObject samlObject = SSOUtils.unmarshall(decodedResponse);
        this.validateResponseFormat(samlObject);
        this.executeSAMLReponse(request, samlObject);
    }

    private void executeSAMLReponse(HttpServletRequest request, XMLObject samlObject) throws SAMLSSOException {
        if (samlObject instanceof LogoutResponse) {
            this.doSLO(request);
        } else if (samlObject instanceof Response) {
            this.processSSOResponse(request, (Response)samlObject);
        } else {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_PROCESS_SAML_OBJECT_TYPE.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_PROCESS_SAML_OBJECT_TYPE.getMessage());
        }
    }

    private String getStatusCode(XMLObject statusCode) {
        String code = statusCode.hasChildren() ? ((StatusCodeImpl)statusCode.getOrderedChildren().get(0)).getValue() : ((StatusCode)statusCode).getValue();
        return code;
    }

    private boolean isSAMLArtifactResponse(HttpServletRequest request) {
        return request.getParameter("SAMLart") != null;
    }

    protected AuthnRequest getAuthnRequest(AuthenticationContext context) throws SAMLSSOException {
        AuthnRequest authnRequest = null;
        AuthenticationRequest authenticationRequest = context.getAuthenticationRequest();
        String[] samlRequestParams = authenticationRequest.getRequestQueryParam("SAMLRequest");
        String samlRequest = null;
        if (samlRequestParams != null && samlRequestParams.length > 0) {
            samlRequest = samlRequestParams[0];
            XMLObject xmlObject = authenticationRequest.isPost() ? SSOUtils.unmarshall(SSOUtils.decodeForPost(samlRequest)) : SSOUtils.unmarshall(SSOUtils.decode(samlRequest));
            this.validateResponseFormat(xmlObject);
            if (xmlObject instanceof AuthnRequest) {
                authnRequest = (AuthnRequest)xmlObject;
            }
        }
        return authnRequest;
    }

    protected Extensions getSAMLExtensions(HttpServletRequest request) {
        try {
            String samlRequest = request.getParameter("SAMLRequest");
            if (samlRequest == null) {
                samlRequest = (String)request.getAttribute("SAMLRequest");
            }
            if (samlRequest != null) {
                AuthnRequest authnRequest;
                Extensions oldExtensions;
                XMLObject xmlObject = "POST".equals(request.getMethod()) ? SSOUtils.unmarshall(SSOUtils.decodeForPost(samlRequest)) : SSOUtils.unmarshall(SSOUtils.decode(samlRequest));
                this.validateResponseFormat(xmlObject);
                if (xmlObject instanceof AuthnRequest && (oldExtensions = (authnRequest = (AuthnRequest)xmlObject).getExtensions()) != null) {
                    ExtensionsBuilder extBuilder = new ExtensionsBuilder();
                    Extensions extensions = extBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "Extensions", "saml2p");
                    extensions.setDOM(oldExtensions.getDOM());
                    return extensions;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error while loading SAML Extensions", (Throwable)e);
        }
        return null;
    }

    protected Extensions getSAMLExtensions(AuthnRequest inboundAuthnRequest) {
        Extensions extensions = null;
        Extensions oldExtensions = inboundAuthnRequest.getExtensions();
        if (oldExtensions != null) {
            ExtensionsBuilder extBuilder = new ExtensionsBuilder();
            extensions = extBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "Extensions", "saml2p");
            extensions.setDOM(oldExtensions.getDOM());
        }
        return extensions;
    }

    public void doSLO(HttpServletRequest request) throws SAMLSSOException {
        DefaultSAML2SSOManager.doBootstrap();
        XMLObject samlObject = null;
        if (request.getParameter("SAMLRequest") != null) {
            samlObject = SSOUtils.unmarshall(new String(Base64.decodeBase64((byte[])request.getParameter("SAMLRequest").getBytes())));
        }
        if (samlObject == null) {
            samlObject = SSOUtils.unmarshall(new String(Base64.decodeBase64((byte[])request.getParameter("SAMLResponse").getBytes())));
        }
        this.validateResponseFormat(samlObject);
        if (samlObject instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)samlObject;
            String string = ((SessionIndex)logoutRequest.getSessionIndexes().get(0)).getSessionIndex();
        } else if (samlObject instanceof LogoutResponse) {
            request.getSession().invalidate();
        } else {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.INVALID_SINGLE_LOGOUT_SAML_REQUEST.getCode(), SSOErrorConstants.ErrorMessages.INVALID_SINGLE_LOGOUT_SAML_REQUEST.getMessage());
        }
    }

    private void processSSOResponse(HttpServletRequest request, Response samlResponse) throws SAMLSSOException {
        Assertion assertion = null;
        if (SSOUtils.isAssertionEncryptionEnabled(this.properties)) {
            List encryptedAssertions = samlResponse.getEncryptedAssertions();
            EncryptedAssertion encryptedAssertion = null;
            if (CollectionUtils.isNotEmpty((Collection)encryptedAssertions)) {
                encryptedAssertion = (EncryptedAssertion)encryptedAssertions.get(0);
                try {
                    assertion = this.getDecryptedAssertion(encryptedAssertion);
                }
                catch (Exception e) {
                    throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.UNABLE_TO_DECRYPT_THE_SAML_ASSERTION.getCode(), SSOErrorConstants.ErrorMessages.UNABLE_TO_DECRYPT_THE_SAML_ASSERTION.getMessage(), e);
                }
            }
        } else {
            List assertions = samlResponse.getAssertions();
            if (CollectionUtils.isNotEmpty((Collection)assertions)) {
                assertion = (Assertion)assertions.get(0);
            }
        }
        if (assertion == null) {
            if (samlResponse.getStatus() != null && samlResponse.getStatus().getStatusCode() != null) {
                if (samlResponse.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Responder")) {
                    if (samlResponse.getStatus().getStatusCode().getStatusCode() != null) {
                        if (samlResponse.getStatus().getStatusCode().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:NoPassive")) {
                            return;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("SAML Response status code object value is: " + samlResponse.getStatus().getStatusCode().getStatusCode().getValue() + "."));
                            throw new SAMLSSOException("SAML Response status code object value is notequal to: urn:oasis:names:tc:SAML:2.0:status:NoPassive.");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"SAML Response status code object is null.");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("SAML Response status code value is: " + samlResponse.getStatus().getStatusCode().getValue() + "."));
                    throw new SAMLSSOException("SAML Response status code value is not equal to: urn:oasis:names:tc:SAML:2.0:status:Responder.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"SAML Response status or the status code is null.");
            }
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SAML_ASSERTION_NOT_FOUND_IN_RESPONSE.getCode(), SSOErrorConstants.ErrorMessages.SAML_ASSERTION_NOT_FOUND_IN_RESPONSE.getMessage());
        }
        this.validateAssertionIssuer(assertion);
        this.validateAssertionValidityPeriod(assertion);
        AuthenticationContext context = (AuthenticationContext)request.getAttribute("AUTHENTICATION_CONTEXT");
        this.validateAudienceRestriction(assertion, this.getIssuer(context));
        this.validateSignature(samlResponse, assertion);
        String subject = null;
        String nameQualifier = null;
        String spNameQualifier = null;
        String nameIdFormat = null;
        if (assertion.getSubject() != null && assertion.getSubject().getNameID() != null) {
            subject = assertion.getSubject().getNameID().getValue();
        }
        if (subject == null) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SUBJECT_NAME_NOT_FOUND_IN_RESPONSE.getCode(), SSOErrorConstants.ErrorMessages.SUBJECT_NAME_NOT_FOUND_IN_RESPONSE.getMessage());
        }
        request.getSession().setAttribute("username", subject);
        nameQualifier = assertion.getSubject().getNameID().getNameQualifier();
        spNameQualifier = assertion.getSubject().getNameID().getSPNameQualifier();
        nameIdFormat = assertion.getSubject().getNameID().getFormat();
        request.getSession(false).setAttribute("samlssoAttributes", this.getAssertionStatements(assertion));
        if (assertion.getAuthnStatements() != null) {
            ArrayList<String> authnContextClassRefs = new ArrayList<String>();
            for (AuthnStatement authnStatement : assertion.getAuthnStatements()) {
                if (authnStatement.getAuthnContext() == null || authnStatement.getAuthnContext().getAuthnContextClassRef() == null || !StringUtils.isNotBlank((String)authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received AuthnContextClassRef: " + authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef()));
                }
                authnContextClassRefs.add(authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef());
            }
            if (!authnContextClassRefs.isEmpty()) {
                HashMap<String, Object> authnContextClassRefMap = new HashMap<String, Object>();
                authnContextClassRefMap.put("AuthnContextClassRef", authnContextClassRefs);
                authnContextClassRefMap.put("IdPEntityId", assertion.getIssuer().getValue());
                request.getSession().setAttribute("AuthnContextClassRef", authnContextClassRefMap);
            }
        }
        if (SSOUtils.isLogoutEnabled(this.properties)) {
            String sessionId = ((AuthnStatement)assertion.getAuthnStatements().get(0)).getSessionIndex();
            if (sessionId == null) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.IDP_SESSION_ID_NOT_FOUND_FOR_SLO.getCode(), SSOErrorConstants.ErrorMessages.IDP_SESSION_ID_NOT_FOUND_FOR_SLO.getMessage());
            }
            request.getSession().setAttribute("IdPSession", (Object)sessionId);
            request.getSession().setAttribute("nameQualifier", (Object)nameQualifier);
            request.getSession().setAttribute("spNameQualifier", (Object)spNameQualifier);
            request.getSession().setAttribute("nameIdFormat", (Object)nameIdFormat);
        }
    }

    protected LogoutRequest buildLogoutRequest(String user, String sessionIndexStr, String idpUrl, String nameQualifier, String spNameQualifier, String nameIdFormat, AuthenticationContext context) throws SAMLSSOException {
        LogoutRequest logoutReq = new LogoutRequestBuilder().buildObject();
        logoutReq.setID(SSOUtils.createID());
        logoutReq.setDestination(idpUrl);
        DateTime issueInstant = new DateTime();
        logoutReq.setIssueInstant(issueInstant);
        logoutReq.setNotOnOrAfter(new DateTime(issueInstant.getMillis() + 300000L));
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        String spEntityId = this.getIssuer(context);
        if (spEntityId != null && !spEntityId.isEmpty()) {
            issuer.setValue(spEntityId);
        } else {
            issuer.setValue("carbonServer");
        }
        logoutReq.setIssuer(issuer);
        NameID nameId = new NameIDBuilder().buildObject();
        if (StringUtils.isNotBlank((String)nameIdFormat)) {
            nameId.setFormat(nameIdFormat);
        } else {
            String includeNameIDPolicyProp = this.properties.get("IncludeNameIDPolicy");
            if (StringUtils.isBlank((String)includeNameIDPolicyProp) || Boolean.parseBoolean(includeNameIDPolicyProp)) {
                nameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            }
        }
        nameId.setValue(user);
        nameId.setNameQualifier(nameQualifier);
        nameId.setSPNameQualifier(spNameQualifier);
        logoutReq.setNameID(nameId);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        if (sessionIndexStr != null) {
            sessionIndex.setSessionIndex(sessionIndexStr);
        } else {
            sessionIndex.setSessionIndex(UUID.randomUUID().toString());
        }
        logoutReq.getSessionIndexes().add(sessionIndex);
        logoutReq.setReason("Single Logout");
        return logoutReq;
    }

    protected AuthnRequest buildAuthnRequest(HttpServletRequest request, boolean isPassive, String idpUrl, AuthenticationContext context) throws SAMLSSOException {
        Extensions extensions;
        AuthnRequest inboundAuthnRequest;
        RequestedAuthnContext requestedAuthnContext;
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "samlp");
        String spEntityId = this.getIssuer(context);
        if (spEntityId != null && !spEntityId.isEmpty()) {
            issuer.setValue(spEntityId);
        } else {
            issuer.setValue("carbonServer");
        }
        DateTime issueInstant = new DateTime();
        AuthnRequestBuilder authRequestBuilder = new AuthnRequestBuilder();
        AuthnRequest authRequest = authRequestBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
        authRequest.setForceAuthn(Boolean.valueOf(this.isForceAuthenticate(context)));
        authRequest.setIsPassive(Boolean.valueOf(isPassive));
        authRequest.setIssueInstant(issueInstant);
        String includeProtocolBindingProp = this.properties.get("IncludeProtocolBinding");
        if (StringUtils.isEmpty((String)includeProtocolBindingProp) || Boolean.parseBoolean(includeProtocolBindingProp)) {
            authRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        }
        AuthenticatorConfig authenticatorConfig = (AuthenticatorConfig)FileBasedConfigurationBuilder.getInstance().getAuthenticatorConfigMap().get("SAMLSSOAuthenticator");
        String acsUrl = this.getAcsUrl(authenticatorConfig);
        authRequest.setAssertionConsumerServiceURL(acsUrl);
        authRequest.setIssuer(issuer);
        authRequest.setID(SSOUtils.createID());
        authRequest.setVersion(SAMLVersion.VERSION_20);
        authRequest.setDestination(idpUrl);
        String attributeConsumingServiceIndexProp = this.properties.get("AttributeConsumingServiceIndex");
        if (StringUtils.isNotEmpty((String)attributeConsumingServiceIndexProp)) {
            try {
                authRequest.setAttributeConsumingServiceIndex(Integer.valueOf(attributeConsumingServiceIndexProp));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Error while populating SAMLRequest with AttributeConsumingServiceIndex: " + attributeConsumingServiceIndexProp), (Throwable)e);
            }
        }
        String includeNameIDPolicyProp = this.properties.get("IncludeNameIDPolicy");
        boolean isNameIDPolicyPropIncluded = Boolean.parseBoolean(IdentityUtil.getProperty((String)"SSOService.SAML2AuthnRequestNameIdPolicyDefinedIfUnspecified")) ? StringUtils.isEmpty((String)includeNameIDPolicyProp) || Boolean.parseBoolean(includeNameIDPolicyProp) : Boolean.parseBoolean(includeNameIDPolicyProp);
        if (isNameIDPolicyPropIncluded) {
            NameIDPolicyBuilder nameIdPolicyBuilder = new NameIDPolicyBuilder();
            NameIDPolicy nameIdPolicy = nameIdPolicyBuilder.buildObject();
            String nameIdType = this.properties.get(NAME_ID_TYPE);
            if (StringUtils.isBlank((String)nameIdType) && authenticatorConfig != null && StringUtils.isBlank((String)(nameIdType = (String)authenticatorConfig.getParameterMap().get(NAME_ID_TYPE)))) {
                nameIdType = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            }
            nameIdPolicy.setFormat(nameIdType);
            if (spEntityId != null && !spEntityId.isEmpty()) {
                nameIdPolicy.setSPNameQualifier(spEntityId);
            }
            nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
            authRequest.setNameIDPolicy(nameIdPolicy);
        }
        if ((requestedAuthnContext = this.buildRequestedAuthnContext(inboundAuthnRequest = this.getAuthnRequest(context))) != null) {
            authRequest.setRequestedAuthnContext(requestedAuthnContext);
        }
        if ((extensions = this.getSAMLExtensions(request)) != null) {
            authRequest.setExtensions(extensions);
        }
        return authRequest;
    }

    private String getAcsUrl(AuthenticatorConfig authenticatorConfig) throws SAMLSSOException {
        String tmpAcsUrl;
        String acsUrl = this.properties.get("ACSUrl");
        if (StringUtils.isNotEmpty((String)acsUrl) && log.isDebugEnabled()) {
            log.debug((Object)("Picking SAML acs URL from " + this.identityProvider.getIdentityProviderName() + " IDP's configuration: " + acsUrl));
        }
        if (StringUtils.isEmpty((String)acsUrl) && authenticatorConfig != null && StringUtils.isNotBlank((String)(tmpAcsUrl = (String)authenticatorConfig.getParameterMap().get("SAMLSSOAssertionConsumerUrl")))) {
            acsUrl = tmpAcsUrl;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Picking SAML acs URL from application-authentication.xml: " + acsUrl));
            }
        }
        if (StringUtils.isEmpty((String)acsUrl)) {
            try {
                acsUrl = ServiceURLBuilder.create().addPath(new String[]{"commonauth"}).build().getAbsolutePublicURL();
            }
            catch (URLBuilderException e) {
                throw new SAMLSSOException("Error while building the acs url.", e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Falling back to default SAML acs URL of the server: " + acsUrl));
            }
        }
        return acsUrl;
    }

    private RequestedAuthnContext buildRequestedAuthnContext(AuthnRequest inboundAuthnRequest) throws SAMLSSOException {
        RequestedAuthnContextBuilder requestedAuthnContextBuilder = null;
        RequestedAuthnContext requestedAuthnContext = null;
        String includeAuthnContext = this.properties.get("IncludeAuthnContext");
        if (StringUtils.isNotEmpty((String)includeAuthnContext) && "as_request".equalsIgnoreCase(includeAuthnContext)) {
            RequestedAuthnContext incomingRequestedAuthnContext;
            if (inboundAuthnRequest != null && (incomingRequestedAuthnContext = inboundAuthnRequest.getRequestedAuthnContext()) != null) {
                requestedAuthnContextBuilder = new RequestedAuthnContextBuilder();
                requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
                requestedAuthnContext.setDOM(incomingRequestedAuthnContext.getDOM());
            }
        } else if (StringUtils.isEmpty((String)includeAuthnContext) || "yes".equalsIgnoreCase(includeAuthnContext)) {
            requestedAuthnContextBuilder = new RequestedAuthnContextBuilder();
            requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
            AuthnContextClassRefBuilder authnContextClassRefBuilder = new AuthnContextClassRefBuilder();
            AuthnContextClassRef authnContextClassRef = authnContextClassRefBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef", "saml2");
            String authnContextClass = this.properties.get("AuthnContextClassRef");
            if (StringUtils.isNotEmpty((String)authnContextClass)) {
                String samlAuthnContextURN = (String)IdentityApplicationManagementUtil.getSAMLAuthnContextClasses().get(authnContextClass);
                if (!StringUtils.isBlank((String)samlAuthnContextURN)) {
                    authnContextClassRef.setAuthnContextClassRef(samlAuthnContextURN);
                } else {
                    authnContextClassRef.setAuthnContextClassRef(authnContextClass);
                }
            } else {
                authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            }
            String authnContextComparison = this.properties.get("AuthnContextComparisonLevel");
            if (StringUtils.isNotEmpty((String)authnContextComparison)) {
                if (AuthnContextComparisonTypeEnumeration.EXACT.toString().equalsIgnoreCase(authnContextComparison)) {
                    requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
                } else if (AuthnContextComparisonTypeEnumeration.MINIMUM.toString().equalsIgnoreCase(authnContextComparison)) {
                    requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
                } else if (AuthnContextComparisonTypeEnumeration.MAXIMUM.toString().equalsIgnoreCase(authnContextComparison)) {
                    requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.MAXIMUM);
                } else if (AuthnContextComparisonTypeEnumeration.BETTER.toString().equalsIgnoreCase(authnContextComparison)) {
                    requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.BETTER);
                }
            } else {
                requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
            }
            requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        }
        return requestedAuthnContext;
    }

    private boolean isForceAuthenticate(AuthenticationContext context) {
        boolean forceAuthenticate = false;
        String forceAuthenticateProp = this.properties.get("ForceAuthentication");
        if ("yes".equalsIgnoreCase(forceAuthenticateProp)) {
            forceAuthenticate = true;
        } else if ("as_request".equalsIgnoreCase(forceAuthenticateProp)) {
            forceAuthenticate = context.isForceAuthenticate();
        }
        return forceAuthenticate;
    }

    private String encodeRequestMessage(RequestAbstractType requestMessage) throws SAMLSSOException {
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)requestMessage);
        Element authDOM = null;
        try {
            authDOM = marshaller.marshall((XMLObject)requestMessage);
            Deflater deflater = new Deflater(8, true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
            SerializeSupport.writeNode((Node)authDOM, (OutputStream)deflaterOutputStream);
            deflaterOutputStream.close();
            String encodedRequestMessage = new String(Base64.encodeBase64((byte[])byteArrayOutputStream.toByteArray(), (boolean)false));
            byteArrayOutputStream.write(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SAML Request  :  " + deflaterOutputStream.toString()));
            }
            return URLEncoder.encode(encodedRequestMessage, "UTF-8").trim();
        }
        catch (IOException | MarshallingException e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.IO_ERROR.getCode(), "Error occurred while encoding SAML request", e);
        }
    }

    protected void validateResponseFormat(XMLObject response) throws SAMLSSOException {
        NodeList responseList = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Response");
        if (responseList != null && responseList.getLength() > 0) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.INVALID_SCHEMA_FOR_THE_SAML_2_RESPONSE.getCode(), SSOErrorConstants.ErrorMessages.INVALID_SCHEMA_FOR_THE_SAML_2_RESPONSE.getMessage());
        }
        NodeList assertionList = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (assertionList != null && assertionList.getLength() > 1) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.PROCESSING_SAML2_MULTIPLE_ASSERTION_ELEMENT_FOUND.getCode(), SSOErrorConstants.ErrorMessages.PROCESSING_SAML2_MULTIPLE_ASSERTION_ELEMENT_FOUND.getMessage());
        }
    }

    private Map<ClaimMapping, String> getAssertionStatements(Assertion assertion) {
        List attributeStatementList;
        HashMap<ClaimMapping, String> results = new HashMap<ClaimMapping, String>();
        String multiAttributeSeparator = DEFAULT_MULTI_ATTRIBUTE_SEPARATOR;
        try {
            UserRealm realm = SAMLSSOAuthenticatorServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(-1234);
            UserStoreManager userStoreManager = (UserStoreManager)realm.getUserStoreManager();
            multiAttributeSeparator = userStoreManager.getRealmConfiguration().getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
        }
        catch (UserStoreException e) {
            log.warn((Object)"Error while reading MultiAttributeSeparator valaue from primary user store ", (Throwable)e);
        }
        if (assertion != null && (attributeStatementList = assertion.getAttributeStatements()) != null) {
            for (AttributeStatement statement : attributeStatementList) {
                List attributesList = statement.getAttributes();
                for (Attribute attribute : attributesList) {
                    List values = attribute.getAttributeValues();
                    String attributesValue = null;
                    if (values != null) {
                        for (int i = 0; i < values.size(); ++i) {
                            Element value = ((XMLObject)attribute.getAttributeValues().get(i)).getDOM();
                            String attributeValue = value.getTextContent();
                            attributesValue = StringUtils.isBlank(attributesValue) ? attributeValue : attributesValue + multiAttributeSeparator + attributeValue;
                        }
                    }
                    results.put(ClaimMapping.build((String)attribute.getName(), (String)attribute.getName(), null, (boolean)false), attributesValue);
                }
            }
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAudienceRestriction(Assertion assertion, String issuer) throws SAMLSSOException {
        if (assertion == null) return;
        Conditions conditions = assertion.getConditions();
        if (conditions == null) throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SAML_CONDITIONS_NOT_FOUND.getCode(), SSOErrorConstants.ErrorMessages.SAML_CONDITIONS_NOT_FOUND.getMessage());
        List audienceRestrictions = conditions.getAudienceRestrictions();
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.AUDIENCE_RESTRICTION_NOT_FOUND.getCode(), SSOErrorConstants.ErrorMessages.AUDIENCE_RESTRICTION_NOT_FOUND.getMessage());
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (!CollectionUtils.isNotEmpty((Collection)audienceRestriction.getAudiences())) throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.AUDIENCES_NOT_FOUND.getCode(), SSOErrorConstants.ErrorMessages.AUDIENCES_NOT_FOUND.getMessage());
            boolean audienceFound = false;
            for (Audience audience : audienceRestriction.getAudiences()) {
                if (issuer == null || !issuer.equals(audience.getAudienceURI())) continue;
                audienceFound = true;
                break;
            }
            if (audienceFound) continue;
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.AUDIENCE_RESTRICTION_VALIDATION_FAILED.getCode(), SSOErrorConstants.ErrorMessages.AUDIENCE_RESTRICTION_VALIDATION_FAILED.getMessage());
        }
    }

    protected void validateSignature(Response response, Assertion assertion) throws SAMLSSOException {
        Signature signature;
        if (SSOUtils.isAuthnResponseSigned(this.properties)) {
            signature = response.getSignature();
            if (signature == null) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SIGNATURE_ELEMENT_NOT_FOUND_WHILE_ENABLED.getCode(), SSOErrorConstants.ErrorMessages.SIGNATURE_ELEMENT_NOT_FOUND_WHILE_ENABLED.getMessage());
            }
            this.validateSignature((XMLObject)signature);
        }
        if (SSOUtils.isAssertionSigningEnabled(this.properties)) {
            signature = assertion.getSignature();
            if (assertion.getSignature() == null) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SIGNATURE_ELEMENT_NOT_FOUND_IN_SAML_ASSERTION_WHILE_SIGNING_ENABLED.getCode(), SSOErrorConstants.ErrorMessages.SIGNATURE_ELEMENT_NOT_FOUND_IN_SAML_ASSERTION_WHILE_SIGNING_ENABLED.getMessage());
            }
            this.validateSignature((XMLObject)signature);
        }
    }

    protected void validateSignature(ArtifactResponse artifactResponse) throws SAMLSSOException {
        if (SSOUtils.isArtifactResponseSigningEnabled(this.properties)) {
            Signature signature = artifactResponse.getSignature();
            if (signature == null) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SIGNATURE_ELEMENT_NOT_FOUND_IN_ARTIFACT_RESPONSE_WHILE_ENABLED.getCode(), SSOErrorConstants.ErrorMessages.SIGNATURE_ELEMENT_NOT_FOUND_IN_ARTIFACT_RESPONSE_WHILE_ENABLED.getMessage());
            }
            this.validateSignature((XMLObject)signature);
        }
    }

    protected void validateSignature(XMLObject signature) throws SAMLSSOException {
        SignatureImpl signImpl = (SignatureImpl)signature;
        boolean isExceptionThrown = false;
        SignatureException validationException = null;
        try {
            SAMLSignatureProfileValidator signatureProfileValidator = new SAMLSignatureProfileValidator();
            signatureProfileValidator.validate((Signature)signImpl);
        }
        catch (SignatureException ex) {
            String logMsg = SSOErrorConstants.ErrorMessages.SIGNATURE_NOT_CONFIRM_TO_SAML_SIGNATURE_PROFILE.getMessage();
            CarbonConstants.AUDIT_LOG.warn((Object)logMsg);
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SIGNATURE_NOT_CONFIRM_TO_SAML_SIGNATURE_PROFILE.getCode(), logMsg, ex);
        }
        if (ArrayUtils.isEmpty((Object[])this.identityProvider.getCertificateInfoArray())) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.SIGNATURE_VALIDATION_FAILED_FOR_SAML_RESPONSE.getCode(), SSOErrorConstants.ErrorMessages.SIGNATURE_VALIDATION_FAILED_FOR_SAML_RESPONSE.getMessage(), validationException);
        }
        CertificateInfo[] certificateInfos = this.identityProvider.getCertificateInfoArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)("The number of certificates has been found is: " + certificateInfos.length));
        }
        int index = 0;
        for (CertificateInfo certificateInfo : certificateInfos) {
            String certVal = certificateInfo.getCertValue();
            X509CredentialImpl credential = new X509CredentialImpl(this.tenantDomain, certVal);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Validating the SAML signature with certificate at index: " + index));
                }
                SignatureValidator.validate((Signature)signImpl, (Credential)credential);
                isExceptionThrown = false;
                break;
            }
            catch (SignatureException e) {
                isExceptionThrown = true;
                if (validationException == null) {
                    validationException = e;
                } else {
                    validationException.addSuppressed((Throwable)e);
                }
                ++index;
            }
        }
        if (isExceptionThrown) {
            throw new SAMLSSOException("Signature validation failed for SAML Response", validationException);
        }
    }

    protected void validateAssertionValidityPeriod(Assertion assertion) throws SAMLSSOException {
        if (assertion.getConditions() != null) {
            DateTime validFrom = assertion.getConditions().getNotBefore();
            DateTime validTill = assertion.getConditions().getNotOnOrAfter();
            int timeStampSkewInSeconds = IdentityUtil.getClockSkewInSeconds();
            if (validFrom != null && validFrom.minusSeconds(timeStampSkewInSeconds).isAfterNow()) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.NOT_BEFORE_CONDITION_NOT_MET.getCode(), SSOErrorConstants.ErrorMessages.NOT_BEFORE_CONDITION_NOT_MET.getMessage());
            }
            if (validTill != null && validTill.plusSeconds(timeStampSkewInSeconds).isBeforeNow()) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.NOT_ON_OR_BEFORE_CONDITION_NOT_MET.getCode(), SSOErrorConstants.ErrorMessages.NOT_ON_OR_BEFORE_CONDITION_NOT_MET.getMessage());
            }
            if (validFrom != null && validTill != null && validFrom.isAfter((ReadableInstant)validTill)) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.NOT_ON_OR_BEFORE_CONDITION_NOT_MET.getCode(), "SAML Assertion Condition 'Not Before' must be less than the value of 'Not On Or After'");
            }
        }
    }

    protected Assertion getDecryptedAssertion(EncryptedAssertion encryptedAssertion) throws Exception {
        X509CredentialImpl credential = new X509CredentialImpl(this.tenantDomain, null);
        StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver((Credential)credential);
        EncryptedKey key = this.getEncryptedKey(encryptedAssertion);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyResolver, null);
        SecretKey dkey = (SecretKey)decrypter.decryptKey(key, encryptedAssertion.getEncryptedData().getEncryptionMethod().getAlgorithm());
        BasicCredential shared = CredentialSupport.getSimpleCredential((SecretKey)dkey);
        decrypter = new Decrypter((KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver((Credential)shared), null, null);
        decrypter.setRootInNewDocument(true);
        return decrypter.decrypt(encryptedAssertion);
    }

    protected void validateAssertionIssuer(Assertion assertion) throws SAMLSSOException {
        if (this.isAssertionIssuerVerificationEnabled()) {
            String idpEntityId;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Assertion issuer verification is enabled.");
            }
            if (!(idpEntityId = this.properties.get("IdPEntityId")).equals(assertion.getIssuer().getValue())) {
                log.warn((Object)("Issuer value in the assertion is invalid. Expected value is '" + idpEntityId + "', but received value in the assertion is '" + assertion.getIssuer().getValue() + "'."));
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.INVALID_IDP_ID.getCode(), String.format(SSOErrorConstants.ErrorMessages.INVALID_IDP_ID.getMessage(), assertion.getIssuer().getValue()));
            }
        }
    }

    private boolean isAssertionIssuerVerificationEnabled() {
        String isVerifyAssertionIssuer;
        AuthenticatorConfig authenticatorConfig = (AuthenticatorConfig)FileBasedConfigurationBuilder.getInstance().getAuthenticatorConfigMap().get("SAMLSSOAuthenticator");
        if (authenticatorConfig != null && authenticatorConfig.getParameterMap() != null && StringUtils.isNotEmpty((String)(isVerifyAssertionIssuer = (String)authenticatorConfig.getParameterMap().get(VERIFY_ASSERTION_ISSUER)))) {
            return Boolean.parseBoolean(isVerifyAssertionIssuer);
        }
        return false;
    }

    protected String getIssuer(AuthenticationContext context) {
        return this.properties.get("SPEntityId");
    }

    private EncryptedKey getEncryptedKey(EncryptedAssertion encryptedAssertion) throws Exception {
        List encryptedKeys = encryptedAssertion.getEncryptedData().getKeyInfo().getEncryptedKeys();
        if (CollectionUtils.isNotEmpty((Collection)encryptedKeys)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"EncryptedKey obtain from the encrypted data element.");
            }
            return (EncryptedKey)encryptedKeys.get(0);
        }
        encryptedKeys = encryptedAssertion.getEncryptedKeys();
        if (CollectionUtils.isNotEmpty((Collection)encryptedKeys)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"EncryptedKey obtained from the Assertion.");
            }
            return (EncryptedKey)encryptedKeys.get(0);
        }
        throw new Exception("Could not obtain the encrypted key from the encrypted assertion.");
    }
}

