/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.logout.validators;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.context.SAMLMessageContext;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.exception.SAMLLogoutException;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.util.LambdaExceptionUtil;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.util.SAMLLogoutUtil;

public class LogoutRequestValidator {
    private static final Log log = LogFactory.getLog(LogoutRequestValidator.class);
    private SAMLMessageContext samlMessageContext;

    public LogoutRequestValidator(SAMLMessageContext samlMessageContext) {
        this.samlMessageContext = samlMessageContext;
    }

    public boolean isValidate(LogoutRequest logoutRequest) {
        ArrayList<Consumer<LogoutRequest>> logoutRequestValidators = new ArrayList<Consumer<LogoutRequest>>();
        logoutRequestValidators.add(LambdaExceptionUtil.rethrowConsumer(this::isSAMLVersionValid));
        logoutRequestValidators.add(LambdaExceptionUtil.rethrowConsumer(this::isIssuerValid));
        logoutRequestValidators.add(LambdaExceptionUtil.rethrowConsumer(this::isSubjectValid));
        logoutRequestValidators.add(LambdaExceptionUtil.rethrowConsumer(this::isValidLogoutReqSignature));
        for (Consumer consumer : logoutRequestValidators) {
            consumer.accept(logoutRequest);
            if (this.samlMessageContext.getValidStatus().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void isSAMLVersionValid(LogoutRequest logoutRequest) throws SAMLLogoutException {
        if (!SAMLVersion.VERSION_20.equals(logoutRequest.getVersion())) {
            String notification = "Invalid SAML Version in Logout Request. SAML Version should be equal to 2.0";
            if (log.isDebugEnabled()) {
                log.debug((Object)notification);
            }
            this.samlMessageContext.setValidStatus(false);
            String errorResponse = SAMLLogoutUtil.buildErrorResponse(this.samlMessageContext, logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:VersionMismatch", notification);
            throw new SAMLLogoutException(notification, errorResponse, logoutRequest.getDestination(), this.samlMessageContext.getRelayState());
        }
    }

    private void isIssuerValid(LogoutRequest logoutRequest) throws SAMLLogoutException {
        if (logoutRequest.getIssuer().getValue() == null) {
            String notification = "Issuer value cannot be null in the Logout Request";
            if (log.isDebugEnabled()) {
                log.debug((Object)notification);
            }
            this.samlMessageContext.setValidStatus(false);
            String errorResponse = SAMLLogoutUtil.buildErrorResponse(this.samlMessageContext, logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", notification);
            throw new SAMLLogoutException(notification, errorResponse, logoutRequest.getDestination(), this.samlMessageContext.getRelayState());
        }
        if (StringUtils.isBlank((String)logoutRequest.getIssuer().getFormat()) || !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(logoutRequest.getIssuer().getFormat())) {
            String notification = "Invalid Issuer Format in the logout request";
            if (log.isDebugEnabled()) {
                log.debug((Object)notification);
            }
            this.samlMessageContext.setValidStatus(false);
            String errorResponse = SAMLLogoutUtil.buildErrorResponse(this.samlMessageContext, logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", notification);
            throw new SAMLLogoutException(notification, errorResponse, logoutRequest.getDestination(), this.samlMessageContext.getRelayState());
        }
    }

    private void isSubjectValid(LogoutRequest logoutRequest) throws SAMLLogoutException {
        if (logoutRequest.getNameID() == null && logoutRequest.getBaseID() == null && logoutRequest.getEncryptedID() == null) {
            String notification = "Subject Name should be specified in the Logout Request";
            if (log.isDebugEnabled()) {
                log.debug((Object)notification);
            }
            this.samlMessageContext.setValidStatus(false);
            String errorResponse = SAMLLogoutUtil.buildErrorResponse(this.samlMessageContext, logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", notification);
            throw new SAMLLogoutException(notification, errorResponse, logoutRequest.getDestination(), this.samlMessageContext.getRelayState());
        }
    }

    private void isValidLogoutReqSignature(LogoutRequest logoutRequest) throws SAMLLogoutException {
        if (Boolean.parseBoolean(this.samlMessageContext.getFedIdPConfigs().get("IsLogoutReqSigned").toString()) && !SAMLLogoutUtil.isValidSignature(logoutRequest, this.samlMessageContext)) {
            String notification = "Signature validation failed for logout request with issuer: " + logoutRequest.getIssuer().getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)notification);
            }
            this.samlMessageContext.setValidStatus(false);
            String errorResponse = SAMLLogoutUtil.buildErrorResponse(this.samlMessageContext, logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Requester", notification);
            throw new SAMLLogoutException(notification, errorResponse, logoutRequest.getDestination(), this.samlMessageContext.getRelayState());
        }
    }
}

