/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.logout.validators;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.net.URISupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.wso2.carbon.identity.application.authenticator.samlsso.manager.X509CredentialImpl;
import org.wso2.carbon.identity.base.IdentityException;

public class LogoutReqSignatureValidator {
    private static final Log log = LogFactory.getLog(LogoutReqSignatureValidator.class);

    public boolean validateSignature(String queryString, String issuer, X509Certificate certificate) throws SecurityException, IdentityException {
        byte[] signature = LogoutReqSignatureValidator.getSignature(queryString);
        byte[] signedContent = LogoutReqSignatureValidator.getSignedContent(queryString);
        String algorithmUri = LogoutReqSignatureValidator.getSignatureAlgorithm(queryString);
        CriteriaSet criteriaSet = LogoutReqSignatureValidator.buildCriteriaSet(issuer);
        X509CredentialImpl credential = new X509CredentialImpl(certificate, issuer);
        ArrayList<X509CredentialImpl> credentials = new ArrayList<X509CredentialImpl>();
        credentials.add(credential);
        CollectionCredentialResolver credentialResolver = new CollectionCredentialResolver(credentials);
        KeyInfoCredentialResolver keyResolver = DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
        ExplicitKeySignatureTrustEngine engine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credentialResolver, keyResolver);
        return engine.validate(signature, signedContent, algorithmUri, criteriaSet, null);
    }

    public boolean validateXMLSignature(SignableXMLObject request, X509Credential cred, String alias) throws IdentityException {
        if (request.getSignature() != null) {
            try {
                SignatureValidator.validate((Signature)request.getSignature(), (Credential)cred);
                return true;
            }
            catch (SignatureException e) {
                throw IdentityException.error((String)"Signature Validation Failed for the SAML Assertion", (Throwable)e);
            }
        }
        return false;
    }

    private static CriteriaSet buildCriteriaSet(String issuer) {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (StringUtils.isNotBlank((String)issuer)) {
            criteriaSet.add((Object)new EntityIdCriterion(issuer));
        }
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        return criteriaSet;
    }

    private static String getSignatureAlgorithm(String queryString) throws SecurityException, IdentityException {
        String sigAlgQueryParam = URISupport.getRawQueryStringParameter((String)queryString, (String)"SigAlg");
        if (StringUtils.isEmpty((String)sigAlgQueryParam)) {
            throw new SecurityException("Couldn't extract signature algorithm from query string: " + queryString);
        }
        try {
            if (StringUtils.isNotBlank((String)sigAlgQueryParam.split("=")[1])) {
                return URLDecoder.decode(sigAlgQueryParam.split("=")[1], StandardCharsets.UTF_8.name());
            }
            throw new SecurityException("Couldn't extract the signature algorithm value from the query string parameter: " + sigAlgQueryParam);
        }
        catch (UnsupportedEncodingException e) {
            throw new IdentityException("Error occurred while decoding signature algorithm query parameter: " + sigAlgQueryParam, (Throwable)e);
        }
    }

    private static byte[] getSignature(String queryString) throws SecurityException, IdentityException {
        String signatureQueryParam = URISupport.getRawQueryStringParameter((String)queryString, (String)"Signature");
        if (StringUtils.isEmpty((String)signatureQueryParam)) {
            throw new SecurityException("Couldn't extract the Signature from query string: " + queryString);
        }
        try {
            if (StringUtils.isNotBlank((String)signatureQueryParam.split("=")[1])) {
                return Base64Support.decode((String)URLDecoder.decode(signatureQueryParam.split("=")[1], StandardCharsets.UTF_8.name()));
            }
            throw new SecurityException("Couldn't extract the signature value from the query string parameter: " + signatureQueryParam);
        }
        catch (UnsupportedEncodingException e) {
            throw new IdentityException("Error occurred while decoding signature query parameter: " + signatureQueryParam, (Throwable)e);
        }
    }

    private static byte[] getSignedContent(String queryString) throws SecurityException {
        String sigendContent = LogoutReqSignatureValidator.buildSignedContentString(queryString);
        if (StringUtils.isEmpty((String)sigendContent)) {
            String message = "Couldn't extract signed content string from query string: " + queryString;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new SecurityException(message);
        }
        return sigendContent.getBytes(StandardCharsets.UTF_8);
    }

    private static String buildSignedContentString(String queryString) throws SecurityException {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isBlank((String)URISupport.getRawQueryStringParameter((String)queryString, (String)"SAMLRequest"))) {
            throw new SecurityException("Process of extracting SAMLRequest from query string failed: " + queryString);
        }
        LogoutReqSignatureValidator.appendParameter(builder, queryString, "SAMLRequest");
        LogoutReqSignatureValidator.appendParameter(builder, queryString, "RelayState");
        LogoutReqSignatureValidator.appendParameter(builder, queryString, "SigAlg");
        return builder.toString();
    }

    private static boolean appendParameter(StringBuilder builder, String queryString, String paramName) {
        String rawParam = URISupport.getRawQueryStringParameter((String)queryString, (String)paramName);
        if (rawParam == null) {
            return false;
        }
        if (builder.length() > 0) {
            builder.append('&');
        }
        builder.append(rawParam);
        return true;
    }
}

