/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.logout.util;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.core.impl.StatusMessageBuilder;
import org.opensaml.security.SecurityException;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.SAMLSSOException;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.context.SAMLMessageContext;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.exception.SAMLLogoutException;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.validators.LogoutReqSignatureValidator;
import org.wso2.carbon.identity.application.authenticator.samlsso.manager.DefaultSAML2SSOManager;
import org.wso2.carbon.identity.application.authenticator.samlsso.manager.X509CredentialImpl;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;

public class SAMLLogoutUtil {
    private static boolean bootStrapped = false;
    private static final Log log = LogFactory.getLog(SAMLLogoutUtil.class);

    private SAMLLogoutUtil() {
    }

    public static void doBootstrap() {
        if (!bootStrapped) {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            thread.setContextClassLoader(new DefaultSAML2SSOManager().getClass().getClassLoader());
            try {
                SAMLInitializer.doBootstrap();
                bootStrapped = true;
            }
            catch (InitializationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML3 library", (Throwable)e);
            }
            finally {
                thread.setContextClassLoader(loader);
            }
        }
    }

    private static Status buildStatus(String responseStatusCode, String responseStatusMsg) {
        Status status = new StatusBuilder().buildObject();
        StatusCode statusCode = new StatusCodeBuilder().buildObject();
        statusCode.setValue(responseStatusCode);
        status.setStatusCode(statusCode);
        if (StringUtils.isNotBlank((String)responseStatusMsg)) {
            StatusMessage statusMessage = new StatusMessageBuilder().buildObject();
            statusMessage.setMessage(responseStatusMsg);
            status.setStatusMessage(statusMessage);
        }
        return status;
    }

    private static String createID() {
        RandomIdentifierGenerationStrategy generator = new RandomIdentifierGenerationStrategy();
        return generator.generateIdentifier();
    }

    public static Map<String, String> getFederatedIdPConfigs(IdentityProvider identityProvider) {
        List<String> idpPropertyNames = Arrays.asList("SPEntityId", "SSOUrl", "IsAuthnRespSigned", "IncludeCert", "IsLogoutReqSigned", "IsSLORequestAccepted");
        if (identityProvider.getDefaultAuthenticatorConfig() != null && identityProvider.getDefaultAuthenticatorConfig().getProperties() != null) {
            Property[] properties = identityProvider.getDefaultAuthenticatorConfig().getProperties();
            return Arrays.stream(properties).filter(t -> idpPropertyNames.contains(t.getName())).collect(Collectors.toMap(Property::getName, Property::getValue));
        }
        return Collections.emptyMap();
    }

    public static String buildErrorResponse(SAMLMessageContext samlMessageContext, String inResponseTo, String statusCode, String statusMsg) throws SAMLLogoutException {
        try {
            LogoutResponse errorResponse = SAMLLogoutUtil.buildResponse(samlMessageContext, inResponseTo, statusCode, statusMsg);
            return SSOUtils.encode(SSOUtils.marshall((XMLObject)errorResponse));
        }
        catch (SAMLSSOException e) {
            throw new SAMLLogoutException("Error Serializing the SAML Response", (Throwable)((Object)e));
        }
    }

    public static LogoutResponse buildResponse(SAMLMessageContext samlMessageContext, String inResponseTo, String statusCode, String statusMsg) throws SAMLLogoutException {
        try {
            SAMLLogoutUtil.doBootstrap();
            String issuerID = samlMessageContext.getFedIdPConfigs().get("SPEntityId");
            String acsUrl = samlMessageContext.getFedIdPConfigs().get("SSOUrl");
            boolean isResponseSigned = Boolean.parseBoolean(samlMessageContext.getFedIdPConfigs().get("IsAuthnRespSigned").toString());
            boolean isIncludeCert = Boolean.parseBoolean(samlMessageContext.getFedIdPConfigs().get("IncludeCert").toString());
            LogoutResponse logoutResp = new LogoutResponseBuilder().buildObject();
            logoutResp.setID(SAMLLogoutUtil.createID());
            logoutResp.setInResponseTo(inResponseTo);
            logoutResp.setIssuer(SAMLLogoutUtil.getIssuer(issuerID));
            logoutResp.setVersion(SAMLVersion.VERSION_20);
            logoutResp.setStatus(SAMLLogoutUtil.buildStatus(statusCode, statusMsg));
            logoutResp.setIssueInstant(new DateTime());
            logoutResp.setDestination(acsUrl);
            if (isResponseSigned && "urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
                SSOUtils.setSignature(logoutResp, null, null, isIncludeCert, (X509Credential)new X509CredentialImpl(samlMessageContext.getTenantDomain(), null));
            }
            return logoutResp;
        }
        catch (SAMLSSOException e) {
            throw new SAMLLogoutException("Error occurred while setting the signature of logout response", (Throwable)((Object)e));
        }
    }

    private static Issuer getIssuer(String issuerID) {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(issuerID);
        return issuer;
    }

    public static boolean isValidSignature(LogoutRequest logoutRequest, SAMLMessageContext samlMessageContext) throws SAMLLogoutException {
        String issuer = logoutRequest.getIssuer().getValue();
        X509Certificate x509Certificate = SAMLLogoutUtil.generateX509Certificate(samlMessageContext.getFederatedIdP().getCertificate());
        LogoutReqSignatureValidator signatureValidator = new LogoutReqSignatureValidator();
        try {
            if (samlMessageContext.getSAMLLogoutRequest().isPost()) {
                return signatureValidator.validateXMLSignature((SignableXMLObject)logoutRequest, new X509CredentialImpl(x509Certificate, issuer), null);
            }
            return signatureValidator.validateSignature(samlMessageContext.getSAMLLogoutRequest().getQueryString(), issuer, x509Certificate);
        }
        catch (SecurityException | IdentityException e) {
            throw new SAMLLogoutException("Process of validating the signature failed for the logout request withissuer: " + logoutRequest.getIssuer().getValue(), e);
        }
    }

    private static X509Certificate generateX509Certificate(String certificate) throws SAMLLogoutException {
        byte[] certificateData = Base64.getDecoder().decode(certificate);
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificateData));
        }
        catch (CertificateException e) {
            throw new SAMLLogoutException("Error occurred while generating X509Certificate using the string value of the certificate in IdP's properties: " + certificate, e);
        }
    }

    public static String getSessionIndex(LogoutRequest logoutRequest) throws SAMLLogoutException {
        if (CollectionUtils.isNotEmpty((Collection)logoutRequest.getSessionIndexes()) && StringUtils.isNotBlank((String)((SessionIndex)logoutRequest.getSessionIndexes().get(0)).getSessionIndex())) {
            return ((SessionIndex)logoutRequest.getSessionIndexes().get(0)).getSessionIndex();
        }
        String notification = "Could not extract the session index from the logout request";
        if (log.isDebugEnabled()) {
            log.debug((Object)notification);
        }
        throw new SAMLLogoutException(notification);
    }
}

