/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.logout.response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.encoder.Encode;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.exception.SAMLLogoutException;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.processor.SAMLLogoutRequestProcessor;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.response.SAMLLogoutResponse;

public class SAMLLogoutResponseFactory
extends HttpIdentityResponseFactory {
    private static final Log log = LogFactory.getLog(SAMLLogoutRequestProcessor.class);

    public boolean canHandle(IdentityResponse identityResponse) {
        return identityResponse instanceof SAMLLogoutResponse;
    }

    public boolean canHandle(FrameworkException exception) {
        return exception instanceof SAMLLogoutException && ((SAMLLogoutException)exception).getAcsUrl() != null;
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder create(IdentityResponse identityResponse) {
        HttpIdentityResponse.HttpIdentityResponseBuilder responseBuilder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        this.create(responseBuilder, identityResponse);
        return responseBuilder;
    }

    public void create(HttpIdentityResponse.HttpIdentityResponseBuilder builder, IdentityResponse identityResponse) {
        SAMLLogoutResponse response = (SAMLLogoutResponse)identityResponse;
        String samlPostPage = this.generateSamlPostPage(response.getAcsUrl(), response.getResponse(), response.getRelayState());
        builder.setBody(samlPostPage);
        builder.setStatusCode(200);
        builder.setContentType("text/html; charset=UTF-8");
        builder.setRedirectURL(response.getAcsUrl());
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder handleException(FrameworkException exception) {
        HttpIdentityResponse.HttpIdentityResponseBuilder errorResponseBuilder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        SAMLLogoutException samlException = (SAMLLogoutException)exception;
        String samlPostPage = this.generateSamlPostPage(samlException.getAcsUrl(), samlException.getExceptionMessage(), samlException.getRelayState());
        errorResponseBuilder.setBody(samlPostPage);
        errorResponseBuilder.setStatusCode(200);
        errorResponseBuilder.setContentType("text/html; charset=UTF-8");
        errorResponseBuilder.setRedirectURL(samlException.getAcsUrl());
        return errorResponseBuilder;
    }

    private String generateSamlPostPage(String acUrl, String samlMessage, String relayState) {
        String postPage = "<html><body><p>You are now redirected back to " + Encode.forHtmlContent((String)acUrl) + " If the redirection fails, please click the post button.</p><form method='post' action='" + Encode.forHtmlAttribute((String)acUrl) + "'><p><input type='hidden' name='SAMLResponse' value='" + Encode.forHtmlAttribute((String)samlMessage) + "'/>";
        if (relayState != null) {
            postPage = postPage + "<input type='hidden' name='RelayState' value='" + Encode.forHtmlAttribute((String)relayState) + "'/>";
        }
        postPage = postPage + "<button type='submit'>POST</button></p></form><script type='text/javascript'>document.forms[0].submit();</script></body></html>";
        if (log.isDebugEnabled()) {
            log.debug((Object)postPage);
        }
        return postPage;
    }
}

