/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.logout.request;

import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.net.URISupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkClientException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityRequestFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.processor.SAMLLogoutRequestProcessor;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.request.SAMLLogoutRequest;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOConstants;

public class SAMLLogoutRequestFactory
extends HttpIdentityRequestFactory {
    private static final Log log = LogFactory.getLog(SAMLLogoutRequestProcessor.class);

    public String getName() {
        return "SAMLLogoutRequestFactory";
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        Matcher matcher;
        boolean canHandle = false;
        if (request != null && (matcher = SSOConstants.SAML_SLO_ENDPOINT_URL_PATTERN.matcher(request.getRequestURI())).matches() && StringUtils.isNotBlank((String)request.getParameter("SAMLRequest"))) {
            canHandle = true;
        }
        return canHandle;
    }

    public IdentityRequest.IdentityRequestBuilder create(HttpServletRequest request, HttpServletResponse response) throws FrameworkClientException {
        SAMLLogoutRequest.SAMLLogoutRequestBuilder builder = new SAMLLogoutRequest.SAMLLogoutRequestBuilder(request, response);
        super.create((IdentityRequest.IdentityRequestBuilder)builder, request, response);
        builder.isPost(StringUtils.isBlank((String)URISupport.getRawQueryStringParameter((String)request.getQueryString(), (String)"SAMLRequest")));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query string : " + request.getQueryString()));
        }
        return builder;
    }
}

