/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.logout.processor;

import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkRuntimeException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityMessageContext;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authentication.framework.inbound.InboundUtil;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.context.SAMLMessageContext;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.request.SAMLLogoutRequest;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.response.SAMLLogoutResponse;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;

public class SAMLLogoutResponseProcessor
extends IdentityProcessor {
    public boolean canHandle(IdentityRequest identityRequest) {
        IdentityMessageContext context = this.getContextIfAvailable(identityRequest);
        return context != null && context.getRequest() instanceof SAMLLogoutRequest;
    }

    public SAMLLogoutResponse.SAMLLogoutResponseBuilder process(IdentityRequest identityRequest) {
        String sessionDataKey = identityRequest.getParameter("sessionDataKey");
        SAMLMessageContext samlMessageContext = (SAMLMessageContext)InboundUtil.getContextFromCache((String)sessionDataKey);
        SAMLLogoutResponse.SAMLLogoutResponseBuilder builder = new SAMLLogoutResponse.SAMLLogoutResponseBuilder(samlMessageContext);
        builder.setResponse(samlMessageContext.getResponse());
        builder.setAcsUrl(samlMessageContext.getAcsUrl());
        builder.setRelayState(samlMessageContext.getRelayState());
        return builder;
    }

    public String getCallbackPath(IdentityMessageContext context) {
        try {
            return ServiceURLBuilder.create().addPath(new String[]{"identity"}).build().getAbsolutePublicURL();
        }
        catch (URLBuilderException e) {
            throw FrameworkRuntimeException.error((String)"Error while building callback path.", (Throwable)e);
        }
    }

    public String getRelyingPartyId() {
        return null;
    }

    public String getRelyingPartyId(IdentityMessageContext context) {
        return null;
    }

    public int getPriority() {
        return 1;
    }
}

