/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.logout.processor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkLogoutResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkRuntimeException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityMessageContext;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authentication.framework.inbound.InboundUtil;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationRequest;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.SAMLSSOException;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.context.SAMLMessageContext;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.dao.SessionInfoDAO;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.exception.SAMLLogoutException;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.request.SAMLLogoutRequest;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.util.SAMLLogoutUtil;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.validators.LogoutRequestValidator;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class SAMLLogoutRequestProcessor
extends IdentityProcessor {
    private static final Log log = LogFactory.getLog(SAMLLogoutRequestProcessor.class);

    public boolean canHandle(IdentityRequest identityRequest) {
        return identityRequest instanceof SAMLLogoutRequest;
    }

    public FrameworkLogoutResponse.FrameworkLogoutResponseBuilder process(IdentityRequest identityRequest) throws SAMLLogoutException {
        SAMLMessageContext<String, String> samlMessageContext = new SAMLMessageContext<String, String>(identityRequest, new HashMap());
        try {
            XMLObject samlRequest = samlMessageContext.getSAMLLogoutRequest().isPost() ? SSOUtils.unmarshall(SSOUtils.decodeForPost(identityRequest.getParameter("SAMLRequest"))) : SSOUtils.unmarshall(SSOUtils.decode(identityRequest.getParameter("SAMLRequest")));
            if (!(samlRequest instanceof LogoutRequest)) {
                samlMessageContext.setValidStatus(false);
                throw new SAMLLogoutException("Invalid Single Logout SAML Request");
            }
            LogoutRequest logoutRequest = (LogoutRequest)samlRequest;
            samlMessageContext.setValidStatus(true);
            samlMessageContext.setIdPSessionID(SAMLLogoutUtil.getSessionIndex(logoutRequest));
            if (StringUtils.isNotBlank((String)samlMessageContext.getIdPSessionID())) {
                this.populateContextWithSessionDetails(samlMessageContext);
            }
            if (!Boolean.parseBoolean(samlMessageContext.getFedIdPConfigs().get("IsSLORequestAccepted"))) {
                throw new SAMLLogoutException("Single logout requests from the federated IdP: " + samlMessageContext.getFederatedIdP().getIdentityProviderName() + " are not accepted");
            }
            LogoutRequestValidator logoutRequestValidator = new LogoutRequestValidator(samlMessageContext);
            if (logoutRequestValidator.isValidate(logoutRequest)) {
                LogoutResponse logoutResp = SAMLLogoutUtil.buildResponse(samlMessageContext, logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success", null);
                samlMessageContext.setResponse(SSOUtils.encode(SSOUtils.marshall((XMLObject)logoutResp)));
                samlMessageContext.setAcsUrl(logoutResp.getDestination());
            }
            return this.buildResponseForFrameworkLogout(samlMessageContext);
        }
        catch (SAMLSSOException e) {
            throw new SAMLLogoutException("Error when processing the Logout Request.", (Throwable)((Object)e));
        }
    }

    private FrameworkLogoutResponse.FrameworkLogoutResponseBuilder buildResponseForFrameworkLogout(SAMLMessageContext<String, String> samlMessageContext) {
        String commonAuthURL;
        IdentityRequest identityRequest = samlMessageContext.getRequest();
        Map parameterMap = identityRequest.getParameterMap();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.appendRequestQueryParams(parameterMap);
        if (identityRequest.getHeaderMap() != null) {
            identityRequest.getHeaderMap().forEach((arg_0, arg_1) -> ((AuthenticationRequest)authenticationRequest).addHeader(arg_0, arg_1));
        }
        authenticationRequest.setTenantDomain(samlMessageContext.getTenantDomain());
        authenticationRequest.setRelyingParty(this.getRelyingPartyId(samlMessageContext));
        authenticationRequest.setType(this.getType(samlMessageContext));
        try {
            authenticationRequest.setCommonAuthCallerPath(URLEncoder.encode(this.getCallbackPath(samlMessageContext), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw FrameworkRuntimeException.error((String)("Error occurred while URL encoding callback path: " + this.getCallbackPath(samlMessageContext)), (Throwable)e);
        }
        authenticationRequest.addRequestQueryParam("commonAuthLogout", new String[]{"true"});
        authenticationRequest.addRequestQueryParam("sessionId", new String[]{samlMessageContext.getSessionID()});
        AuthenticationRequestCacheEntry authRequest = new AuthenticationRequestCacheEntry(authenticationRequest);
        String sessionDataKey = UUIDGenerator.generateUUID();
        authRequest.setValidityPeriod(TimeUnit.MINUTES.toNanos(IdentityUtil.getOperationCleanUpTimeout()));
        FrameworkUtils.addAuthenticationRequestToCache((String)sessionDataKey, (AuthenticationRequestCacheEntry)authRequest);
        InboundUtil.addContextToCache((String)sessionDataKey, samlMessageContext);
        FrameworkLogoutResponse.FrameworkLogoutResponseBuilder responseBuilder = new FrameworkLogoutResponse.FrameworkLogoutResponseBuilder(samlMessageContext);
        responseBuilder.setContextKey(sessionDataKey);
        responseBuilder.setCallbackPath(this.getCallbackPath(samlMessageContext));
        responseBuilder.setAuthType(this.getType(samlMessageContext));
        try {
            commonAuthURL = ServiceURLBuilder.create().addPath(new String[]{"commonauth"}).build().getAbsolutePublicURL();
        }
        catch (URLBuilderException e) {
            throw FrameworkRuntimeException.error((String)"Error while building commonauth URL.", (Throwable)e);
        }
        responseBuilder.setRedirectURL(commonAuthURL);
        return responseBuilder;
    }

    private void populateContextWithSessionDetails(SAMLMessageContext<String, String> samlMessageContext) throws SAMLLogoutException {
        SessionInfoDAO sessionInfoDAO = new SessionInfoDAO();
        Map<String, String> sessionDetails = sessionInfoDAO.getSessionDetails(samlMessageContext.getIdPSessionID());
        if (sessionDetails != null) {
            if (StringUtils.isNotBlank((String)samlMessageContext.getSAMLLogoutRequest().getTenantDomain())) {
                samlMessageContext.setTenantDomain(samlMessageContext.getSAMLLogoutRequest().getTenantDomain());
            } else {
                samlMessageContext.setTenantDomain("carbon.super");
            }
            IdentityProvider identityProvider = null;
            try {
                identityProvider = IdentityProviderManager.getInstance().getIdPByName(sessionDetails.get("idpName"), samlMessageContext.getTenantDomain());
            }
            catch (IdentityProviderManagementException e) {
                throw new SAMLLogoutException("Error when getting the Identity Provider by IdP name: " + sessionDetails.get("idpName") + "with tenant domain: " + samlMessageContext.getTenantDomain(), e);
            }
            samlMessageContext.setSessionID(sessionDetails.get("sessionId"));
            samlMessageContext.setFederatedIdP(identityProvider);
            samlMessageContext.setFedIdPConfigs(SAMLLogoutUtil.getFederatedIdPConfigs(identityProvider));
        }
    }

    public String getType(IdentityMessageContext context) {
        return "samlsso";
    }

    public String getCallbackPath(IdentityMessageContext context) {
        try {
            return ServiceURLBuilder.create().addPath(new String[]{"identity/saml/slo"}).build().getAbsolutePublicURL();
        }
        catch (URLBuilderException e) {
            throw FrameworkRuntimeException.error((String)"Error while building callback path.", (Throwable)e);
        }
    }

    public String getRelyingPartyId() {
        return null;
    }

    public String getRelyingPartyId(IdentityMessageContext context) {
        return null;
    }
}

