/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityRequestFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.authenticator.samlsso.SAMLSSOAuthenticator;
import org.wso2.carbon.identity.application.authenticator.samlsso.internal.SAMLSSOAuthenticatorServiceDataHolder;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.processor.SAMLLogoutRequestProcessor;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.processor.SAMLLogoutResponseProcessor;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.request.SAMLLogoutRequestFactory;
import org.wso2.carbon.identity.application.authenticator.samlsso.logout.response.SAMLLogoutResponseFactory;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;

@Component(name="identity.application.authenticator.samlsso.component", immediate=true)
public class SAMLSSOAuthenticatorServiceComponent {
    private static final Log log = LogFactory.getLog(SAMLSSOAuthenticatorServiceComponent.class);
    private static String postPage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Activate
    protected void activate(ComponentContext ctxt) {
        String postPagePath = null;
        FileInputStream fis = null;
        try {
            SAMLSSOAuthenticator samlSSOAuthenticator = new SAMLSSOAuthenticator();
            ctxt.getBundleContext().registerService(ApplicationAuthenticator.class.getName(), (Object)samlSSOAuthenticator, null);
            ctxt.getBundleContext().registerService(HttpIdentityRequestFactory.class.getName(), (Object)new SAMLLogoutRequestFactory(), null);
            ctxt.getBundleContext().registerService(HttpIdentityResponseFactory.class.getName(), (Object)new SAMLLogoutResponseFactory(), null);
            ctxt.getBundleContext().registerService(IdentityProcessor.class.getName(), (Object)new SAMLLogoutRequestProcessor(), null);
            ctxt.getBundleContext().registerService(IdentityProcessor.class.getName(), (Object)new SAMLLogoutResponseProcessor(), null);
            postPagePath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "identity" + File.separator + "pages" + File.separator + "samlsso_federate.html";
            fis = new FileInputStream(new File(postPagePath));
            postPage = new Scanner((InputStream)fis, "UTF-8").useDelimiter("\\A").next();
            if (log.isDebugEnabled()) {
                log.info((Object)"SAML2 SSO Authenticator bundle is activated");
            }
            IdentityIOStreamUtils.closeInputStream((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to find SAMLSSO POST page for federation in " + postPagePath));
            }
        }
        catch (Throwable e2) {
            block10: {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)("Failed SAMLSSO authentication" + e2));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            IdentityIOStreamUtils.closeInputStream(fis);
        }
        finally {
            IdentityIOStreamUtils.closeInputStream(fis);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.info((Object)"SAML2 SSO Authenticator bundle is deactivated");
        }
    }

    @Reference(name="RealmService", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is set in the SAML2 SSO Authenticator bundle");
        }
        SAMLSSOAuthenticatorServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is unset in the SAML2 SSO Authenticator bundle");
        }
        SAMLSSOAuthenticatorServiceDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="ServerConfigurationService", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Set the ServerConfiguration Service");
        }
        SAMLSSOAuthenticatorServiceDataHolder.getInstance().setServerConfigurationService(serverConfigurationService);
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unset the ServerConfiguration Service");
        }
        SAMLSSOAuthenticatorServiceDataHolder.getInstance().setServerConfigurationService(null);
    }

    public static String getPostPage() {
        return postPage;
    }
}

