/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso.artifact;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.ArtifactResolutionException;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class SAMLSSOSoapMessageService {
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final Log log = LogFactory.getLog(SAMLSSOSoapMessageService.class);

    public Envelope buildSOAPMessage(SAMLObject samlMessage) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SOAPObjectBuilder envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envBuilder.buildObject();
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(samlMessage);
        envelope.setBody(body);
        return envelope;
    }

    public String sendSOAP(String message, String url, HttpHost proxy) throws ArtifactResolutionException {
        StringBuilder soapResponse = new StringBuilder();
        try {
            CloseableHttpClient httpClient;
            CloseableHttpResponse httpResponse;
            int responseCode;
            HttpPost httpPost = new HttpPost(url);
            this.setRequestProperties(url, message, httpPost);
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            SSLContext sslContext = this.getSSLContext(CarbonUtils.getServerConfiguration());
            if (sslContext != null) {
                httpClientBuilder.setSslcontext(sslContext);
                if (proxy != null) {
                    httpClientBuilder.setProxy(proxy);
                }
            }
            if ((responseCode = (httpResponse = (httpClient = httpClientBuilder.build()).execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
                throw new ArtifactResolutionException("Problem in communicating with: " + url + ". Received response: " + responseCode);
            }
            log.info((Object)("Successful response from the URL: " + url));
            soapResponse.append(SAMLSSOSoapMessageService.getResponseBody((HttpResponse)httpResponse));
        }
        catch (UnknownHostException e1) {
            throw new ArtifactResolutionException("Unknown targeted host: " + url, e1);
        }
        catch (IOException e2) {
            throw new ArtifactResolutionException("Could not open connection with host: " + url, e2);
        }
        catch (GeneralSecurityException e3) {
            throw new ArtifactResolutionException("Error in creating SSL context: " + e3);
        }
        return soapResponse.toString();
    }

    private SSLContext getSSLContext(ServerConfiguration serverConfig) throws GeneralSecurityException {
        SSLContext sslContext = null;
        if (serverConfig != null) {
            String keyStorePath = serverConfig.getFirstProperty("Security.KeyStore.Location");
            String keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
            String keyStoreType = serverConfig.getFirstProperty("Security.KeyStore.Type");
            char[] kspassphrase = keyStorePassword.toCharArray();
            sslContext = SSLContext.getInstance("TLS");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore keyStore = SSOUtils.loadKeyStoreFromFileSystem(keyStorePath, keyStorePassword, keyStoreType);
            keyManagerFactory.init(keyStore, kspassphrase);
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created SSL Context using keystore: " + keyStorePath + " and keyStorePassword: " + keyStorePassword));
            }
        }
        return sslContext;
    }

    private void setRequestProperties(String url, String message, HttpPost httpPost) {
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("Accept", CONTENT_TYPE);
        String sbSOAPAction = "\"" + url + "\"";
        httpPost.addHeader("SOAPAction", sbSOAPAction);
        httpPost.addHeader("Pragma", "no-cache");
        httpPost.addHeader("Cache-Control", "no-cache, no-store");
        httpPost.setEntity((HttpEntity)new StringEntity(message, ContentType.create((String)CONTENT_TYPE)));
    }

    private static String getResponseBody(HttpResponse response) throws ArtifactResolutionException {
        String responseBody;
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            responseBody = (String)responseHandler.handleResponse(response);
        }
        catch (IOException e) {
            throw new ArtifactResolutionException("Error when retrieving the HTTP response body.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response Body:" + responseBody));
        }
        return responseBody;
    }
}

