/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.samlsso;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.encoder.Encode;
import org.wso2.carbon.identity.application.authentication.framework.AbstractApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStateInfo;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationContextProperty;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authenticator.samlsso.exception.SAMLSSOException;
import org.wso2.carbon.identity.application.authenticator.samlsso.internal.SAMLSSOAuthenticatorServiceComponent;
import org.wso2.carbon.identity.application.authenticator.samlsso.manager.DefaultSAML2SSOManager;
import org.wso2.carbon.identity.application.authenticator.samlsso.manager.SAML2SSOManager;
import org.wso2.carbon.identity.application.authenticator.samlsso.model.StateInfo;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOErrorConstants;
import org.wso2.carbon.identity.application.authenticator.samlsso.util.SSOUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.SubProperty;

public class SAMLSSOAuthenticator
extends AbstractApplicationAuthenticator
implements FederatedApplicationAuthenticator {
    private static final long serialVersionUID = -8097512332218044859L;
    public static final String AS_REQUEST = "AS_REQUEST";
    public static final String AUTHENTICATION_CONTEXT = "AUTHENTICATION_CONTEXT";
    private static final String AS_RESPONSE = "AS_RESPONSE";
    private static final String AUTH_PARAM = "$authparam";
    private static final String DYNAMIC_AUTH_PARAMS_LOOKUP_REGEX = "\\$authparam\\{(\\w+)}";
    private static final Pattern authParamDynamicQueryPattern = Pattern.compile("\\$authparam\\{(\\w+)}");
    private static final Log log = LogFactory.getLog(SAMLSSOAuthenticator.class);

    public boolean canHandle(HttpServletRequest request) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Inside canHandle()");
        }
        return request.getParameter("SAMLResponse") != null || request.getParameter("SAMLart") != null;
    }

    protected void initiateAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
        Map authenticatorProperties = context.getAuthenticatorProperties();
        String idpURL = (String)authenticatorProperties.get("SSOUrl");
        boolean isPost = false;
        try {
            String requestMethod = (String)authenticatorProperties.get("RequestMethod");
            if (requestMethod != null && requestMethod.trim().length() != 0) {
                if ("POST".equalsIgnoreCase(requestMethod)) {
                    isPost = true;
                } else if (AS_REQUEST.equalsIgnoreCase(requestMethod)) {
                    isPost = context.getAuthenticationRequest().isPost();
                }
            }
            this.resolveDynamicParameter(request, context);
            if (isPost) {
                this.sendPostRequest(request, response, false, idpURL, context);
            } else {
                SAML2SSOManager saml2SSOManager = this.getSAML2SSOManagerInstance();
                saml2SSOManager.init(context.getTenantDomain(), context.getAuthenticatorProperties(), context.getExternalIdP().getIdentityProvider());
                String ssoUrl = saml2SSOManager.buildRequest(request, false, false, idpURL, context);
                this.generateAuthenticationRequest(request, response, ssoUrl, authenticatorProperties);
            }
        }
        catch (SAMLSSOException e) {
            throw new AuthenticationFailedException(e.getErrorCode(), e.getMessage(), (Throwable)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationFailedException(SSOErrorConstants.ErrorMessages.UNSUPPORTED_ENCODING_EXCEPTION.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    private void resolveDynamicParameter(HttpServletRequest request, AuthenticationContext context) throws UnsupportedEncodingException {
        String queryParameters = (String)context.getAuthenticatorProperties().get("commonAuthQueryParams");
        if (queryParameters != null) {
            context.getAuthenticatorProperties().put("commonAuthQueryParams", this.getResolvedQueryParams(request, context, queryParameters));
        }
    }

    private String getResolvedQueryParams(HttpServletRequest request, AuthenticationContext context, String queryParamString) throws UnsupportedEncodingException {
        Map<String, String> queryMap = SSOUtils.getQueryMap(queryParamString);
        StringBuilder queryBuilder = new StringBuilder();
        for (Map.Entry<String, String> queryParamEntry : queryMap.entrySet()) {
            String resolvedQueryParamValue = this.getResolvedQueryParamValue(request, context, queryParamEntry);
            if (queryBuilder.length() > 0) {
                queryBuilder.append('&');
            }
            queryBuilder.append(URLEncoder.encode(queryParamEntry.getKey(), StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(resolvedQueryParamValue, StandardCharsets.UTF_8.name()));
        }
        return queryBuilder.toString();
    }

    private String getResolvedQueryParamValue(HttpServletRequest request, AuthenticationContext context, Map.Entry<String, String> queryParam) {
        Object resolvedQueryParamValue = queryParam.getValue();
        if (this.isDynamicQueryParam((String)resolvedQueryParamValue)) {
            String inboundQueryParamKey = this.removeEnclosingParenthesis((String)resolvedQueryParamValue);
            Object[] authRequestParamValues = context.getAuthenticationRequest().getRequestQueryParam(inboundQueryParamKey);
            String currentRequestParamValue = request.getParameter(inboundQueryParamKey);
            resolvedQueryParamValue = ArrayUtils.isNotEmpty((Object[])authRequestParamValues) ? authRequestParamValues[0] : (StringUtils.isNotBlank((String)currentRequestParamValue) ? currentRequestParamValue : "");
        } else if (this.isDynamicAuthContextParam((String)resolvedQueryParamValue)) {
            Matcher matcher = authParamDynamicQueryPattern.matcher((CharSequence)resolvedQueryParamValue);
            if (matcher.find()) {
                String paramName = matcher.group(1);
                String valueFromRuntimeParams = (String)this.getRuntimeParams(context).get(paramName);
                if (StringUtils.isNotEmpty((String)valueFromRuntimeParams)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(queryParam.getKey() + "=" + queryParam.getValue() + " was replaced as " + queryParam.getKey() + "=" + valueFromRuntimeParams));
                    }
                    return valueFromRuntimeParams;
                }
            }
            return "";
        }
        return resolvedQueryParamValue;
    }

    private boolean isDynamicAuthContextParam(String resolvedQueryParamValue) {
        return StringUtils.startsWith((String)resolvedQueryParamValue, (String)AUTH_PARAM);
    }

    private String removeEnclosingParenthesis(String queryParamValue) {
        if (this.isEnclosedWithParenthesis(queryParamValue)) {
            return queryParamValue.substring(1, queryParamValue.length() - 1);
        }
        return queryParamValue;
    }

    private boolean isDynamicQueryParam(String queryParamValue) {
        return this.isEnclosedWithParenthesis(queryParamValue) && queryParamValue.length() > 2;
    }

    private boolean isEnclosedWithParenthesis(String queryParamValue) {
        return StringUtils.startsWith((String)queryParamValue, (String)"{") && StringUtils.endsWith((String)queryParamValue, (String)"}");
    }

    private void generateAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, String ssoUrl, Map<String, String> authenticatorProperties) throws AuthenticationFailedException {
        try {
            String queryString;
            String domain = request.getParameter("domain");
            if (domain != null) {
                ssoUrl = ssoUrl + "&fidp=" + domain;
            }
            if (authenticatorProperties != null && (queryString = authenticatorProperties.get("commonAuthQueryParams")) != null) {
                ssoUrl = !queryString.startsWith("&") ? ssoUrl + "&" + queryString : ssoUrl + queryString;
            }
            response.sendRedirect(ssoUrl);
        }
        catch (IOException e) {
            throw new AuthenticationFailedException(SSOErrorConstants.ErrorMessages.IO_ERROR.getCode(), "Error while sending the redirect to federated SAML IdP.", (Throwable)e);
        }
    }

    protected void processAuthenticationResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
        String subject = null;
        try {
            SAML2SSOManager saml2SSOManager = this.getSAML2SSOManagerInstance();
            saml2SSOManager.init(context.getTenantDomain(), context.getAuthenticatorProperties(), context.getExternalIdP().getIdentityProvider());
            request.setAttribute(AUTHENTICATION_CONTEXT, (Object)context);
            saml2SSOManager.processResponse(request);
            Map receivedClaims = (Map)request.getSession(false).getAttribute("samlssoAttributes");
            String isSubjectInClaimsProp = (String)context.getAuthenticatorProperties().get("IsUserIdInClaims");
            if ("true".equalsIgnoreCase(isSubjectInClaimsProp) && (subject = FrameworkUtils.getFederatedSubjectFromClaims((IdentityProvider)context.getExternalIdP().getIdentityProvider(), (Map)receivedClaims)) == null) {
                log.warn((Object)"Subject claim could not be found amongst attribute statements. Defaulting to Name Identifier.");
            }
            if (subject == null) {
                subject = (String)request.getSession().getAttribute("username");
            }
            if (StringUtils.isBlank(subject)) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.FEDERATED_USER_IDENTIFIER_NOT_FOUND.getCode(), SSOErrorConstants.ErrorMessages.FEDERATED_USER_IDENTIFIER_NOT_FOUND.getMessage());
            }
            Object sessionIndexObj = request.getSession(false).getAttribute("IdPSession");
            String nameQualifier = (String)request.getSession().getAttribute("nameQualifier");
            String spNameQualifier = (String)request.getSession().getAttribute("spNameQualifier");
            String sessionIndex = null;
            if (sessionIndexObj != null) {
                sessionIndex = (String)sessionIndexObj;
            }
            StateInfo stateInfoDO = new StateInfo();
            stateInfoDO.setSessionIndex(sessionIndex);
            stateInfoDO.setSubject(subject);
            stateInfoDO.setNameQualifier(nameQualifier);
            stateInfoDO.setSpNameQualifier(spNameQualifier);
            context.setStateInfo((AuthenticatorStateInfo)stateInfoDO);
            context.setProperty("FederatedIdPSessionIndex_" + context.getExternalIdP().getIdentityProvider().getIdentityProviderName(), (Object)sessionIndex);
            if (AS_RESPONSE.equalsIgnoreCase((String)context.getAuthenticatorProperties().get("ResponseAuthnContextClassRef"))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AuthnContextClassRefs received with SAML response from the IdP '" + context.getExternalIdP().getIdPName() + "' is passed to service provider."));
                }
                if (request.getSession().getAttribute("AuthnContextClassRef") != null) {
                    List<AuthenticationContextProperty> authenticationContextProperties;
                    AuthenticationContextProperty authenticationContextProperty = new AuthenticationContextProperty(context.getExternalIdP().getIdPName(), "AuthnContextClassRef", request.getSession().getAttribute("AuthnContextClassRef"));
                    if (context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES") != null) {
                        authenticationContextProperties = (List)context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES");
                    } else {
                        authenticationContextProperties = new ArrayList();
                        context.setProperty("AUTHENTICATION_CONTEXT_PROPERTIES", authenticationContextProperties);
                    }
                    authenticationContextProperties.add(authenticationContextProperty);
                }
            }
            AuthenticatedUser authenticatedUser = AuthenticatedUser.createFederateAuthenticatedUserFromSubjectIdentifier((String)subject);
            authenticatedUser.setUserAttributes(receivedClaims);
            context.setSubject(authenticatedUser);
        }
        catch (SAMLSSOException e) {
            throw new AuthenticationFailedException(e.getErrorCode(), e.getMessage(), (Throwable)((Object)e));
        }
        finally {
            request.removeAttribute(AUTHENTICATION_CONTEXT);
        }
    }

    public String getContextIdentifier(HttpServletRequest request) {
        String identifier;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Inside getContextIdentifier()");
        }
        if ((identifier = request.getParameter("sessionDataKey")) == null && (identifier = request.getParameter("RelayState")) != null) {
            try {
                return URLDecoder.decode(identifier, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Exception while URL decoding the Relay State", (Throwable)e);
            }
        }
        return identifier;
    }

    public String getFriendlyName() {
        return "samlsso";
    }

    public String getName() {
        return "SAMLSSOAuthenticator";
    }

    protected void initiateLogoutRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws LogoutFailedException {
        boolean logoutEnabled = false;
        String logoutEnabledProp = (String)context.getAuthenticatorProperties().get("IsLogoutEnabled");
        logoutEnabled = Boolean.parseBoolean(logoutEnabledProp);
        if (logoutEnabled) {
            String idpLogoutURL = (String)context.getAuthenticatorProperties().get("LogoutReqUrl");
            if (StringUtils.isBlank((String)idpLogoutURL)) {
                idpLogoutURL = (String)context.getAuthenticatorProperties().get("SSOUrl");
            }
            if (StringUtils.isBlank((String)idpLogoutURL)) {
                throw new LogoutFailedException("Logout is enabled for the IdP but Logout URL is not configured");
            }
            AuthenticatorStateInfo stateInfo = context.getStateInfo();
            if (stateInfo instanceof StateInfo) {
                request.getSession().setAttribute("logoutSessionIndex", (Object)((StateInfo)stateInfo).getSessionIndex());
                request.getSession().setAttribute("logoutUsername", (Object)((StateInfo)stateInfo).getSubject());
                request.getSession().setAttribute("nameQualifier", (Object)((StateInfo)stateInfo).getNameQualifier());
                request.getSession().setAttribute("spNameQualifier", (Object)((StateInfo)stateInfo).getSpNameQualifier());
            }
            try {
                SAML2SSOManager saml2SSOManager = this.getSAML2SSOManagerInstance();
                saml2SSOManager.init(context.getTenantDomain(), context.getAuthenticatorProperties(), context.getExternalIdP().getIdentityProvider());
                boolean isPost = false;
                Map authenticatorProperties = context.getAuthenticatorProperties();
                String requestMethod = (String)authenticatorProperties.get("RequestMethod");
                if (requestMethod != null && requestMethod.trim().length() != 0) {
                    if ("POST".equalsIgnoreCase(requestMethod)) {
                        isPost = true;
                    } else if (AS_REQUEST.equalsIgnoreCase(requestMethod)) {
                        isPost = context.getAuthenticationRequest().isPost();
                    }
                }
                if (isPost) {
                    this.sendPostRequest(request, response, true, idpLogoutURL, context);
                }
                String logoutURL = saml2SSOManager.buildRequest(request, true, false, idpLogoutURL, context);
                response.sendRedirect(logoutURL);
            }
            catch (IOException | SAMLSSOException e) {
                throw new LogoutFailedException(((Throwable)e).getMessage(), (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected void processLogoutResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        throw new UnsupportedOperationException();
    }

    public List<Property> getConfigurationProperties() {
        ArrayList<Property> configProperties = new ArrayList<Property>();
        Property spEntityId = new Property();
        spEntityId.setName("SPEntityId");
        spEntityId.setDisplayName("Service Provider Entity ID");
        spEntityId.setRequired(true);
        spEntityId.setDescription("Enter the service provider's entity identifier value");
        spEntityId.setType("string");
        spEntityId.setDisplayOrder(1);
        configProperties.add(spEntityId);
        Property nameIdFormat = new Property();
        nameIdFormat.setName("NameIDType");
        nameIdFormat.setDisplayName("NameID format");
        nameIdFormat.setRequired(true);
        nameIdFormat.setDescription("NameID format to be used in the SAML request");
        nameIdFormat.setType("string");
        nameIdFormat.setDisplayOrder(2);
        nameIdFormat.setDefaultValue("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        configProperties.add(nameIdFormat);
        Property selectMode = new Property();
        selectMode.setName("selectMode");
        selectMode.setDisplayName("Select Mode");
        selectMode.setDescription("Select the input method for SAML configuration");
        selectMode.setType("string");
        selectMode.setOptions(new String[]{"Manual Configuration", "Metadata File Configuration"});
        selectMode.setDefaultValue("Manual Configuration");
        selectMode.setDisplayOrder(3);
        configProperties.add(selectMode);
        Property samlMetadata = new Property();
        samlMetadata.setName("meta_data_saml");
        samlMetadata.setDisplayName("SAML Metadata File");
        samlMetadata.setDescription("Base-64 encoded metadata file content for SAML configuration");
        samlMetadata.setType("string");
        samlMetadata.setDisplayOrder(4);
        configProperties.add(samlMetadata);
        Property idpEntityId = new Property();
        idpEntityId.setName("IdPEntityId");
        idpEntityId.setDisplayName("Identity Provider Entity ID");
        idpEntityId.setRequired(true);
        idpEntityId.setDescription("Enter identity provider's entity identifier value. This should be a valid URI/URL.");
        idpEntityId.setType("string");
        idpEntityId.setDisplayOrder(5);
        configProperties.add(idpEntityId);
        Property ssoUrl = new Property();
        ssoUrl.setName("SSOUrl");
        ssoUrl.setDisplayName("SSO URL");
        ssoUrl.setRequired(true);
        ssoUrl.setDescription("Enter identity provider's SAML2 Web SSO URL value");
        ssoUrl.setType("string");
        ssoUrl.setDisplayOrder(6);
        configProperties.add(ssoUrl);
        Property acsUrl = new Property();
        acsUrl.setName("ACSUrl");
        acsUrl.setDisplayName("ACS URL");
        acsUrl.setRequired(false);
        acsUrl.setDescription("Enter service provider's SAML2 ACS URL value");
        acsUrl.setType("string");
        acsUrl.setDisplayOrder(7);
        configProperties.add(acsUrl);
        Property authnReqSign = new Property();
        authnReqSign.setName("ISAuthnReqSigned");
        authnReqSign.setDisplayName("Enable Authentication Request Signing");
        authnReqSign.setRequired(false);
        authnReqSign.setDescription("Specifies if the SAML2 authentication request to the identity provider must be signed or not");
        authnReqSign.setType("boolean");
        authnReqSign.setDisplayOrder(8);
        configProperties.add(authnReqSign);
        Property assertionEncryption = new Property();
        assertionEncryption.setName("IsAssertionEncrypted");
        assertionEncryption.setDisplayName("Enable Assertion Encryption");
        assertionEncryption.setRequired(false);
        assertionEncryption.setDescription("Specify if SAMLAssertion element is encrypted");
        assertionEncryption.setType("boolean");
        assertionEncryption.setDisplayOrder(9);
        configProperties.add(assertionEncryption);
        Property assertionSigning = new Property();
        assertionSigning.setName("isAssertionSigned");
        assertionSigning.setDisplayName("Enable Assertion Signing");
        assertionSigning.setRequired(false);
        assertionSigning.setDescription("Specify if SAMLAssertion element is signed");
        assertionSigning.setType("boolean");
        assertionSigning.setDisplayOrder(10);
        configProperties.add(assertionSigning);
        Property enableLogout = new Property();
        enableLogout.setName("IsLogoutEnabled");
        enableLogout.setDisplayName("Enable Logout");
        enableLogout.setRequired(false);
        enableLogout.setDescription("Specifies if logout/single Logout is enabled for this identity provider");
        enableLogout.setType("boolean");
        enableLogout.setDisplayOrder(11);
        configProperties.add(enableLogout);
        Property sloRequestAccepted = new Property();
        sloRequestAccepted.setName("IsSLORequestAccepted");
        sloRequestAccepted.setDisplayName("Enable Logout Request Accepting");
        sloRequestAccepted.setRequired(false);
        sloRequestAccepted.setDescription("Specifies if single logout request from the identity provider is accepted");
        sloRequestAccepted.setType("boolean");
        sloRequestAccepted.setDisplayOrder(12);
        configProperties.add(sloRequestAccepted);
        Property logoutUrl = new Property();
        logoutUrl.setName("LogoutReqUrl");
        logoutUrl.setDisplayName("Logout Url");
        logoutUrl.setRequired(false);
        logoutUrl.setDescription("Enter identity provider's logout URL value if it is different from the SSO Url");
        logoutUrl.setType("string");
        logoutUrl.setDisplayOrder(13);
        configProperties.add(logoutUrl);
        Property logoutReqSign = new Property();
        logoutReqSign.setName("IsLogoutReqSigned");
        logoutReqSign.setDisplayName("Enable Logout Request Signing");
        logoutReqSign.setRequired(false);
        logoutReqSign.setDescription("Specifies if SAML2 logout request to the identity provider must be signed or not");
        logoutReqSign.setType("boolean");
        logoutReqSign.setDisplayOrder(14);
        configProperties.add(logoutReqSign);
        Property authnResSign = new Property();
        authnResSign.setName("IsAuthnRespSigned");
        authnResSign.setDisplayName("Enable Authentication Response Signing");
        authnResSign.setRequired(false);
        authnResSign.setDescription("Specifies if SAML2 authentication response from the identity provider must be signed or not");
        authnResSign.setType("boolean");
        authnResSign.setDisplayOrder(15);
        configProperties.add(authnResSign);
        Property enableArtifactBinding = new Property();
        enableArtifactBinding.setName("ISArtifactBindingEnabled");
        enableArtifactBinding.setDisplayName(" Enable Artifact Binding");
        enableArtifactBinding.setRequired(false);
        enableArtifactBinding.setDescription("Specifies if SAML2 Artifact Binding is enabled from IDP");
        enableArtifactBinding.setType("boolean");
        enableArtifactBinding.setDisplayOrder(16);
        SubProperty artifactResolveUrl = new SubProperty();
        artifactResolveUrl.setName("ArtifactResolveUrl");
        artifactResolveUrl.setDisplayName("Artifact Resolve Endpoint Url");
        artifactResolveUrl.setRequired(false);
        artifactResolveUrl.setDescription("Specify the Artifact Resolve Endpoint Url");
        artifactResolveUrl.setType("string");
        artifactResolveUrl.setDisplayOrder(17);
        SubProperty artifactResolveReqSign = new SubProperty();
        artifactResolveReqSign.setName("ISArtifactResolveReqSigned");
        artifactResolveReqSign.setDisplayName("Enable Artifact Resolve Request Signing");
        artifactResolveReqSign.setRequired(false);
        artifactResolveReqSign.setDescription(" Specifies if the SAML2 artifact resolve request to the identity provider must be signed or not");
        artifactResolveReqSign.setType("boolean");
        artifactResolveReqSign.setDisplayOrder(18);
        SubProperty enableArtifactResSign = new SubProperty();
        enableArtifactResSign.setName("ISArtifactResponseSigned");
        enableArtifactResSign.setDisplayName("Enable Artifact Response Signing");
        enableArtifactResSign.setRequired(false);
        enableArtifactResSign.setDescription("Specifies if the SAML2 artifact response from the identity provider will be signed or not");
        enableArtifactResSign.setType("boolean");
        enableArtifactResSign.setDisplayOrder(19);
        SubProperty[] enableArtifactBindingSubProps = new SubProperty[]{artifactResolveUrl, artifactResolveReqSign, enableArtifactResSign};
        enableArtifactBinding.setSubProperties(enableArtifactBindingSubProps);
        configProperties.add(enableArtifactBinding);
        Property signatureAlgo = new Property();
        signatureAlgo.setName("SignatureAlgorithm");
        signatureAlgo.setDisplayName("Signature Algorithm");
        signatureAlgo.setRequired(false);
        signatureAlgo.setDescription("Specifies the SignatureMethod Algorithm");
        signatureAlgo.setType("string");
        signatureAlgo.setDisplayOrder(20);
        ArrayList<String> signatureAlgoOptions = new ArrayList<String>();
        signatureAlgoOptions.add("DSA with SHA1");
        signatureAlgoOptions.add("RSA with SHA1");
        signatureAlgoOptions.add("ECDSA with SHA1");
        signatureAlgoOptions.add("ECDSA with SHA256");
        signatureAlgoOptions.add("ECDSA with SHA384");
        signatureAlgoOptions.add("ECDSA with SHA512");
        signatureAlgoOptions.add("RSA with MD5");
        signatureAlgoOptions.add("RSA with RIPEMD160");
        signatureAlgoOptions.add("RSA with SHA256");
        signatureAlgoOptions.add("RSA with SHA384");
        signatureAlgoOptions.add("RSA with SHA512");
        signatureAlgo.setOptions(signatureAlgoOptions.toArray(new String[0]));
        signatureAlgo.setDefaultValue("RSA with SHA1");
        configProperties.add(signatureAlgo);
        Property digestAlgo = new Property();
        digestAlgo.setName("DigestAlgorithm");
        digestAlgo.setDisplayName("Digest Algorithm");
        digestAlgo.setRequired(false);
        digestAlgo.setDescription("Specifies the DigestMethod Algorithm. Applicable only in POST Binding");
        digestAlgo.setType("string");
        digestAlgo.setDisplayOrder(21);
        ArrayList<String> digestAlgoOptions = new ArrayList<String>();
        digestAlgoOptions.add("MD5");
        digestAlgoOptions.add("RIPEMD160");
        digestAlgoOptions.add("SHA1");
        digestAlgoOptions.add("SHA256");
        digestAlgoOptions.add("SHA384");
        digestAlgoOptions.add("SHA512");
        digestAlgo.setOptions(digestAlgoOptions.toArray(new String[0]));
        digestAlgo.setDefaultValue("SHA1");
        configProperties.add(digestAlgo);
        Property attributeConsumeIndex = new Property();
        attributeConsumeIndex.setName("AttributeConsumingServiceIndex");
        attributeConsumeIndex.setDisplayName("Attribute Consuming Service Index");
        attributeConsumeIndex.setRequired(false);
        attributeConsumeIndex.setDescription("Specify the Attribute Consuming Service Index");
        attributeConsumeIndex.setType("string");
        attributeConsumeIndex.setDisplayOrder(22);
        configProperties.add(attributeConsumeIndex);
        Property forceAuthn = new Property();
        forceAuthn.setName("ForceAuthentication");
        forceAuthn.setDisplayName("Enable Force Authentication");
        forceAuthn.setRequired(false);
        forceAuthn.setDescription("Enable force authentication or decide from the in coming request");
        forceAuthn.setType("string");
        forceAuthn.setDisplayOrder(23);
        forceAuthn.setOptions(new String[]{"yes", "no", "as_request"});
        forceAuthn.setDefaultValue("as_request");
        configProperties.add(forceAuthn);
        Property includeCert = new Property();
        includeCert.setName("IncludeCert");
        includeCert.setDisplayName(" Include Public Certificate");
        includeCert.setRequired(false);
        includeCert.setDescription("Include Public Certificate in the the request");
        includeCert.setType("boolean");
        includeCert.setDisplayOrder(24);
        configProperties.add(includeCert);
        Property includeProtocolBinding = new Property();
        includeProtocolBinding.setName("IncludeProtocolBinding");
        includeProtocolBinding.setDisplayName(" Include Protocol Binding");
        includeProtocolBinding.setRequired(false);
        includeProtocolBinding.setDescription("Include ProtocolBinding in the request");
        includeProtocolBinding.setType("boolean");
        includeProtocolBinding.setDisplayOrder(25);
        configProperties.add(includeProtocolBinding);
        Property includeNameIdPolicy = new Property();
        includeNameIdPolicy.setName("IncludeNameIDPolicy");
        includeNameIdPolicy.setDisplayName(" Include NameID Policy");
        includeNameIdPolicy.setRequired(false);
        includeNameIdPolicy.setDescription("Include NameIDPolicy in the request");
        includeNameIdPolicy.setType("boolean");
        includeNameIdPolicy.setDisplayOrder(26);
        configProperties.add(includeNameIdPolicy);
        Property includeAuthnContext = new Property();
        includeAuthnContext.setName("IncludeAuthnContext");
        includeAuthnContext.setDisplayName(" Include Authentication Context");
        includeAuthnContext.setRequired(false);
        includeAuthnContext.setDescription("Include a new RequestedAuthnContext in the request, or decide from the incoming request");
        includeAuthnContext.setType("string");
        includeAuthnContext.setDisplayOrder(27);
        includeAuthnContext.setOptions(new String[]{"yes", "no", "as_request"});
        includeAuthnContext.setDefaultValue("yes");
        configProperties.add(includeAuthnContext);
        Property authnContextClass = new Property();
        authnContextClass.setName("AuthnContextClassRef");
        authnContextClass.setDisplayName("Authentication Context Class");
        authnContextClass.setRequired(false);
        authnContextClass.setDescription(" Choose AuthnContextClassRef to be sent");
        authnContextClass.setType("string");
        ArrayList<String> authnContextOptions = new ArrayList<String>();
        authnContextOptions.add("Telephony (Authenticated)");
        authnContextOptions.add("Internet Protocol");
        authnContextOptions.add("Internet Protocol Password");
        authnContextOptions.add("Kerberos");
        authnContextOptions.add("Mobile One Factor Contract");
        authnContextOptions.add("Mobile One Factor Unregistered");
        authnContextOptions.add("Mobile Two Factor Contract");
        authnContextOptions.add("Mobile Two Factor Unregistered");
        authnContextOptions.add("Telephony (Nomadic)");
        authnContextOptions.add("Password");
        authnContextOptions.add("Password Protected Transport");
        authnContextOptions.add("Telephony (Personalized)");
        authnContextOptions.add("Public Key - PGP");
        authnContextOptions.add("Previous Session");
        authnContextOptions.add("Secure Remote Password");
        authnContextOptions.add("Smartcard");
        authnContextOptions.add("Smartcard PKI");
        authnContextOptions.add("Software PKI");
        authnContextOptions.add("Public Key - SPKI");
        authnContextOptions.add("Telephony");
        authnContextOptions.add("Time Sync Token");
        authnContextOptions.add("SSL/TLS Certificate-Based Client Authentication");
        authnContextOptions.add("Unspecified");
        authnContextOptions.add("Public Key - X.509");
        authnContextOptions.add("Public Key - XML Digital Signature");
        authnContextOptions.add("Custom Authentication Context Class");
        authnContextClass.setOptions(authnContextOptions.toArray(new String[0]));
        authnContextClass.setDefaultValue("Unspecified");
        authnContextClass.setDisplayOrder(28);
        configProperties.add(authnContextClass);
        Property customAuthnContextClass = new Property();
        customAuthnContextClass.setName("CustomAuthnContextClassRef");
        customAuthnContextClass.setDisplayName(null);
        customAuthnContextClass.setRequired(false);
        customAuthnContextClass.setDescription("Custom AuthnContextClassRef to be sent");
        customAuthnContextClass.setType("string");
        customAuthnContextClass.setDisplayOrder(29);
        configProperties.add(customAuthnContextClass);
        Property authnContextComparison = new Property();
        authnContextComparison.setName("AuthnContextComparisonLevel");
        authnContextComparison.setDisplayName("Authentication Context Comparison Level");
        authnContextComparison.setRequired(false);
        authnContextComparison.setDescription("Choose RequestedAuthnContext Comparison to be sent");
        authnContextComparison.setType("string");
        authnContextComparison.setDisplayOrder(30);
        authnContextComparison.setOptions(new String[]{"Exact", "Mininum", "Maximum", "Better"});
        authnContextComparison.setDefaultValue("Exact");
        configProperties.add(authnContextComparison);
        Property userIdLocation = new Property();
        userIdLocation.setName("IsUserIdInClaims");
        userIdLocation.setDisplayName("SAML2 Web SSO User ID Location");
        userIdLocation.setRequired(false);
        userIdLocation.setDescription("Specifies the location to find the user identifier in the SAML2 assertion");
        userIdLocation.setType("boolean");
        userIdLocation.setDisplayOrder(31);
        userIdLocation.setDefaultValue("false");
        configProperties.add(userIdLocation);
        Property httpBinding = new Property();
        httpBinding.setName("RequestMethod");
        httpBinding.setDisplayName("HTTP Binding");
        httpBinding.setRequired(false);
        httpBinding.setDescription("Choose the HTTP Binding or decide from incoming request");
        httpBinding.setType("string");
        httpBinding.setDisplayOrder(32);
        httpBinding.setOptions(new String[]{"redirect", "post", "as_request"});
        httpBinding.setDefaultValue("redirect");
        configProperties.add(httpBinding);
        Property resAuthnContextClass = new Property();
        resAuthnContextClass.setName("ResponseAuthnContextClassRef");
        resAuthnContextClass.setDisplayName("Response Authentication Context Class");
        resAuthnContextClass.setRequired(false);
        resAuthnContextClass.setDescription("Choose the AuthnContextClassRef sent back to the service provider");
        resAuthnContextClass.setType("string");
        resAuthnContextClass.setDisplayOrder(33);
        resAuthnContextClass.setOptions(new String[]{"default", "as_response"});
        resAuthnContextClass.setDefaultValue("default");
        configProperties.add(resAuthnContextClass);
        Property queryParams = new Property();
        queryParams.setName("commonAuthQueryParams");
        queryParams.setDisplayName("Additional Query Parameters");
        queryParams.setRequired(false);
        queryParams.setDescription("Additional query parameters. e.g: paramName1=value1");
        queryParams.setType("string");
        queryParams.setDisplayOrder(34);
        configProperties.add(queryParams);
        Property signatureAlgorithmPost = new Property();
        signatureAlgorithmPost.setName("SignatureAlgorithmPost");
        signatureAlgorithmPost.setDisplayName(null);
        signatureAlgorithmPost.setRequired(false);
        signatureAlgorithmPost.setDescription(null);
        signatureAlgorithmPost.setType("string");
        signatureAlgorithmPost.setDisplayOrder(0);
        configProperties.add(signatureAlgorithmPost);
        return configProperties;
    }

    private void sendPostRequest(HttpServletRequest request, HttpServletResponse response, boolean isLogout, String loginPage, AuthenticationContext context) throws SAMLSSOException {
        SAML2SSOManager saml2SSOManager = this.getSAML2SSOManagerInstance();
        saml2SSOManager.init(context.getTenantDomain(), context.getAuthenticatorProperties(), context.getExternalIdP().getIdentityProvider());
        if (!(saml2SSOManager instanceof DefaultSAML2SSOManager)) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.HTTP_POST_NOT_SUPPORTED.getCode(), SSOErrorConstants.ErrorMessages.HTTP_POST_NOT_SUPPORTED.getMessage());
        }
        String encodedRequest = ((DefaultSAML2SSOManager)saml2SSOManager).buildPostRequest(request, isLogout, false, loginPage, context);
        String relayState = context.getContextIdentifier();
        Map<String, String> reqParamMap = this.getAdditionalRequestParams(request, context);
        String postPageInputs = this.buildPostPageInputs(encodedRequest, relayState, reqParamMap);
        this.printPostPage(response, loginPage, postPageInputs);
    }

    private SAML2SSOManager getSAML2SSOManagerInstance() throws SAMLSSOException {
        String managerClassName = (String)this.getAuthenticatorConfig().getParameterMap().get("SAML2SSOManager");
        if (managerClassName != null) {
            try {
                Class<?> clazz = Class.forName(managerClassName);
                return (SAML2SSOManager)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.CLASS_NOT_FOUND_EXCEPTION.getCode(), e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.INSTANTIATION_FAILED.getCode(), e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.ILLEGAL_ACCESS.getCode(), e.getMessage(), e);
            }
        }
        return new DefaultSAML2SSOManager();
    }

    private String buildPostPageInputs(String encodedRequest, String relayState, Map<String, String> reqParamMap) throws SAMLSSOException {
        StringBuilder hiddenInputBuilder = new StringBuilder("");
        hiddenInputBuilder.append("<input type='hidden' name='SAMLRequest' value='").append(encodedRequest).append("'>");
        if (relayState != null) {
            hiddenInputBuilder.append("<input type='hidden' name='RelayState' value='").append(relayState).append("'>");
        }
        for (Map.Entry<String, String> reqParam : reqParamMap.entrySet()) {
            String paramValue;
            String paramName = reqParam.getKey();
            try {
                paramValue = URLDecoder.decode(reqParam.getValue(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new SAMLSSOException("Error while building POST request.", e);
            }
            hiddenInputBuilder.append("<input type='hidden' name='").append(Encode.forHtmlAttribute((String)paramName)).append("' value='").append(Encode.forHtmlAttribute((String)paramValue)).append("'>");
        }
        return hiddenInputBuilder.toString();
    }

    private Map<String, String> getAdditionalRequestParams(HttpServletRequest request, AuthenticationContext context) {
        String fidp;
        String queryString;
        Map<String, String> reqParamMap = new HashMap<String, String>();
        Map authenticatorProperties = context.getAuthenticatorProperties();
        if (authenticatorProperties != null && (queryString = (String)authenticatorProperties.get("commonAuthQueryParams")) != null) {
            reqParamMap = SSOUtils.getQueryMap(queryString);
        }
        if ((fidp = request.getParameter("domain")) != null) {
            reqParamMap.put("fidp", Encode.forHtmlAttribute((String)fidp));
        }
        return reqParamMap;
    }

    private void printPostPage(HttpServletResponse response, String url, String postPageInputs) throws SAMLSSOException {
        try {
            String postPage = SAMLSSOAuthenticatorServiceComponent.getPostPage();
            response.setContentType("text/html; charset=UTF-8");
            if (postPage != null) {
                String pageWithURL = postPage.replace("$url", Encode.forHtmlAttribute((String)url));
                String finalPage = pageWithURL.replace("<!--$params-->", postPageInputs);
                PrintWriter out = response.getWriter();
                out.print(finalPage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HTTP-POST page: " + finalPage));
                }
            } else {
                PrintWriter out = response.getWriter();
                out.println("<html>");
                out.println("<body>");
                out.println("<p>You are now redirected to " + Encode.forHtml((String)url));
                out.println(" If the redirection fails, please click the post button.</p>");
                out.println("<form method='post' action='" + Encode.forHtmlAttribute((String)url) + "'>");
                out.println("<p>");
                out.println(postPageInputs);
                out.println("<button type='submit'>POST</button>");
                out.println("</p>");
                out.println("</form>");
                out.println("<script type='text/javascript'>");
                out.println("document.forms[0].submit();");
                out.println("</script>");
                out.println("</body>");
                out.println("</html>");
            }
        }
        catch (Exception e) {
            throw new SAMLSSOException(SSOErrorConstants.ErrorMessages.IO_ERROR.getCode(), "Error while sending POST request", e);
        }
    }
}

