/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.ui.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.PIICategory;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.consent.mgt.core.model.PurposePIICategory;
import org.wso2.carbon.consent.mgt.core.util.LambdaExceptionUtils;
import org.wso2.carbon.consent.mgt.ui.dto.PurposeRequestDTO;
import org.wso2.carbon.consent.mgt.ui.internal.ConsentManagementUIServiceDataHolder;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;

public class ConsentManagementServiceClient {
    private String loggedInUser;

    public ConsentManagementServiceClient(String loggedInUser) {
        this.loggedInUser = loggedInUser;
    }

    public Purpose[] listPurposes() throws ConsentManagementException {
        List purposes = this.getConsentManager().listPurposes(0, 0);
        return purposes.toArray(new Purpose[purposes.size()]);
    }

    public Purpose[] listPurposes(String purposeGroupName, String purposeGroupType) throws ConsentManagementException {
        List purposes = this.getConsentManager().listPurposes(purposeGroupName, purposeGroupType, 0, 0);
        return purposes.toArray(new Purpose[purposes.size()]);
    }

    public Purpose getPurpose(int purposeId) throws ConsentManagementException {
        return this.getConsentManager().getPurpose(purposeId);
    }

    public void deletePurpose(int purposeId) throws ConsentManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/consentmgt/delete");
        this.getConsentManager().deletePurpose(purposeId);
    }

    public void deletePurposeByName(String purposeName, String group, String groupType) throws ConsentManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/consentmgt/delete");
        Purpose purposeByName = this.getConsentManager().getPurposeByName(purposeName, group, groupType);
        this.deletePurpose(purposeByName.getId());
    }

    public void addPurpose(PurposeRequestDTO purposeRequestDTO) throws ConsentManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/consentmgt/add");
        Purpose purpose = new Purpose(purposeRequestDTO.getPurpose(), purposeRequestDTO.getDescription(), purposeRequestDTO.getGroup(), purposeRequestDTO.getGroupType());
        ArrayList piiCategories = new ArrayList();
        purposeRequestDTO.getPiiCategories().forEach(LambdaExceptionUtils.rethrowConsumer(piiCategoryDTO -> {
            if (this.getConsentManager().isPIICategoryExists(piiCategoryDTO.getName())) {
                PIICategory piiCategoryId = this.getConsentManager().getPIICategoryByName(piiCategoryDTO.getName());
                boolean isPiiCategoryAdded = false;
                for (PurposePIICategory purposePIICategory : piiCategories) {
                    if (!purposePIICategory.getId().equals(piiCategoryId.getId())) continue;
                    isPiiCategoryAdded = true;
                    break;
                }
                if (!isPiiCategoryAdded) {
                    piiCategories.add(new PurposePIICategory(piiCategoryId.getId(), Boolean.valueOf(piiCategoryDTO.isMandatory())));
                }
            } else {
                PIICategory piiCategory = new PIICategory(piiCategoryDTO.getName(), piiCategoryDTO.getDescription(), Boolean.valueOf(true), piiCategoryDTO.getDisplayName());
                PIICategory piiCategoryResponse = this.getConsentManager().addPIICategory(piiCategory);
                boolean isPiiCategoryAdded = false;
                for (PurposePIICategory purposePIICategory : piiCategories) {
                    if (!purposePIICategory.getId().equals(piiCategoryResponse.getId())) continue;
                    isPiiCategoryAdded = true;
                    break;
                }
                if (!isPiiCategoryAdded) {
                    piiCategories.add(new PurposePIICategory(piiCategoryResponse.getId(), Boolean.valueOf(piiCategoryDTO.isMandatory())));
                }
            }
        }));
        purpose.setPurposePIICategories(piiCategories);
        this.getConsentManager().addPurpose(purpose);
    }

    private void handleLoggedInUserAuthorization(String permission) throws ConsentManagementException {
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (StringUtils.isBlank((String)this.loggedInUser)) {
                throw new ConsentManagementException(ConsentConstants.ErrorMessages.ERROR_CODE_NO_AUTH_USER_FOUND.getMessage(), ConsentConstants.ErrorMessages.ERROR_CODE_NO_AUTH_USER_FOUND.getCode());
            }
            AuthorizationManager authorizationManager = ConsentManagementUIServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            if (!authorizationManager.isUserAuthorized(this.loggedInUser, permission, "ui.execute")) {
                throw new ConsentManagementException(ConsentConstants.ErrorMessages.ERROR_CODE_USER_NOT_AUTHORIZED.getMessage(), ConsentConstants.ErrorMessages.ERROR_CODE_USER_NOT_AUTHORIZED.getCode());
            }
        }
        catch (UserStoreException e) {
            throw new ConsentManagementException(ConsentConstants.ErrorMessages.ERROR_CODE_UNEXPECTED.getMessage(), ConsentConstants.ErrorMessages.ERROR_CODE_UNEXPECTED.getCode());
        }
    }

    private ConsentManager getConsentManager() {
        return ConsentManagementUIServiceDataHolder.getInstance().getConsentManager();
    }
}

