/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.client;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.TermData;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.service.TermsSearchService;
import org.wso2.carbon.registry.indexing.stub.generated.ArrayOfString;
import org.wso2.carbon.registry.indexing.stub.generated.ContentSearchAdminServiceStub;
import org.wso2.carbon.registry.indexing.stub.generated.xsd.SearchResultsBean;

public class WSRegistrySearchClient {
    private static final Log log = LogFactory.getLog(WSRegistrySearchClient.class);
    private String cookie;
    private String epr;
    private ContentSearchAdminServiceStub stub;
    protected static int count;

    public static int getCount() {
        return count;
    }

    public String authenticate(ConfigurationContext ctx, String serverURL, String username, String password) throws AxisFault, AuthenticationException {
        String serviceEPR = serverURL + "AuthenticationAdmin";
        String cookie = null;
        AuthenticationAdminStub stub = new AuthenticationAdminStub(ctx, serviceEPR);
        ServiceClient client = stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        try {
            boolean result = stub.login(username, password, new URL(serviceEPR).getHost());
            if (result) {
                return (String)stub._getServiceClient().getServiceContext().getProperty("Cookie");
            }
            return cookie;
        }
        catch (Exception e) {
            String msg = "Error occurred while logging in";
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    public void init(final String cookie, final String serverURL, final ConfigurationContext configContext) throws RegistryException {
        GovernanceUtils.setAttributeSearchService((AttributeSearchService)new AttributeSearchService(){

            public ResourceData[] search(UserRegistry userRegistry, Map<String, String> stringStringMap) throws RegistryException {
                throw new UnsupportedOperationException();
            }

            public ResourceData[] search(int i, Map<String, String> stringStringMap) throws RegistryException {
                throw new UnsupportedOperationException();
            }

            public ResourceData[] search(Map<String, String> stringStringMap) throws RegistryException {
                ContentSearchAdminServiceStub stub = null;
                ArrayList<ResourceData> resourceDataList = new ArrayList<ResourceData>();
                ArrayList<ArrayOfString> arrayOfStringList = new ArrayList<ArrayOfString>();
                try {
                    for (Map.Entry<String, String> map : stringStringMap.entrySet()) {
                        ArrayOfString arrayOfString = new ArrayOfString();
                        arrayOfString.setArray(new String[]{map.getKey(), map.getValue()});
                        arrayOfStringList.add(arrayOfString);
                    }
                    WSRegistrySearchClient.this.epr = serverURL + "ContentSearchAdminService";
                    try {
                        stub = new ContentSearchAdminServiceStub(configContext, WSRegistrySearchClient.this.epr);
                        ServiceClient client = stub._getServiceClient();
                        Options options = client.getOptions();
                        options.setManageSession(true);
                        options.setProperty("Cookie", (Object)cookie);
                        stub._getServiceClient().getOptions().setProperty("enableMTOM", (Object)"true");
                        stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(1000000L);
                        if (PaginationContext.getInstance() != null) {
                            PaginationUtils.copyPaginationContext((ServiceClient)stub._getServiceClient());
                        }
                    }
                    catch (Exception axisFault) {
                        String msg = "Failed to initiate WSRegistrySearchClient. " + axisFault.getMessage();
                        log.error((Object)msg, (Throwable)axisFault);
                        throw new RegistryException(msg, (Throwable)axisFault);
                    }
                    SearchResultsBean searchResultsBean = stub.getAttributeSearchResults(arrayOfStringList.toArray(new ArrayOfString[arrayOfStringList.size()]));
                    org.wso2.carbon.registry.indexing.stub.generated.xsd.ResourceData[] resourceDatas = searchResultsBean.getResourceDataList();
                    if (resourceDatas != null && resourceDatas.length > 0) {
                        for (ResourceData resourceData : resourceDatas) {
                            ResourceData resourceData2 = new ResourceData();
                            resourceData2.setAbsent(resourceData.getAbsent());
                            resourceData2.setAuthorUserName(resourceData.getAuthorUserName());
                            resourceData2.setAverageRating(resourceData.getAverageRating());
                            resourceData2.setAverageStars(resourceData.getAverageStars());
                            resourceData2.setCreatedOn(resourceData.getCreatedOn());
                            resourceData2.setDeleteAllowed(resourceData.isDeleteAllowedSpecified());
                            resourceData2.setDescription(resourceData.getDescription());
                            resourceData2.setExternalLink(resourceData.getExternalLink());
                            resourceData2.setGetAllowed(resourceData.getGetAllowed());
                            resourceData2.setLink(resourceData.getLink());
                            resourceData2.setMounted(resourceData.isMountedSpecified());
                            resourceData2.setName(resourceData.getName());
                            resourceData2.setDeleteAllowed(resourceData.getDeleteAllowed());
                            resourceData2.setResourceType(resourceData.getResourceType());
                            resourceData2.setResourcePath(resourceData.getResourcePath());
                            resourceData2.setRealPath(resourceData.getRealPath());
                            resourceData2.setPutAllowed(resourceData.getPutAllowed());
                            resourceDataList.add(resourceData2);
                        }
                    } else {
                        ResourceData[] resourceDataArray = new ResourceData[]{};
                        return resourceDataArray;
                    }
                    count = PaginationUtils.getRowCount((ServiceClient)stub._getServiceClient());
                }
                catch (RemoteException e) {
                    String msg = "Failed to get results";
                    log.error((Object)"Failed to get results ", (Throwable)e);
                    throw new RegistryException(msg, (Throwable)e);
                }
                finally {
                    if (stub != null) {
                        try {
                            stub._getServiceClient().cleanupTransport();
                        }
                        catch (AxisFault axisFault) {
                            log.warn((Object)"failed to cleanup transport");
                        }
                    }
                }
                return resourceDataList.toArray(new ResourceData[resourceDataList.size()]);
            }
        });
        GovernanceUtils.setTermsSearchService((TermsSearchService)new TermsSearchService(){

            public TermData[] search(UserRegistry userRegistry, Map<String, String> stringStringMap) throws RegistryException {
                throw new UnsupportedOperationException();
            }

            public TermData[] search(int i, Map<String, String> stringStringMap) throws RegistryException {
                throw new UnsupportedOperationException();
            }

            public TermData[] search(Map<String, String> stringStringMap) throws RegistryException {
                ArrayList<TermData> termDataList;
                block18: {
                    ContentSearchAdminServiceStub contentSearchAdminServiceStub = null;
                    termDataList = new ArrayList<TermData>();
                    ArrayList<ArrayOfString> arrayOfStringList = new ArrayList<ArrayOfString>();
                    try {
                        for (Map.Entry<String, String> map : stringStringMap.entrySet()) {
                            ArrayOfString arrayOfString = new ArrayOfString();
                            arrayOfString.setArray(new String[]{map.getKey(), map.getValue()});
                            arrayOfStringList.add(arrayOfString);
                        }
                        WSRegistrySearchClient.this.epr = serverURL + "ContentSearchAdminService";
                        try {
                            contentSearchAdminServiceStub = new ContentSearchAdminServiceStub(configContext, WSRegistrySearchClient.this.epr);
                            ServiceClient client = contentSearchAdminServiceStub._getServiceClient();
                            Options options = client.getOptions();
                            options.setManageSession(true);
                            options.setProperty("Cookie", (Object)cookie);
                            contentSearchAdminServiceStub._getServiceClient().getOptions().setProperty("enableMTOM", (Object)"true");
                            contentSearchAdminServiceStub._getServiceClient().getOptions().setTimeOutInMilliSeconds(1000000L);
                            if (PaginationContext.getInstance() != null) {
                                PaginationUtils.copyPaginationContext((ServiceClient)contentSearchAdminServiceStub._getServiceClient());
                            }
                        }
                        catch (Exception axisFault) {
                            String msg = "Failed to initiate WSRegistrySearchClient. " + axisFault.getMessage();
                            log.error((Object)msg, (Throwable)axisFault);
                            throw new RegistryException(msg, (Throwable)axisFault);
                        }
                        SearchResultsBean searchResultsBean = contentSearchAdminServiceStub.getTermSearchResults(arrayOfStringList.toArray(new ArrayOfString[arrayOfStringList.size()]));
                        org.wso2.carbon.registry.indexing.stub.generated.xsd.TermData[] termDatas = searchResultsBean.getTermDataList();
                        if (termDatas != null && termDatas.length > 0) {
                            for (TermData termData : termDatas) {
                                TermData termData2 = new TermData(termData.getTerm(), termData.getFrequency());
                                termDataList.add(termData2);
                            }
                            break block18;
                        }
                        TermData[] termDataArray = new TermData[]{};
                        return termDataArray;
                    }
                    catch (RemoteException e) {
                        throw new RegistryException("Failed to get results", (Throwable)e);
                    }
                    finally {
                        if (contentSearchAdminServiceStub != null) {
                            try {
                                contentSearchAdminServiceStub._getServiceClient().cleanupTransport();
                            }
                            catch (AxisFault axisFault) {
                                log.warn((Object)"failed to cleanup transport", (Throwable)axisFault);
                            }
                        }
                    }
                }
                return termDataList.toArray(new TermData[termDataList.size()]);
            }
        });
    }
}

