/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound;

import java.util.Map;
import org.apache.synapse.inbound.InboundEndpoint;
import org.wso2.carbon.inbound.ParameterDTO;

public class InboundEndpointDTO {
    private String name;
    private String protocol;
    private String classImpl;
    private boolean isSuspend;
    private String injectingSeq;
    private String onErrorSeq;
    private ParameterDTO[] parameters;
    private String fileName;
    private String artifactContainerName;
    private boolean isEdited;
    private boolean isStatisticsEnable;
    private boolean isTracingEnable;

    public InboundEndpointDTO(InboundEndpoint inboundEndpoint) {
        this.name = inboundEndpoint.getName();
        this.protocol = inboundEndpoint.getProtocol();
        this.classImpl = inboundEndpoint.getClassImpl();
        this.isSuspend = inboundEndpoint.isSuspend();
        this.injectingSeq = inboundEndpoint.getInjectingSeq();
        this.onErrorSeq = inboundEndpoint.getOnErrorSeq();
        this.fileName = inboundEndpoint.getFileName();
        this.artifactContainerName = inboundEndpoint.getArtifactContainerName();
        this.isEdited = inboundEndpoint.getIsEdited();
        this.isStatisticsEnable = inboundEndpoint.getAspectConfiguration() != null && inboundEndpoint.getAspectConfiguration().isStatisticsEnable();
        this.isTracingEnable = inboundEndpoint.getAspectConfiguration() != null && inboundEndpoint.getAspectConfiguration().isTracingEnabled();
        Map mParams = inboundEndpoint.getParametersMap();
        if (mParams != null && !mParams.isEmpty()) {
            this.parameters = new ParameterDTO[mParams.keySet().size()];
            int i = 0;
            for (String strKey : mParams.keySet()) {
                ParameterDTO parameterDTO = new ParameterDTO();
                parameterDTO.setName(strKey);
                parameterDTO.setValue((String)mParams.get(strKey));
                parameterDTO.setKey(inboundEndpoint.getParameterKey(strKey));
                this.parameters[i++] = parameterDTO;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getClassImpl() {
        return this.classImpl;
    }

    public void setClassImpl(String classImpl) {
        this.classImpl = classImpl;
    }

    public boolean isSuspend() {
        return this.isSuspend;
    }

    public void setSuspend(boolean isSuspend) {
        this.isSuspend = isSuspend;
    }

    public String getInjectingSeq() {
        return this.injectingSeq;
    }

    public void setInjectingSeq(String injectingSeq) {
        this.injectingSeq = injectingSeq;
    }

    public String getOnErrorSeq() {
        return this.onErrorSeq;
    }

    public void setOnErrorSeq(String onErrorSeq) {
        this.onErrorSeq = onErrorSeq;
    }

    public ParameterDTO[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ParameterDTO[] parameters) {
        this.parameters = parameters;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean getIsEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public void setArtifactContainerName(String artifactContainerName) {
        this.artifactContainerName = artifactContainerName;
    }

    public void setStatisticsEnable(boolean enableStatistics) {
        this.isStatisticsEnable = enableStatistics;
    }

    public boolean getStatisticsEnable() {
        return this.isStatisticsEnable;
    }

    public boolean getTracingEnable() {
        return this.isTracingEnable;
    }

    public void setTracingEnable(boolean tracingEnable) {
        this.isTracingEnable = tracingEnable;
    }
}

