/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound;

import java.io.StringReader;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.inbound.InboundEndpoint;
import org.wso2.carbon.inbound.InboundEndpointDTO;
import org.wso2.carbon.inbound.InboundManagementException;
import org.wso2.carbon.inbound.ParameterDTO;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;

public class CarbonInboundManagementService
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(CarbonInboundManagementService.class);

    public InboundEndpointDTO[] getAllInboundEndpointNames() throws InboundManagementException {
        Collection inboundEndpoints = this.getSynapseConfiguration().getInboundEndpoints();
        InboundEndpointDTO[] lInboundEndpoints = new InboundEndpointDTO[inboundEndpoints.size()];
        int i = 0;
        for (InboundEndpoint inboundEndpoint : inboundEndpoints) {
            lInboundEndpoints[i++] = new InboundEndpointDTO(inboundEndpoint);
        }
        return lInboundEndpoints;
    }

    public InboundEndpointDTO getInboundEndpointbyName(String endointName) throws InboundManagementException {
        InboundEndpoint inboundEndpoint = this.getInboundEndpoint(endointName);
        if (inboundEndpoint != null) {
            return new InboundEndpointDTO(inboundEndpoint);
        }
        return null;
    }

    public void addInboundEndpoint(String name, String sequence, String onError, String protocol, String classImpl, String suspend, ParameterDTO[] lParameterDTOs) throws InboundManagementException {
        try {
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
            OMElement elem = fac.createOMElement("inboundEndpoint", omNs);
            elem.addAttribute(fac.createOMAttribute("name", null, name));
            if (sequence != null && sequence != "") {
                elem.addAttribute(fac.createOMAttribute("sequence", null, sequence));
            }
            elem.addAttribute(fac.createOMAttribute("suspend", null, suspend));
            if (onError != null && onError != "") {
                elem.addAttribute(fac.createOMAttribute("onError", null, onError));
            }
            if (protocol != null) {
                elem.addAttribute(fac.createOMAttribute("protocol", null, protocol));
            } else {
                elem.addAttribute(fac.createOMAttribute("class", null, classImpl));
            }
            OMElement params = fac.createOMElement("parameters", omNs);
            for (ParameterDTO parameterDTO : lParameterDTOs) {
                OMElement param = fac.createOMElement("parameter", omNs);
                param.addAttribute(fac.createOMAttribute("name", null, parameterDTO.getName()));
                if (parameterDTO.getKey() != null) {
                    param.addAttribute(fac.createOMAttribute("key", null, parameterDTO.getKey()));
                } else if (parameterDTO.getValue() != null) {
                    param.setText(parameterDTO.getValue());
                }
                params.addChild((OMNode)param);
            }
            elem.addChild((OMNode)params);
            SynapseXMLConfigurationFactory.defineInboundEndpoint((SynapseConfiguration)synapseConfiguration, (OMElement)elem, (Properties)synapseConfiguration.getProperties());
            InboundEndpoint inboundEndpoint = this.getInboundEndpoint(name);
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                this.persistInboundEndpoint(inboundEndpoint);
            }
            inboundEndpoint.init(this.getSynapseEnvironment());
        }
        catch (Exception ex) {
            log.error((Object)"Error adding inbound Endpoint", (Throwable)ex);
            this.removeInboundEndpoint(name);
            throw ex;
        }
    }

    public void addInboundEndpointFromXMLString(String inboundElement) {
        XMLStreamReader reader = null;
        try {
            reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(inboundElement));
        }
        catch (XMLStreamException e) {
            log.error((Object)e.getMessage());
        }
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement omElement = builder.getDocumentElement();
        SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
        SynapseXMLConfigurationFactory.defineInboundEndpoint((SynapseConfiguration)synapseConfiguration, (OMElement)omElement, (Properties)synapseConfiguration.getProperties());
        String name = omElement.getAttributeValue(new QName("name"));
        InboundEndpoint inboundEndpoint = null;
        try {
            inboundEndpoint = this.getInboundEndpoint(name);
        }
        catch (InboundManagementException e) {
            log.error((Object)e.getMessage());
        }
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.persistInboundEndpoint(inboundEndpoint);
        }
        inboundEndpoint.init(this.getSynapseEnvironment());
    }

    public void updateInboundEndpoint(String name, String sequence, String onError, String protocol, String classImpl, String suspend, ParameterDTO[] lParameterDTOs) throws InboundManagementException {
        SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
        OMElement elem = fac.createOMElement("inboundEndpoint", omNs);
        elem.addAttribute(fac.createOMAttribute("name", null, name));
        if (sequence != null && sequence != "") {
            elem.addAttribute(fac.createOMAttribute("sequence", null, sequence));
        }
        elem.addAttribute(fac.createOMAttribute("suspend", null, suspend));
        if (onError != null && onError != "") {
            elem.addAttribute(fac.createOMAttribute("onError", null, onError));
        }
        if (protocol != null) {
            elem.addAttribute(fac.createOMAttribute("protocol", null, protocol));
        } else {
            elem.addAttribute(fac.createOMAttribute("class", null, classImpl));
        }
        OMElement params = fac.createOMElement("parameters", omNs);
        for (ParameterDTO lParameterDTO : lParameterDTOs) {
            OMElement param = fac.createOMElement("parameter", omNs);
            param.addAttribute(fac.createOMAttribute("name", null, lParameterDTO.getName()));
            if (lParameterDTO.getKey() != null) {
                param.addAttribute(fac.createOMAttribute("key", null, lParameterDTO.getKey()));
            } else if (lParameterDTO.getValue() != null) {
                param.setText(lParameterDTO.getValue());
            }
            params.addChild((OMNode)param);
        }
        elem.addChild((OMNode)params);
        InboundEndpoint oldInboundEndpoint = synapseConfiguration.getInboundEndpoint(name);
        if (oldInboundEndpoint != null) {
            oldInboundEndpoint.destroy();
            synapseConfiguration.removeInboundEndpoint(name);
        }
        SynapseXMLConfigurationFactory.defineInboundEndpoint((SynapseConfiguration)synapseConfiguration, (OMElement)elem, (Properties)synapseConfiguration.getProperties());
        InboundEndpoint inboundEndpoint = this.getInboundEndpoint(name);
        if (oldInboundEndpoint.getArtifactContainerName() != null) {
            inboundEndpoint.setArtifactContainerName(oldInboundEndpoint.getArtifactContainerName());
            inboundEndpoint.setIsEdited(true);
        }
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.persistInboundEndpoint(inboundEndpoint);
        }
        try {
            inboundEndpoint.init(this.getSynapseEnvironment());
        }
        catch (Exception e) {
            inboundEndpoint.destroy();
            synapseConfiguration.removeInboundEndpoint(name);
            synapseConfiguration.addInboundEndpoint(oldInboundEndpoint.getName(), oldInboundEndpoint);
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                this.persistInboundEndpoint(oldInboundEndpoint);
            }
            oldInboundEndpoint.init(this.getSynapseEnvironment());
            throw e;
        }
    }

    public void removeInboundEndpoint(String name) throws InboundManagementException {
        try {
            SynapseConfiguration synapseConfiguration;
            InboundEndpoint inboundEndpoint;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting inbound service : " + name));
            }
            if ((inboundEndpoint = (synapseConfiguration = this.getSynapseConfiguration()).getInboundEndpoint(name)) != null && inboundEndpoint.getArtifactContainerName() == null) {
                synapseConfiguration.removeInboundEndpoint(name);
                inboundEndpoint.destroy();
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager pm = this.getMediationPersistenceManager();
                    pm.deleteItem(name, inboundEndpoint.getFileName(), 15);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inbound service : " + name + " deleted"));
                }
            } else if (inboundEndpoint.getArtifactContainerName() != null) {
                log.warn((Object)("Inbound service" + name + " deployed from artifact container. Will not be deleted."));
            } else {
                log.warn((Object)("No Inbound service exists by the name : " + name));
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to delete inbound service : " + name), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableStatistics(String inboundEndpointName) throws InboundManagementException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            InboundEndpoint inboundEndpoint = synapseConfiguration.getInboundEndpoint(inboundEndpointName);
            if (inboundEndpoint != null) {
                if (inboundEndpoint.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(inboundEndpointName);
                    config.enableStatistics();
                    inboundEndpoint.configure(config);
                } else {
                    inboundEndpoint.getAspectConfiguration().enableStatistics();
                }
                if (inboundEndpoint.getArtifactContainerName() == null && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    this.persistInboundEndpoint(inboundEndpoint);
                }
                String string = inboundEndpointName;
                return string;
            }
            this.handleException(log, "No defined Inbound Endpoint with name " + inboundEndpointName + " found to enable statistics in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't enable statistics of the Inbound Endpoint " + inboundEndpointName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableStatistics(String inboundEndpointName) throws InboundManagementException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            InboundEndpoint inboundEndpoint = synapseConfiguration.getInboundEndpoint(inboundEndpointName);
            if (inboundEndpoint != null) {
                if (inboundEndpoint.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(inboundEndpointName);
                    config.disableStatistics();
                    inboundEndpoint.configure(config);
                } else {
                    inboundEndpoint.getAspectConfiguration().disableStatistics();
                }
                if (inboundEndpoint.getArtifactContainerName() == null && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    this.persistInboundEndpoint(inboundEndpoint);
                }
                String string = inboundEndpointName;
                return string;
            }
            this.handleException(log, "No defined Inbound Endpoint with name " + inboundEndpointName + " found to disable statistics in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't disable statistics of the Inbound Endpoint " + inboundEndpointName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableTracing(String inboundEndpointName) throws InboundManagementException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            InboundEndpoint inboundEndpoint = synapseConfiguration.getInboundEndpoint(inboundEndpointName);
            if (inboundEndpoint != null) {
                if (inboundEndpoint.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(inboundEndpointName);
                    config.enableTracing();
                    config.enableStatistics();
                    inboundEndpoint.configure(config);
                } else {
                    inboundEndpoint.getAspectConfiguration().enableTracing();
                    inboundEndpoint.getAspectConfiguration().enableStatistics();
                }
                if (inboundEndpoint.getArtifactContainerName() == null && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    this.persistInboundEndpoint(inboundEndpoint);
                }
                String string = inboundEndpointName;
                return string;
            }
            this.handleException(log, "No defined Inbound Endpoint with name " + inboundEndpointName + " found to enable tracing in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't enable tracing of the Inbound Endpoint " + inboundEndpointName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableTracing(String inboundEndpointName) throws InboundManagementException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            InboundEndpoint inboundEndpoint = synapseConfiguration.getInboundEndpoint(inboundEndpointName);
            if (inboundEndpoint != null) {
                if (inboundEndpoint.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(inboundEndpointName);
                    config.disableTracing();
                    inboundEndpoint.configure(config);
                } else {
                    inboundEndpoint.getAspectConfiguration().disableTracing();
                }
                if (inboundEndpoint.getArtifactContainerName() == null && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    this.persistInboundEndpoint(inboundEndpoint);
                }
                String string = inboundEndpointName;
                return string;
            }
            this.handleException(log, "No defined Inbound Endpoint with name " + inboundEndpointName + " found to disable tracing in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't disable tracing of the Inbound Endpoint " + inboundEndpointName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    private void persistInboundEndpoint(InboundEndpoint inboundEndpoint) {
        MediationPersistenceManager pm = this.getMediationPersistenceManager();
        if (pm == null) {
            log.error((Object)"Cannot Persist sequence because persistence manager is null, probably persistence is disabled");
        } else if (inboundEndpoint.getArtifactContainerName() == null) {
            pm.saveItem(inboundEndpoint.getName(), 15);
        }
    }

    private InboundEndpoint getInboundEndpoint(String endointName) throws InboundManagementException {
        Collection inboundEndpoints = this.getSynapseConfiguration().getInboundEndpoints();
        for (InboundEndpoint inboundEndpoint : inboundEndpoints) {
            if (!endointName.equals(inboundEndpoint.getName())) continue;
            return inboundEndpoint;
        }
        return null;
    }

    private void handleException(Log log, String message, Exception e) throws InboundManagementException {
        if (e == null) {
            InboundManagementException inboundManagementException = new InboundManagementException(message);
            log.error((Object)message, (Throwable)inboundManagementException);
            throw inboundManagementException;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new InboundManagementException(message, e);
    }
}

