/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning.rules;

import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.wso2.balana.utils.exception.PolicyBuilderException;
import org.wso2.balana.utils.policy.PolicyBuilder;
import org.wso2.balana.utils.policy.dto.RequestElementDTO;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.common.dto.RequestDTO;
import org.wso2.carbon.identity.entitlement.common.dto.RowDTO;
import org.wso2.carbon.identity.entitlement.common.util.PolicyCreatorUtil;
import org.wso2.carbon.identity.provisioning.IdentityProvisioningException;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;
import org.wso2.carbon.identity.provisioning.ProvisioningOperation;
import org.wso2.carbon.identity.provisioning.internal.ProvisioningServiceDataHolder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XACMLBasedRuleHandler {
    private static final Log log = LogFactory.getLog(XACMLBasedRuleHandler.class);
    private static volatile XACMLBasedRuleHandler instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XACMLBasedRuleHandler getInstance() {
        if (instance != null) return instance;
        Class<XACMLBasedRuleHandler> clazz = XACMLBasedRuleHandler.class;
        synchronized (XACMLBasedRuleHandler.class) {
            if (instance != null) return instance;
            instance = new XACMLBasedRuleHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isAllowedToProvision(String tenantDomainName, ProvisioningEntity provisioningEntity, ServiceProvider serviceProvider, String idPName, String connectorType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In policy provisioning flow...");
        }
        try {
            Boolean isAuthorized;
            RequestDTO requestDTO = this.createRequestDTO(tenantDomainName, provisioningEntity, serviceProvider, idPName, connectorType);
            RequestElementDTO requestElementDTO = PolicyCreatorUtil.createRequestElementDTO((RequestDTO)requestDTO);
            String requestString = PolicyBuilder.getInstance().buildRequest(requestElementDTO);
            if (log.isDebugEnabled()) {
                log.debug((Object)("XACML request :\n" + requestString));
            }
            String responseString = ProvisioningServiceDataHolder.getInstance().getEntitlementService().getDecision(requestString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("XACML response :\n" + responseString));
            }
            if ((isAuthorized = Boolean.valueOf(this.evaluateXACMLResponse(responseString))).booleanValue()) {
                return true;
            }
        }
        catch (PolicyBuilderException e) {
            log.error((Object)"Policy Builder Exception occurred", (Throwable)e);
        }
        catch (EntitlementException e) {
            log.error((Object)"Entitlement Exception occurred", (Throwable)e);
        }
        catch (IdentityProvisioningException e) {
            log.error((Object)"Error when evaluating the XACML response", (Throwable)((Object)e));
        }
        return false;
    }

    private RequestDTO createRequestDTO(String tenantDomainName, ProvisioningEntity provisioningEntity, ServiceProvider serviceProvider, String idPName, String connectorType) {
        ArrayList<RowDTO> rowDTOs = new ArrayList<RowDTO>();
        RowDTO tenatDomainDTO = this.createRowDTO(tenantDomainName, "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/user/user-tenant-domain", "http://wso2.org/identity/user");
        RowDTO userDTO = this.createRowDTO(provisioningEntity.getEntityName(), "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/user/username", "http://wso2.org/identity/user");
        RowDTO spNameDTO = this.createRowDTO(serviceProvider.getApplicationName(), "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/sp/sp-name", "http://wso2.org/identity/sp");
        RowDTO spTenantDomainNameDTO = this.createRowDTO(serviceProvider.getOwner().getTenantDomain(), "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/auth/sp-tenant-domain", "http://wso2.org/identity/sp");
        RowDTO idpNameDTO = this.createRowDTO(idPName, "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/idp/idp-name", "http://wso2.org/identity/idp");
        RowDTO connectorTypeDTO = this.createRowDTO(connectorType, "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/idp/connector-type", "http://wso2.org/identity/idp");
        RowDTO provisioningFlowDTO = this.createRowDTO("provisioning", "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/identity-action/action-name", "http://wso2.org/identity/identity-action");
        if (provisioningEntity.getOperation().equals(ProvisioningOperation.POST)) {
            RowDTO provisioningClaimGroupDTO = this.createRowDTO(StringUtils.substringBetween((String)provisioningEntity.getAttributes().get(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false)).toString(), (String)"[", (String)"]"), "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/provisioning/claim-group", "http://wso2.org/identity/provisioning");
            rowDTOs.add(provisioningClaimGroupDTO);
        }
        RowDTO provisioningOperationDTO = this.createRowDTO(provisioningEntity.getOperation().toString(), "http://www.w3.org/2001/XMLSchema#string", "http://wso2.org/identity/provisioning/provision-operation", "http://wso2.org/identity/provisioning");
        if (provisioningEntity.getInboundAttributes() != null) {
            for (Map.Entry<String, String> claim : provisioningEntity.getInboundAttributes().entrySet()) {
                String claimUri = claim.getKey();
                String claimValue = claim.getValue();
                RowDTO claimRowDTO = this.createRowDTO(claimValue, "http://www.w3.org/2001/XMLSchema#string", claimUri, "http://wso2.org/identity/user");
                rowDTOs.add(claimRowDTO);
            }
        }
        RowDTO environmentTypeDTO = this.createRowDTO(tenantDomainName, "http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:environment:environment-id", "urn:oasis:names:tc:xacml:3.0:attribute-category:environment");
        RowDTO dateDTO = this.createRowDTO(this.getCurrentDateTime("yyyy/MM/dd"), "http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:environment:current-date", "urn:oasis:names:tc:xacml:3.0:attribute-category:environment");
        RowDTO timeDTO = this.createRowDTO(this.getCurrentDateTime("HH:mm:ss"), "http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:environment:current-time", "urn:oasis:names:tc:xacml:3.0:attribute-category:environment");
        RowDTO dateTimeDTO = this.createRowDTO(this.getCurrentDateTime("yyyy/MM/dd HH:mm:ss"), "http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime", "urn:oasis:names:tc:xacml:3.0:attribute-category:environment");
        rowDTOs.add(tenatDomainDTO);
        rowDTOs.add(userDTO);
        rowDTOs.add(spNameDTO);
        rowDTOs.add(spTenantDomainNameDTO);
        rowDTOs.add(idpNameDTO);
        rowDTOs.add(provisioningFlowDTO);
        rowDTOs.add(connectorTypeDTO);
        rowDTOs.add(environmentTypeDTO);
        rowDTOs.add(dateDTO);
        rowDTOs.add(timeDTO);
        rowDTOs.add(dateTimeDTO);
        rowDTOs.add(provisioningOperationDTO);
        RequestDTO requestDTO = new RequestDTO();
        requestDTO.setRowDTOs(rowDTOs);
        return requestDTO;
    }

    private RowDTO createRowDTO(String resourceName, String dataType, String attributeId, String categoryValue) {
        RowDTO rowDTOTenant = new RowDTO();
        rowDTOTenant.setAttributeValue(resourceName);
        rowDTOTenant.setAttributeDataType(dataType);
        rowDTOTenant.setAttributeId(attributeId);
        rowDTOTenant.setCategory(categoryValue);
        return rowDTOTenant;
    }

    private boolean evaluateXACMLResponse(String xacmlResponse) throws IdentityProvisioningException {
        try {
            DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
            DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xacmlResponse));
            Document doc = db.parse(is);
            String decision = "";
            NodeList decisionNode = doc.getDocumentElement().getElementsByTagName("Decision");
            if (decisionNode != null && decisionNode.item(0) != null) {
                decision = decisionNode.item(0).getTextContent();
            }
            if (decision.equalsIgnoreCase("Permit") || decision.equalsIgnoreCase("Not Applicable")) {
                return true;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IdentityProvisioningException("Exception occurred while xacmlResponse processing", e);
        }
        return false;
    }

    private String getCurrentDateTime(String dateTimeFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeFormat);
        Calendar cal = Calendar.getInstance();
        return dateFormat.format(cal.getTime()).toString();
    }
}

