/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning.listener;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.provisioning.IdentityProvisioningException;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningConnectorCache;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningConnectorCacheEntry;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningConnectorCacheKey;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCache;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCacheEntry;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCacheKey;
import org.wso2.carbon.identity.provisioning.dao.ProvisioningManagementDAO;
import org.wso2.carbon.identity.provisioning.internal.ProvisioningServiceDataHolder;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.listener.AbstractIdentityProviderMgtListener;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class ProvisioningIdentityProviderMgtListener
extends AbstractIdentityProviderMgtListener {
    private static final Log log = LogFactory.getLog(ProvisioningIdentityProviderMgtListener.class);
    private static ProvisioningManagementDAO provisioningManagementDAO = new ProvisioningManagementDAO();

    public boolean doPreDeleteIdP(String idPName, String tenantDomain) throws IdentityProviderManagementException {
        try {
            this.destroyConnector(idPName, tenantDomain);
        }
        catch (IdentityProvisioningException e) {
            throw new IdentityProviderManagementException("Error when provisioning IDP deletion", (Throwable)((Object)e));
        }
        return true;
    }

    public boolean doPreDeleteIdPs(String tenantDomain) throws IdentityProviderManagementException {
        return super.doPreDeleteIdPs(tenantDomain);
    }

    public boolean doPreUpdateIdP(String oldIdPName, IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        try {
            this.destroyConnector(oldIdPName, tenantDomain);
        }
        catch (IdentityProvisioningException e) {
            throw new IdentityProviderManagementException("Error when provisioning IDP update", (Throwable)((Object)e));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnector(String identityProviderName, String tenantDomain) throws IdentityProvisioningException {
        try {
            int tenantId;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            ProvisioningConnectorCacheKey cacheKey = new ProvisioningConnectorCacheKey(identityProviderName, tenantDomain);
            ProvisioningConnectorCacheEntry entry = (ProvisioningConnectorCacheEntry)((Object)ProvisioningConnectorCache.getInstance().getValueFromCache((Serializable)((Object)cacheKey)));
            if (entry != null) {
                ProvisioningConnectorCache.getInstance().clearCacheEntry((Serializable)((Object)cacheKey));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provisioning cached entry removed for idp " + identityProviderName));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Provisioning cached entry not found for idp " + identityProviderName));
            }
            try {
                RealmService realmService = ProvisioningServiceDataHolder.getInstance().getRealmService();
                tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                throw new IdentityProvisioningException("Error occurred while retrieving tenant id from tenant domain", e);
            }
            try {
                List<String> serviceProviders = provisioningManagementDAO.getSPNamesOfProvisioningConnectorsByIDP(identityProviderName, tenantId);
                for (String serviceProvider : serviceProviders) {
                    ServiceProviderProvisioningConnectorCacheKey key = new ServiceProviderProvisioningConnectorCacheKey(serviceProvider, tenantDomain);
                    ServiceProviderProvisioningConnectorCacheEntry cacheEntry = (ServiceProviderProvisioningConnectorCacheEntry)((Object)ServiceProviderProvisioningConnectorCache.getInstance().getValueFromCache((Serializable)((Object)key)));
                    if (cacheEntry != null) {
                        ServiceProviderProvisioningConnectorCache.getInstance().clearCacheEntry((Serializable)((Object)key));
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Service Provider '" + serviceProvider + "' Provisioning cached entry removed for idp " + identityProviderName));
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Service Provider '" + serviceProvider + "' Provisioning cached entry not found for idp " + identityProviderName));
                }
            }
            catch (IdentityApplicationManagementException e) {
                throw new IdentityProvisioningException("Error occurred while removing cache entry from the service provider provisioning connector cache", e);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public int getDefaultOrderId() {
        return 20;
    }
}

