/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning.listener;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCache;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCacheEntry;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCacheKey;

public class ProvisioningApplicationMgtListener
extends AbstractApplicationMgtListener {
    private static Log log = LogFactory.getLog(ProvisioningApplicationMgtListener.class);

    public boolean doPreUpdateApplication(ServiceProvider serviceProvider, String tenantDomain, String username) throws IdentityApplicationManagementException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing cache entry for " + serviceProvider.getApplicationName()));
        }
        this.destroySpProvConnectors(serviceProvider.getApplicationName(), tenantDomain);
        return true;
    }

    public boolean doPreDeleteApplication(String applicationName, String tenantDomain, String username) throws IdentityApplicationManagementException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing cache entry for " + applicationName));
        }
        this.destroySpProvConnectors(applicationName, tenantDomain);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySpProvConnectors(String applicationName, String tenantDomain) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            ServiceProviderProvisioningConnectorCacheKey key = new ServiceProviderProvisioningConnectorCacheKey(applicationName, tenantDomain);
            ServiceProviderProvisioningConnectorCacheEntry entry = (ServiceProviderProvisioningConnectorCacheEntry)((Object)ServiceProviderProvisioningConnectorCache.getInstance().getValueFromCache((Serializable)((Object)key)));
            if (entry != null) {
                ServiceProviderProvisioningConnectorCache.getInstance().clearCacheEntry((Serializable)((Object)key));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provisioning cached entry removed for sp " + applicationName));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Provisioning cached entry not found for sp " + applicationName));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public int getDefaultOrderId() {
        return 20;
    }
}

