/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning.listener;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ProvisioningServiceProviderType;
import org.wso2.carbon.identity.application.common.model.ThreadLocalProvisioningServiceProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.provisioning.IdentityProvisioningException;
import org.wso2.carbon.identity.provisioning.OutboundProvisioningManager;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;
import org.wso2.carbon.identity.provisioning.ProvisioningEntityType;
import org.wso2.carbon.identity.provisioning.ProvisioningOperation;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class DefaultInboundUserProvisioningListener
extends AbstractIdentityUserOperationEventListener {
    public static final String WSO2_CARBON_DIALECT = "http://wso2.org/claims";
    private static final Log log = LogFactory.getLog(DefaultInboundUserProvisioningListener.class);

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 30;
    }

    public boolean doPreAddUser(String userName, Object credential, String[] roleList, Map<String, String> inboundAttributes, String profile, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (credential != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:password", null, null, (boolean)false), Arrays.asList(((StringBuffer)credential).toString()));
        }
        if (userName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        }
        if (roleList != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false), Arrays.asList(roleList));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, ProvisioningOperation.POST, outboundAttributes);
        provisioningEntity.setInboundAttributes(inboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPreSetUserClaimValues(String userName, Map<String, String> inboundAttributes, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (userName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, ProvisioningOperation.PUT, outboundAttributes);
        provisioningEntity.setInboundAttributes(inboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValues(String userName, String[] attributesToDelete, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable() || ArrayUtils.isEmpty((Object[])attributesToDelete)) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (userName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, ProvisioningOperation.PATCH, outboundAttributes);
        HashMap<String, String> inboundAttributes = new HashMap<String, String>();
        for (int i = 0; i < attributesToDelete.length; ++i) {
            inboundAttributes.put(attributesToDelete[i], "");
        }
        provisioningEntity.setInboundAttributes(inboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValue(String userName, String attributeToDelete, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (userName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, ProvisioningOperation.PATCH, outboundAttributes);
        HashMap<String, String> inboundAttributes = new HashMap<String, String>();
        inboundAttributes.put(attributeToDelete, "");
        provisioningEntity.setInboundAttributes(inboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPreDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, ProvisioningOperation.DELETE, outboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] userList = userStoreManager.getUserListOfRole(roleName);
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false), Arrays.asList(roleName));
        outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userList));
        outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:new:claim:user", null, null, (boolean)false), Arrays.asList(newUsers));
        outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:deleted:claim:user", null, null, (boolean)false), Arrays.asList(deletedUsers));
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to role : " + roleName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)roleName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.GROUP, domainAwareName, ProvisioningOperation.PUT, outboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] roleList = userStoreManager.getRoleListOfUser(userName);
        HashMap<String, String> inboundAttributes = new HashMap<String, String>();
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (userName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        }
        if (roleList != null && roleList.length > 0) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false), Arrays.asList(roleList));
        }
        if (newRoles != null && roleList.length > 0) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:new:claim:group", null, null, (boolean)false), Arrays.asList(newRoles));
        }
        if (deletedRoles != null && deletedRoles.length > 0) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:deleted:claim:group", null, null, (boolean)false), Arrays.asList(deletedRoles));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, ProvisioningOperation.PUT, outboundAttributes);
        Claim[] claimArray = null;
        try {
            claimArray = userStoreManager.getUserClaimValues(userName, null);
        }
        catch (UserStoreException e) {
            if (e.getMessage().contains("UserNotFound")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User " + userName + " not found in user store"));
                }
            }
            throw e;
        }
        if (claimArray != null) {
            for (Claim claim : claimArray) {
                inboundAttributes.put(claim.getClaimUri(), claim.getValue());
            }
        }
        provisioningEntity.setInboundAttributes(inboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPreAddRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (roleName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false), Arrays.asList(roleName));
        }
        if (userList != null && userList.length > 0) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userList));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + roleName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)roleName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.GROUP, domainAwareName, ProvisioningOperation.POST, outboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPreDeleteRole(String roleName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (roleName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false), Arrays.asList(roleName));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + roleName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)roleName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.GROUP, domainAwareName, ProvisioningOperation.DELETE, outboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPostUpdateCredential(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (credential != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:password", null, null, (boolean)false), Arrays.asList(credential.toString()));
        }
        if (userName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        }
        String domainName = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
        }
        String domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        ProvisioningEntity provisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, ProvisioningOperation.PATCH, outboundAttributes);
        String tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ThreadLocalProvisioningServiceProvider threadLocalServiceProvider = IdentityApplicationManagementUtil.getThreadLocalProvisioningServiceProvider();
        if (threadLocalServiceProvider != null) {
            String serviceProvider = threadLocalServiceProvider.getServiceProviderName();
            tenantDomainName = threadLocalServiceProvider.getTenantDomain();
            if (threadLocalServiceProvider.getServiceProviderType() == ProvisioningServiceProviderType.OAUTH) {
                try {
                    serviceProvider = ApplicationManagementService.getInstance().getServiceProviderNameByClientId(threadLocalServiceProvider.getServiceProviderName(), "oauth2", tenantDomainName);
                }
                catch (IdentityApplicationManagementException e) {
                    log.error((Object)"Error while provisioning", (Throwable)e);
                    return true;
                }
            }
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, serviceProvider, threadLocalServiceProvider.getClaimDialect(), tenantDomainName, threadLocalServiceProvider.isJustInTimeProvisioning());
        } else {
            OutboundProvisioningManager.getInstance().provision(provisioningEntity, "wso2carbon-local-sp", WSO2_CARBON_DIALECT, tenantDomainName, false);
        }
        return true;
    }

    public boolean doPostUpdateCredentialByAdmin(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        return this.doPostUpdateCredential(userName, credential, userStoreManager);
    }
}

