/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning.internal;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.common.ProvisioningConnectorService;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.entitlement.EntitlementService;
import org.wso2.carbon.identity.provisioning.AbstractProvisioningConnectorFactory;
import org.wso2.carbon.identity.provisioning.internal.ProvisioningServiceDataHolder;
import org.wso2.carbon.identity.provisioning.listener.DefaultInboundUserProvisioningListener;
import org.wso2.carbon.identity.provisioning.listener.ProvisioningApplicationMgtListener;
import org.wso2.carbon.identity.provisioning.listener.ProvisioningIdentityProviderMgtListener;
import org.wso2.carbon.idp.mgt.listener.IdentityProviderMgtListener;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.provision.internal.IdentityProvisionServiceComponent", immediate=true)
public class IdentityProvisionServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityProvisionServiceComponent.class);

    public static RealmService getRealmService() {
        return ProvisioningServiceDataHolder.getInstance().getRealmService();
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        ProvisioningServiceDataHolder.getInstance().setRealmService(realmService);
    }

    public static RegistryService getRegistryService() {
        return ProvisioningServiceDataHolder.getInstance().getRegistryService();
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service");
        }
        ProvisioningServiceDataHolder.getInstance().setRegistryService(registryService);
    }

    public static Map<String, AbstractProvisioningConnectorFactory> getConnectorFactories() {
        return ProvisioningServiceDataHolder.getInstance().getConnectorFactories();
    }

    @Activate
    protected void activate(ComponentContext context) {
        try {
            ProvisioningServiceDataHolder.getInstance().setBundleContext(context.getBundleContext());
            ProvisioningServiceDataHolder.getInstance().getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new DefaultInboundUserProvisioningListener(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Provision Event listener registered successfully");
            }
            ProvisioningServiceDataHolder.getInstance().getBundleContext().registerService(ApplicationMgtListener.class.getName(), (Object)new ProvisioningApplicationMgtListener(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Application Management Event listener registered successfully");
            }
            ProvisioningServiceDataHolder.getInstance().getBundleContext().registerService(IdentityProviderMgtListener.class.getName(), (Object)new ProvisioningIdentityProviderMgtListener(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Provider Management Event listener registered successfully");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Provisioning framework bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while initiating identity provisioning connector framework", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Provision bundle is de-activated");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Registry Service");
        }
        ProvisioningServiceDataHolder.getInstance().setRegistryService(null);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Realm Service");
        }
        ProvisioningServiceDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="provisioning.connector.factory", service=AbstractProvisioningConnectorFactory.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetProvisioningConnectorFactory")
    protected void setProvisioningConnectorFactory(AbstractProvisioningConnectorFactory connectorFactory) {
        ProvisioningServiceDataHolder.getInstance().getConnectorFactories().put(connectorFactory.getConnectorType(), connectorFactory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added provisioning connector : " + connectorFactory.getConnectorType()));
        }
        ProvisioningConnectorConfig provisioningConnectorConfig = new ProvisioningConnectorConfig();
        provisioningConnectorConfig.setName(connectorFactory.getConnectorType());
        Property[] property = new Property[connectorFactory.getConfigurationProperties().size()];
        provisioningConnectorConfig.setProvisioningProperties(connectorFactory.getConfigurationProperties().toArray(property));
        ProvisioningConnectorService.getInstance().addProvisioningConnectorConfigs(provisioningConnectorConfig);
    }

    protected void unsetProvisioningConnectorFactory(AbstractProvisioningConnectorFactory connectorFactory) {
        ProvisioningServiceDataHolder.getInstance().getConnectorFactories().values().remove(connectorFactory);
        ProvisioningConnectorConfig provisioningConnectorConfig = ProvisioningConnectorService.getInstance().getProvisioningConnectorByName(connectorFactory.getConnectorType());
        ProvisioningConnectorService.getInstance().removeProvisioningConnectorConfigs(provisioningConnectorConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed provisioning connector : " + connectorFactory.getConnectorType()));
        }
    }

    @Reference(name="identity.entitlement.service", service=EntitlementService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetEntitlementService")
    protected void setEntitlementService(EntitlementService entitlementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"EntitlementService is set in the Application Authentication Framework bundle");
        }
        ProvisioningServiceDataHolder.getInstance().setEntitlementService(entitlementService);
    }

    protected void unsetEntitlementService(EntitlementService entitlementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"EntitlementService is unset in the Application Authentication Framework bundle");
        }
        ProvisioningServiceDataHolder.getInstance().setEntitlementService(null);
    }
}

