/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning.dao;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.persistence.JDBCPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provisioning.ProvisionedIdentifier;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;
import org.wso2.carbon.identity.provisioning.ProvisioningUtil;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ProvisioningManagementDAO {
    private static final Log log = LogFactory.getLog(ProvisioningManagementDAO.class);

    public void addProvisioningEntity(String identityProviderName, String connectorType, ProvisioningEntity provisioningEntity, int tenantId) throws IdentityApplicationManagementException {
        PreparedStatement prepStmt = null;
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        try {
            int idpId = this.getIdentityProviderIdentifier(dbConnection, identityProviderName, tenantId);
            int provisioningConfigId = this.getProvisioningConfigurationIdentifier(dbConnection, idpId, connectorType);
            String localId = this.getLocalIdFromProvisioningEntity(provisioningEntity);
            String sqlStmt = "INSERT INTO IDP_PROVISIONING_ENTITY (PROVISIONING_CONFIG_ID, ENTITY_TYPE, ENTITY_LOCAL_USERSTORE, ENTITY_NAME, ENTITY_VALUE, TENANT_ID, ENTITY_LOCAL_ID) VALUES (?, ?, ?, ?, ?, ?,?)";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, provisioningConfigId);
            prepStmt.setString(2, provisioningEntity.getEntityType().toString());
            prepStmt.setString(3, IdentityUtil.extractDomainFromName((String)provisioningEntity.getEntityName()));
            prepStmt.setString(4, UserCoreUtil.removeDomainFromName((String)provisioningEntity.getEntityName()));
            prepStmt.setString(5, provisioningEntity.getIdentifier().getIdentifier());
            prepStmt.setInt(6, tenantId);
            prepStmt.setString(7, localId);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
                String msg = "Error occurred while adding Provisioning entity for tenant " + tenantId;
                throw new IdentityApplicationManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, (PreparedStatement)prepStmt);
    }

    public void deleteProvisioningEntity(String identityProviderName, String connectorType, ProvisioningEntity provisioningEntity, int tenantId) throws IdentityApplicationManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            int idpId = this.getIdentityProviderIdentifier(dbConnection, identityProviderName, tenantId);
            int provisioningConfigId = this.getProvisioningConfigurationIdentifier(dbConnection, idpId, connectorType);
            String sqlStmt = "DELETE FROM IDP_PROVISIONING_ENTITY WHERE (PROVISIONING_CONFIG_ID=? AND ENTITY_TYPE=? AND ENTITY_LOCAL_USERSTORE=? AND ENTITY_NAME=? AND TENANT_ID=?)";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, provisioningConfigId);
            prepStmt.setString(2, provisioningEntity.getEntityType().toString());
            prepStmt.setString(3, IdentityUtil.extractDomainFromName((String)provisioningEntity.getEntityName()));
            prepStmt.setString(4, UserCoreUtil.removeDomainFromName((String)provisioningEntity.getEntityName()));
            prepStmt.setInt(5, tenantId);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
                String msg = "Error occurred while deleting Provisioning entity for tenant " + tenantId;
                throw new IdentityApplicationManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, (PreparedStatement)prepStmt);
    }

    public ProvisionedIdentifier getProvisionedIdentifier(String identityProviderName, String connectorType, ProvisioningEntity provisioningEntity, int tenantId) throws IdentityApplicationManagementException {
        ProvisionedIdentifier provisionedIdentifier;
        Connection dbConnection;
        ResultSet rs;
        PreparedStatement prepStmt;
        block5: {
            prepStmt = null;
            rs = null;
            dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            int idpId = this.getIdentityProviderIdentifier(dbConnection, identityProviderName, tenantId);
            int provisioningConfigId = this.getProvisioningConfigurationIdentifier(dbConnection, idpId, connectorType);
            String sqlStmt = "SELECT ENTITY_VALUE FROM IDP_PROVISIONING_ENTITY WHERE PROVISIONING_CONFIG_ID=? AND ENTITY_TYPE=? AND ENTITY_LOCAL_USERSTORE=? AND ENTITY_NAME=? AND TENANT_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, provisioningConfigId);
            prepStmt.setString(2, provisioningEntity.getEntityType().toString());
            prepStmt.setString(3, IdentityUtil.extractDomainFromName((String)provisioningEntity.getEntityName()));
            prepStmt.setString(4, UserCoreUtil.removeDomainFromName((String)provisioningEntity.getEntityName()));
            prepStmt.setInt(5, tenantId);
            rs = prepStmt.executeQuery();
            if (!rs.next()) break block5;
            String entityId = rs.getString(1);
            ProvisionedIdentifier provisionedIdentifier2 = new ProvisionedIdentifier();
            provisionedIdentifier2.setIdentifier(entityId);
            ProvisionedIdentifier provisionedIdentifier3 = provisionedIdentifier2;
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
            return provisionedIdentifier3;
        }
        try {
            provisionedIdentifier = null;
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while adding Provisioning entity for tenant " + tenantId;
                throw new IdentityApplicationManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return provisionedIdentifier;
    }

    public void updateProvisionedIdentifier(IdentityProvider newIdentityProvider, IdentityProvider currentIdentityProvider, int tenantId) throws IdentityApplicationManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            int idPId = this.getIdentityProviderIdByName(dbConnection, newIdentityProvider.getIdentityProviderName(), tenantId);
            if (idPId <= 0) {
                String msg = "Trying to update non-existent Identity Provider for tenant " + tenantId;
                throw new IdentityApplicationManagementException(msg);
            }
            String sqlStmt = "UPDATE IDP SET NAME=?, IS_PRIMARY=?, HOME_REALM_ID=?, CERTIFICATE=?, ALIAS=?, INBOUND_PROV_ENABLED=?, INBOUND_PROV_USER_STORE_ID=?,USER_CLAIM_URI=?, ROLE_CLAIM_URI=?, DEFAULT_AUTHENTICATOR_NAME=?, DEFAULT_PRO_CONNECTOR_NAME=?, DESCRIPTION=?, IS_FEDERATION_HUB=?, IS_LOCAL_CLAIM_DIALECT=?, PROVISIONING_ROLE=?, IS_ENABLED=?, DISPLAY_NAME=?  WHERE TENANT_ID=? AND NAME=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, newIdentityProvider.getIdentityProviderName());
            if (newIdentityProvider.isPrimary()) {
                prepStmt.setString(2, "1");
            } else {
                prepStmt.setString(2, "0");
            }
            prepStmt.setString(3, newIdentityProvider.getHomeRealmId());
            JSONArray certificateInfoJsonArray = new JSONArray((Object)newIdentityProvider.getCertificateInfoArray());
            prepStmt.setBinaryStream(4, this.setBlobValue(certificateInfoJsonArray.toString()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Certificate has been saved in the database as a JSON array: " + certificateInfoJsonArray));
            }
            prepStmt.setString(5, newIdentityProvider.getAlias());
            if (newIdentityProvider.getJustInTimeProvisioningConfig() != null && newIdentityProvider.getJustInTimeProvisioningConfig().isProvisioningEnabled()) {
                prepStmt.setString(6, "1");
                prepStmt.setString(7, newIdentityProvider.getJustInTimeProvisioningConfig().getProvisioningUserStore());
            } else {
                prepStmt.setString(6, "0");
                prepStmt.setString(7, null);
            }
            if (newIdentityProvider.getClaimConfig() != null) {
                prepStmt.setString(8, newIdentityProvider.getClaimConfig().getUserClaimURI());
                prepStmt.setString(9, newIdentityProvider.getClaimConfig().getRoleClaimURI());
            } else {
                prepStmt.setString(8, null);
                prepStmt.setString(9, null);
            }
            if (newIdentityProvider.getDefaultAuthenticatorConfig() != null && newIdentityProvider.getDefaultAuthenticatorConfig().getName() != null) {
                prepStmt.setString(10, newIdentityProvider.getDefaultAuthenticatorConfig().getName());
            } else {
                prepStmt.setString(10, null);
            }
            if (newIdentityProvider.getDefaultProvisioningConnectorConfig() != null && newIdentityProvider.getDefaultProvisioningConnectorConfig().getName() != null) {
                prepStmt.setString(11, newIdentityProvider.getDefaultProvisioningConnectorConfig().getName());
            } else {
                prepStmt.setString(11, null);
            }
            prepStmt.setString(12, newIdentityProvider.getIdentityProviderDescription());
            prepStmt.setInt(13, tenantId);
            prepStmt.setString(14, currentIdentityProvider.getIdentityProviderName());
            prepStmt.executeUpdate();
            prepStmt.clearParameters();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
                String msg = "Error occurred while updating Identity Provider information  for tenant " + tenantId;
                throw new IdentityApplicationManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, (PreparedStatement)prepStmt);
    }

    public void deleteProvisionedIdentifier(String idPName, int tenantId, String tenantDomain) throws IdentityApplicationManagementException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIdP(Connection conn, int tenantId, String idPName) throws SQLException {
        PreparedStatement prepStmt = null;
        String sqlStmt = "DELETE FROM IDP WHERE (TENANT_ID=? AND NAME=?)";
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, idPName);
            prepStmt.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdentityProviderIdByName(Connection dbConnection, String idpName, int tenantId) throws SQLException, IdentityApplicationManagementException {
        ResultSet rs;
        PreparedStatement prepStmt;
        boolean dbConnInitialized;
        block7: {
            int n;
            dbConnInitialized = true;
            prepStmt = null;
            rs = null;
            if (dbConnection == null) {
                dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            } else {
                dbConnInitialized = false;
            }
            try {
                String sqlStmt = "SELECT ID FROM IDP WHERE ((TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND NAME = ?)";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, idpName);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block7;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(prepStmt);
                IdentityApplicationManagementUtil.closeResultSet(rs);
                if (dbConnInitialized) {
                    IdentityApplicationManagementUtil.closeConnection((Connection)dbConnection);
                }
                throw throwable;
            }
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)rs);
            if (dbConnInitialized) {
                IdentityApplicationManagementUtil.closeConnection((Connection)dbConnection);
            }
            return n;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)rs);
        if (dbConnInitialized) {
            IdentityApplicationManagementUtil.closeConnection((Connection)dbConnection);
        }
        return 0;
    }

    private int getIdentityProviderIdentifier(Connection dbConnection, String idPName, int tenantId) throws SQLException, IdentityApplicationManagementException {
        block3: {
            int n;
            PreparedStatement prepStmt = null;
            ResultSet rs = null;
            try {
                String sqlStmt = "SELECT ID FROM IDP WHERE TENANT_ID=? AND NAME=?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, idPName);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeResultSet(rs);
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)rs);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
            return n;
        }
        throw new IdentityApplicationManagementException("Invalid Identity Provider Name " + idPName);
    }

    private int getProvisioningConfigurationIdentifier(Connection dbConnection, int idPId, String connectorType) throws SQLException, IdentityApplicationManagementException {
        block3: {
            int n;
            PreparedStatement prepStmt = null;
            ResultSet rs = null;
            try {
                String sqlStmt = "SELECT ID FROM IDP_PROVISIONING_CONFIG WHERE IDP_ID=? AND PROVISIONING_CONNECTOR_TYPE=?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setInt(1, idPId);
                prepStmt.setString(2, connectorType);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeResultSet(rs);
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)rs);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
            return n;
        }
        throw new IdentityApplicationManagementException("Invalid connector type " + connectorType);
    }

    private InputStream setBlobValue(String value) throws SQLException {
        if (value != null) {
            return new ByteArrayInputStream(value.getBytes());
        }
        return null;
    }

    public List<String> getSPNamesOfProvisioningConnectorsByIDP(String idPName, int tenantId) throws IdentityApplicationManagementException {
        ArrayList<String> spNames;
        ResultSet rs;
        Connection dbConnection;
        block8: {
            dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            PreparedStatement prepStmt = null;
            rs = null;
            spNames = new ArrayList<String>();
            try {
                String sqlStmt = "SELECT DISTINCT(APP.APP_NAME) FROM SP_PROVISIONING_CONNECTOR PC JOIN SP_APP APP ON APP.ID = PC.APP_ID WHERE PC.IDP_NAME = ? AND APP.TENANT_ID = PC.TENANT_ID AND APP.TENANT_ID = ?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setString(1, idPName);
                prepStmt.setInt(2, tenantId);
                rs = prepStmt.executeQuery();
                while (rs.next()) {
                    spNames.add(rs.getString(1));
                }
                if (prepStmt == null) break block8;
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while retrieving SP names of provisioning connectors by IDP name";
                    throw new IdentityApplicationManagementException(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (prepStmt != null) {
                        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
                    }
                    if (rs != null) {
                        IdentityApplicationManagementUtil.closeResultSet(rs);
                    }
                    IdentityApplicationManagementUtil.closeConnection((Connection)dbConnection);
                    throw throwable;
                }
            }
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        }
        if (rs != null) {
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)rs);
        }
        IdentityApplicationManagementUtil.closeConnection((Connection)dbConnection);
        return spNames;
    }

    private String getLocalIdFromProvisioningEntity(ProvisioningEntity provisioningEntity) {
        List<String> attributeValues;
        Map<ClaimMapping, List<String>> attributeMap = provisioningEntity.getAttributes();
        if (!attributeMap.isEmpty() && (attributeValues = attributeMap.get(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:id", null, null, (boolean)false))) != null && !attributeValues.isEmpty()) {
            return attributeValues.get(0);
        }
        return null;
    }

    public String getProvisionedEntityNameByLocalId(String localId) throws IdentityApplicationManagementException {
        ResultSet rs;
        PreparedStatement prepStmt;
        Connection dbConnection;
        block5: {
            dbConnection = null;
            prepStmt = null;
            rs = null;
            dbConnection = JDBCPersistenceManager.getInstance().getDBConnection();
            String sqlStmt = "SELECT ENTITY_NAME FROM IDP_PROVISIONING_ENTITY WHERE ENTITY_LOCAL_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, localId);
            rs = prepStmt.executeQuery();
            JDBCPersistenceManager.getInstance().commitTransaction(dbConnection);
            if (!rs.next()) break block5;
            String string = rs.getString(1);
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
            return string;
        }
        try {
            try {
                throw new IdentityApplicationManagementException("Given Local ID :" + localId + " does not exist");
            }
            catch (SQLException e) {
                JDBCPersistenceManager.getInstance().rollbackTransaction(dbConnection);
                throw new IdentityApplicationManagementException("Error occurred while loading Provisioned Entity Name from DB", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, prepStmt);
            throw throwable;
        }
    }

    public void updateProvisioningEntityName(ProvisioningEntity provisioningEntity) throws IdentityApplicationManagementException {
        Connection dbConnection = null;
        String provisioningEntityName = null;
        String entityLocalID = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = JDBCPersistenceManager.getInstance().getDBConnection();
            String sqlStmt = "UPDATE IDP_PROVISIONING_ENTITY SET ENTITY_NAME=? WHERE ENTITY_LOCAL_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            provisioningEntityName = ProvisioningUtil.getAttributeValue(provisioningEntity, "org:wso2:carbon:identity:provisioning:claim:group:name:new");
            entityLocalID = ProvisioningUtil.getAttributeValue(provisioningEntity, "org:wso2:carbon:identity:provisioning:claim:id");
            prepStmt.setString(1, provisioningEntityName);
            prepStmt.setString(2, entityLocalID);
            prepStmt.execute();
            JDBCPersistenceManager.getInstance().commitTransaction(dbConnection);
        }
        catch (SQLException e) {
            try {
                JDBCPersistenceManager.getInstance().rollbackTransaction(dbConnection);
                String msg = "Error occurred while Updating Provisioning entity name to " + provisioningEntityName + " for Entity Local Id :" + entityLocalID;
                throw new IdentityApplicationManagementException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{prepStmt});
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{prepStmt});
    }
}

